/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.openspml.v2.util.Spml2Exception;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser
implements ErrorHandler,
EntityResolver {
    public static final String code_id = "$Id: XmlParser.java,v 1.5 2006/10/18 16:57:36 kas Exp $";
    private static XmlParser _pool;
    private static XmlParser _validatingPool;
    private static String _logFailuresFile;
    private static final int _maxUsages = 10000;
    private DocumentBuilderFactory _factory = null;
    private DocumentBuilder _parser;
    private XmlParser _next;
    private boolean _inPool;
    private int _usages;

    private static synchronized XmlParser getParser(boolean validating) {
        XmlParser p = null;
        if (!validating) {
            if (_pool != null) {
                p = _pool;
                _pool = p.getNext();
            }
        } else if (_validatingPool != null) {
            p = _validatingPool;
            _validatingPool = p.getNext();
        }
        if (p == null) {
            try {
                p = new XmlParser(validating);
            }
            catch (ParserConfigurationException e) {
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                // empty catch block
            }
        }
        if (p != null) {
            p.setPooled(false);
            p.incUsages();
        }
        return p;
    }

    private static synchronized void poolParser(XmlParser p) {
        if (!p.isPooled() && p.getUsages() < 10000) {
            if (p._parser.isValidating()) {
                p.setNext(_validatingPool);
                _validatingPool = p;
            } else {
                p.setNext(_pool);
                _pool = p;
            }
            p.setPooled(true);
        }
    }

    private XmlParser(boolean validating) throws ParserConfigurationException, FactoryConfigurationError {
        this.getDOMParser(this, this, validating);
    }

    private void getDOMParser(ErrorHandler eh, EntityResolver er, boolean validating) throws ParserConfigurationException, FactoryConfigurationError {
        if (this._factory == null) {
            this._factory = DocumentBuilderFactory.newInstance();
        }
        this._factory.setNamespaceAware(true);
        if (validating) {
            this._factory.setValidating(validating);
        }
        this._parser = this._factory.newDocumentBuilder();
        if (eh != null) {
            this._parser.setErrorHandler(eh);
        }
        if (er != null) {
            this._parser.setEntityResolver(er);
        }
    }

    private void getDOMParser(ErrorHandler eh, EntityResolver er) throws ParserConfigurationException, FactoryConfigurationError {
        this.getDOMParser(eh, er, false);
    }

    private XmlParser getNext() {
        return this._next;
    }

    private void setNext(XmlParser p) {
        this._next = p;
    }

    private boolean isPooled() {
        return this._inPool;
    }

    private void setPooled(boolean b) {
        this._inPool = b;
    }

    private void incUsages() {
        ++this._usages;
    }

    private int getUsages() {
        return this._usages;
    }

    private Document parseString(String xml) throws Spml2Exception {
        Document doc = null;
        StringReader reader = null;
        if (this._parser.isValidating()) {
            reader = new StringReader(xml);
        } else {
            int index = xml.indexOf("DOCTYPE");
            if (index != -1) {
                while (index < xml.length()) {
                    if (xml.charAt(index) == '>') {
                        ++index;
                        break;
                    }
                    ++index;
                }
                if (index < xml.length()) {
                    xml = xml.substring(index);
                }
            }
            reader = new StringReader(xml);
        }
        InputSource is = new InputSource(reader);
        try {
            doc = this._parser.parse(is);
        }
        catch (SAXParseException ex) {
            this.logFailure(xml);
            String msg = "XML Error " + this.getLocationString(ex) + ": " + ex.getMessage();
            throw new Spml2Exception(msg, ex);
        }
        catch (SAXException ex) {
            try {
                this.getDOMParser(this, this);
            }
            catch (ParserConfigurationException e) {
                this._parser = null;
                throw new Spml2Exception(e);
            }
            catch (FactoryConfigurationError er) {
                this._parser = null;
                throw new Spml2Exception(er);
            }
            this.logFailure(xml);
            this.wrapException(ex);
        }
        catch (IOException ex) {
            throw new Spml2Exception(ex);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logFailure(String xml) {
        if (_logFailuresFile != null) {
            try {
                File path = new File(_logFailuresFile);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(path);
                    fos.write(xml.getBytes());
                }
                finally {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public InputSource resolveEntity(String pubid, String sysid) throws SAXException, IOException {
        String path;
        File f;
        InputSource is = null;
        String cwd = System.getProperty("user.dir");
        if (cwd != null && (f = new File(path = cwd + File.separator + pubid)).exists()) {
            is = new InputSource(new FileReader(f));
        }
        return is;
    }

    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void error(SAXParseException ex) throws SAXParseException {
        throw ex;
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    private void wrapException(SAXException e) throws Spml2Exception {
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            String msg = "XML Error" + this.getLocationString(spe) + ": " + spe.getMessage();
            throw new Spml2Exception(msg, e);
        }
        Exception wrapped = e.getException();
        if (wrapped == null) {
            throw new Spml2Exception(e);
        }
        if (wrapped instanceof Spml2Exception) {
            throw (Spml2Exception)wrapped;
        }
        if (wrapped instanceof RuntimeException) {
            throw (RuntimeException)wrapped;
        }
        throw new Spml2Exception(wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parse(String xml) throws Spml2Exception {
        Document d = null;
        XmlParser p = XmlParser.getParser(false);
        try {
            d = p.parseString(xml);
        }
        finally {
            XmlParser.poolParser(p);
        }
        return d;
    }

    public static void setLogFailuresFile(File file) {
        _logFailuresFile = file.toString();
    }

    static {
        _logFailuresFile = null;
    }
}

