/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlElement {
    public static final String code_id = "$Id: XmlElement.java,v 1.1 2006/05/18 00:21:44 kas Exp $";
    private Element _el;

    public XmlElement(Element e) {
        assert (e != null);
        this._el = e;
    }

    public String getTagName() {
        return this._el.getTagName();
    }

    public String getLocalName() {
        return this._el.getLocalName();
    }

    public String getPrefix() {
        return this._el.getPrefix();
    }

    public String getNamespaceURI() {
        return this._el.getNamespaceURI();
    }

    public static String stripPrefix(String value) {
        int sharp;
        String tail = value;
        if (value != null && (sharp = value.indexOf("#")) >= 0) {
            tail = value.substring(sharp + 1);
        }
        return tail;
    }

    public String getAttribute(String name) {
        String value = null;
        value = this._el.getAttribute(name);
        if (value != null && value.length() == 0) {
            value = null;
        }
        return value;
    }

    public boolean getBooleanAttribute(String name) {
        String value = this._el.getAttribute(name);
        return value.equals("true") || value.equals("1");
    }

    public XmlElement getChildElement() {
        XmlElement found = null;
        for (Node child = this._el.getFirstChild(); child != null && found == null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            found = new XmlElement((Element)child);
            break;
        }
        return found;
    }

    public XmlElement getChildElement(String localName) {
        XmlElement found = null;
        for (XmlElement e = this.getChildElement(); e != null && found == null; e = e.getNextElement()) {
            if (!localName.equals(e.getLocalName())) continue;
            found = e;
        }
        return found;
    }

    public XmlElement getNextElement() {
        XmlElement found = null;
        for (Node next = this._el.getNextSibling(); next != null && found == null; next = next.getNextSibling()) {
            if (next.getNodeType() != 1) continue;
            found = new XmlElement((Element)next);
            break;
        }
        return found;
    }

    public XmlElement next() {
        XmlElement found = null;
        for (Node next = this._el.getNextSibling(); next != null && found == null; next = next.getNextSibling()) {
            if (next.getNodeType() != 1) continue;
            this._el = (Element)next;
            found = this;
            break;
        }
        return found;
    }

    public String getContent() {
        String content = null;
        Text t = this.findText(this._el, false);
        if (t != null) {
            StringBuffer b = new StringBuffer();
            while (t != null) {
                b.append(t.getData());
                Node n = t.getNextSibling();
                t = null;
                if (n == null || n.getNodeType() != 3 && n.getNodeType() != 4) continue;
                t = (Text)n;
            }
            content = b.toString();
        }
        return content;
    }

    private Text findText(Node node, boolean ignoreEmpty) {
        Text found = null;
        if (node != null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                Text t = (Text)node;
                if (!ignoreEmpty) {
                    found = t;
                } else {
                    String s = t.getData();
                    boolean empty = true;
                    for (int i = 0; i < s.length(); ++i) {
                        if (Character.isWhitespace(s.charAt(i))) continue;
                        empty = false;
                        break;
                    }
                    if (!empty) {
                        found = t;
                    }
                }
            }
            if (found == null) {
                for (Node child = node.getFirstChild(); child != null && found == null; child = child.getNextSibling()) {
                    found = this.findText(child, ignoreEmpty);
                }
            }
        }
        return found;
    }
}

