/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util.xml;

import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OCEtoMarshallableAdapter;
import org.openspml.v2.msg.OCEtoXMLStringAdapter;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.XMLUnmarshaller;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.BasicMarshallable;
import org.openspml.v2.util.xml.ReflectiveDOMXMLUnmarshaller;
import org.openspml.v2.util.xml.ReflectiveXMLMarshaller;
import org.openspml.v2.util.xml.UnknownSpml2TypeException;

public abstract class BasicOCEAndMarshallable
extends BasicMarshallable
implements OpenContentElement {
    protected final XMLMarshaller mMarshaller = new ReflectiveXMLMarshaller();
    protected final XMLUnmarshaller mUnmarshaller = new ReflectiveDOMXMLUnmarshaller();

    protected BasicOCEAndMarshallable() {
    }

    public String toXML(int indent) throws Spml2Exception {
        this.mMarshaller.setIndent(indent);
        String xml = this.mMarshaller.marshall(this);
        return xml;
    }

    public String toXML() throws Spml2Exception {
        return this.toXML(0);
    }

    public OpenContentElement fromXML(Object xmlRep) throws Spml2Exception {
        if (xmlRep instanceof String) {
            Marshallable m = null;
            try {
                m = this.mUnmarshaller.unmarshall(xmlRep.toString());
                if (m != null) {
                    return new OCEtoMarshallableAdapter(m);
                }
            }
            catch (UnknownSpml2TypeException e) {
                return new OCEtoXMLStringAdapter(xmlRep.toString());
            }
        }
        return null;
    }
}

