/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openspml.v2.transport.RPCRouter;
import org.openspml.v2.transport.RPCRouterMonitor;

public class SwingRPCRouterMonitor
extends JFrame
implements RPCRouterMonitor {
    private static final String code_id = "$Id: SwingRPCRouterMonitor.java,v 1.3 2006/08/30 18:02:59 kas Exp $";
    private RPCRouter[] _listeners;
    private JButton _clear;
    private JTextArea _trace;

    public static void println(String msg) {
        System.out.println(msg);
    }

    public SwingRPCRouterMonitor() {
        this.enableEvents(64L);
        try {
            this.initComponents();
            this.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addListener(RPCRouter l) {
        if (this._listeners == null) {
            this._listeners = new RPCRouter[1];
        } else {
            ArrayList<RPCRouter> temp = new ArrayList<RPCRouter>(Arrays.asList(this._listeners));
            temp.add(l);
            this._listeners = temp.toArray(new RPCRouter[temp.size()]);
        }
    }

    public void removeListener(RPCRouter l) {
        if (this._listeners != null) {
            ArrayList<RPCRouter> temp = new ArrayList<RPCRouter>(Arrays.asList(this._listeners));
            temp.remove(l);
            this._listeners = temp.toArray(new RPCRouter[temp.size()]);
            l.closed(this);
        }
    }

    private void initComponents() throws Exception {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setPreferredSize(new Dimension(400, 600));
        URL imageURL = this.getClass().getResource("openSpml.gif");
        if (imageURL != null) {
            ImageIcon spmlIcon = new ImageIcon(imageURL);
            this.setIconImage(spmlIcon.getImage());
        }
        this.setSize(new Dimension(1000, 700));
        String shortName = this.getClass().getName();
        shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        this.setTitle("OpenSPML 2.0 - " + shortName);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu();
        menuBar.add(menu);
        menu.setText("File");
        JMenuItem item = new JMenuItem();
        menu.add(item);
        item.setText("Exit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingRPCRouterMonitor.this.dispose();
            }
        });
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        this._clear = new JButton("Clear");
        buttons.add(this._clear);
        this._clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingRPCRouterMonitor.this._trace.setText(null);
            }
        });
        contentPane.add((Component)buttons, "South");
        this._trace = new JTextArea();
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add((Component)this._trace, null);
        contentPane.add((Component)sp, "Center");
    }

    private void informListenersOfClose() {
        if (this._listeners != null) {
            for (int i = 0; i < this._listeners.length; ++i) {
                RPCRouter l = this._listeners[i];
                if (l == null) continue;
                l.closed(this);
            }
            this._listeners = null;
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.informListenersOfClose();
        }
    }

    public void send(String payload) {
        if (this._trace == null) {
            return;
        }
        this._trace.append("\n------------------------------SEND------------------------------\n");
        this._trace.append(payload);
    }

    public void receive(String payload) {
        if (this._trace == null) {
            return;
        }
        this._trace.append("\n-----------------------------RECIEVE----------------------------\n");
        this._trace.append(payload);
    }

    public void trace(String msg) {
        if (this._trace == null) {
            return;
        }
        this._trace.append("TRACE: ");
        this._trace.append(msg);
        this._trace.append("\n");
    }
}

