/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util;

import java.util.Map;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.XMLUnmarshaller;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.provider.SPMLMarshaller;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ReflectiveDOMXMLUnmarshaller;
import org.openspml.v2.util.xml.ReflectiveXMLMarshaller;

public class SimpleSPMLMarshaller
implements SPMLMarshaller {
    private static final String code_id = "$Id: SimpleSPMLMarshaller.java,v 1.1 2006/03/15 23:56:51 kas Exp $";
    private static boolean _trace = false;
    private XMLUnmarshaller _unmarshaller = new ReflectiveDOMXMLUnmarshaller();
    private XMLMarshaller _marshaller = new ReflectiveXMLMarshaller();

    public void init(Map map) throws Spml2Exception {
        Object trace = map.get("trace");
        if (trace != null) {
            Boolean b = new Boolean(trace.toString());
            _trace = b;
        }
    }

    public String getUniqueName() {
        return "SimpleSPMLMarshaller";
    }

    public Request unmarshallRequest(String s) throws Spml2Exception {
        try {
            if (_trace) {
                System.out.println("unmarshalling:\n " + s);
            }
            return (Request)this._unmarshaller.unmarshall(s);
        }
        catch (ClassCastException cce) {
            throw new Spml2Exception(cce);
        }
    }

    public String marshallResponse(Response response) throws Spml2Exception {
        String xml = response.toXML(this._marshaller);
        if (_trace) {
            System.out.println("marshalled response to:\n" + xml);
        }
        return xml;
    }
}

