/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class EnumConstant
implements Serializable {
    private static final String code_id = "$Id: EnumConstant.java,v 1.1 2006/03/15 20:40:00 kas Exp $";
    private transient String _fieldName;

    private void writeObject(ObjectOutputStream out) throws IOException {
        Class<?> cls = this.getClass();
        Field[] f = cls.getDeclaredFields();
        try {
            for (int i = 0; i < f.length; ++i) {
                int mod = f[i].getModifiers();
                if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod) || this != f[i].get(null)) continue;
                String fName = f[i].getName();
                out.writeObject(fName);
            }
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            this._fieldName = (String)in.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            Class<?> clazz = this.getClass();
            Field f = clazz.getField(this._fieldName);
            return f.get(null);
        }
        catch (Exception ex) {
            throw new InvalidObjectException("Failed to resolve enum constant.");
        }
    }

    protected static List getEnumConstants(Class cls) {
        Field[] f = cls.getDeclaredFields();
        ArrayList<Object> temp = new ArrayList<Object>(f.length);
        for (int i = 0; i < f.length; ++i) {
            int mod = f[i].getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod) || !Modifier.isPublic(mod)) continue;
            try {
                temp.add(f[i].get(null));
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        EnumConstant[] e = temp.toArray(new EnumConstant[temp.size()]);
        return temp;
    }
}

