/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.transport;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openspml.v2.transport.RPCDispatcher;
import org.openspml.v2.transport.RPCRouter;
import org.openspml.v2.transport.RPCRouterMonitor;
import org.openspml.v2.transport.Spml2TransportException;
import org.openspml.v2.util.ReflectionUtil;
import org.openspml.v2.util.Spml2Exception;

public class RPCRouterServlet
extends HttpServlet
implements RPCRouter {
    private static final String code_id = "$Id: RPCRouterServlet.java,v 1.2 2006/09/25 18:50:07 kas Exp $";
    private static final String SPML_VIA_SOAP_DISPATCHER = "org.openspml.v2.transport.SPMLViaSoapDispatcher";
    private RPCDispatcher[] _dispatchers = new RPCDispatcher[0];
    private boolean _trace;
    private RPCRouterMonitor _monitor;
    private Method _setCharacterEncoding;
    private boolean _testedServletContainer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String s = config.getInitParameter("trace");
        if ("true".equals(s)) {
            this._trace = true;
        }
        List<String> dispatcherClassnames = null;
        s = config.getInitParameter("dispatchers");
        if (s != null) {
            dispatcherClassnames = Arrays.asList(s.split(","));
        }
        if (dispatcherClassnames == null) {
            dispatcherClassnames = new ArrayList<String>();
            dispatcherClassnames.add(SPML_VIA_SOAP_DISPATCHER);
        }
        ArrayList<RPCDispatcher> dispatcherList = new ArrayList<RPCDispatcher>();
        Map configMap = this.getConfigMap(config);
        try {
            for (String dispatcherName : dispatcherClassnames) {
                Object o = ReflectionUtil.instantiate(dispatcherName);
                if (o instanceof RPCDispatcher) {
                    RPCDispatcher rpcDispatcher = (RPCDispatcher)o;
                    try {
                        rpcDispatcher.init(configMap);
                    }
                    catch (Spml2TransportException e) {
                        throw new ServletException((Throwable)e);
                    }
                    dispatcherList.add(rpcDispatcher);
                    continue;
                }
                if (o == null) continue;
                this.log(dispatcherName + " does not implement " + RPCDispatcher.class.getName());
            }
            this._dispatchers = dispatcherList.toArray(new RPCDispatcher[dispatcherList.size()]);
            s = config.getInitParameter("monitor");
            if (s != null) {
                Object o = ReflectionUtil.instantiate(s);
                if (o instanceof RPCRouterMonitor) {
                    this.setMonitor((RPCRouterMonitor)o);
                } else if (o != null) {
                    this.log(s + " does not implement " + RPCRouterMonitor.class.getName());
                }
            }
        }
        catch (Spml2Exception e) {
            throw new ServletException(e.getCause());
        }
    }

    private Map getConfigMap(ServletConfig config) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            result.put(name, config.getInitParameter(name));
        }
        return result;
    }

    public void setMonitor(RPCRouterMonitor sm) {
        if (this._monitor != null) {
            this._monitor.removeListener(this);
        }
        this._monitor = sm;
        if (this._monitor != null) {
            this._monitor.addListener(this);
            this._monitor.trace("RPCRouterServlet is using this monitor.");
        }
    }

    public void closed(RPCRouterMonitor m) {
        if (this._monitor == m) {
            this._monitor = null;
        }
    }

    private void sendError(HttpServletResponse response, int code, String message) throws IOException {
        String err = "ERROR: " + message;
        if (this._monitor != null) {
            this._monitor.send(err);
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setStatus(code);
        PrintWriter out = response.getWriter();
        out.println(err);
        out.flush();
    }

    private void sendError(HttpServletResponse response, String message) throws IOException {
        this.sendError(response, 403, message);
    }

    private void sendResponse(HttpServletResponse response, String msg, String contentType) throws IOException {
        if (this._monitor != null) {
            this._monitor.send(msg);
        }
        response.setContentType(contentType);
        PrintWriter out = response.getWriter();
        out.println(msg);
        out.flush();
    }

    private void trace(String message) {
        if (this._trace) {
            System.out.print("RPCRouterServlet: ");
            System.out.println(message);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.sendError(res, this.getClass() + ": GET is unsupported");
    }

    public String getPostDataAsString(HttpServletRequest req) throws IOException {
        String post = null;
        int length = req.getContentLength();
        if (length > 0) {
            int thisRead;
            this.setCharacterEncoding(req);
            byte[] bytes = new byte[length];
            ServletInputStream is = req.getInputStream();
            for (int read = 0; read < length; read += thisRead) {
                int remaining = length - read;
                thisRead = is.readLine(bytes, read, remaining);
                if (thisRead >= 0) continue;
                throw new IOException("Underflow reading request message.");
            }
            post = new String(bytes, "UTF-8");
        }
        return post;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String post = null;
        try {
            post = this.getPostDataAsString(req);
        }
        catch (Exception ex) {
            String error = "Error reading request message.";
            this.log("Error reading request message.", ex);
            this.sendError(res, this.getClass() + ": " + "Error reading request message.");
            return;
        }
        if (null == post) {
            String error = "Empty request message.";
            this.log("Empty request message.");
            this.sendError(res, this.getClass() + ": " + "Empty request message.");
            return;
        }
        if (this._trace) {
            this.trace("\n" + post);
        }
        if (this._monitor != null) {
            this._monitor.receive(post);
        }
        try {
            String response = null;
            String contentType = null;
            for (RPCDispatcher dispatcher : this._dispatchers) {
                response = dispatcher.dispatchRequest(post);
                if (response == null) continue;
                contentType = dispatcher.getContentType();
                break;
            }
            if (response == null) {
                String error = "Unrecognized request message.";
                this.log("Unrecognized request message.");
                this.sendError(res, this.getClass() + ": " + "Unrecognized request message.");
            } else {
                if (this._trace) {
                    this.trace(" response:\n" + response);
                }
                this.sendResponse(res, response, contentType);
            }
        }
        catch (Exception ex) {
            String error = "Error processing request message.";
            this.log("Error processing request message.", ex);
            this.sendError(res, this.getClass() + ": " + "Error processing request message.");
        }
    }

    public void setCharacterEncoding(HttpServletRequest req) {
        if (!this._testedServletContainer) {
            try {
                Class<?> c = req.getClass();
                this._setCharacterEncoding = c.getMethod("setCharacterEncoding", String.class);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this._testedServletContainer = true;
        }
        if (this._setCharacterEncoding != null) {
            try {
                this._setCharacterEncoding.invoke((Object)req, "UTF-8");
            }
            catch (Throwable t) {
                this._setCharacterEncoding = null;
            }
        }
    }
}

