/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.profiles.spmldsml;

import java.util.Arrays;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.profiles.spmldsml.AttributeDefinition;
import org.openspml.v2.profiles.spmldsml.ExtensibleElement;
import org.openspml.v2.profiles.spmldsml.ObjectClassDefinition;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;
import org.openspml.v2.util.xml.ReflectiveXMLMarshaller;

public class DSMLSchema
extends ExtensibleElement
implements Marshallable,
OpenContentElement {
    private static final String code_id = "$Id: DSMLSchema.java,v 1.5 2006/10/04 01:06:12 kas Exp $";
    private ListWithType m_objectClassDefinition = new ArrayListWithType(ObjectClassDefinition.class);
    private ListWithType m_attributeDefinition = new ArrayListWithType(AttributeDefinition.class);

    public DSMLSchema() {
    }

    public DSMLSchema(ObjectClassDefinition[] objectClassDefs, AttributeDefinition[] attributeDefs) {
        if (objectClassDefs != null) {
            this.m_objectClassDefinition.addAll(Arrays.asList(objectClassDefs));
        }
        if (attributeDefs != null) {
            this.m_attributeDefinition.addAll(Arrays.asList(attributeDefs));
        }
    }

    public String getElementName() {
        return "schema";
    }

    public ObjectClassDefinition[] getObjectClassDefinitions() {
        return this.m_objectClassDefinition.toArray(new ObjectClassDefinition[this.m_objectClassDefinition.size()]);
    }

    public void addObjectClassDefinition(ObjectClassDefinition reference) {
        assert (reference != null);
        this.m_objectClassDefinition.add(reference);
    }

    public boolean removeObjectClassDefinition(ObjectClassDefinition reference) {
        assert (reference != null);
        return this.m_objectClassDefinition.remove(reference);
    }

    public void clearObjectClassDefinitions() {
        this.m_objectClassDefinition.clear();
    }

    public AttributeDefinition[] getAttributeDefinitions() {
        return this.m_attributeDefinition.toArray(new AttributeDefinition[this.m_attributeDefinition.size()]);
    }

    public void addAttributeDefinition(AttributeDefinition reference) {
        assert (reference != null);
        this.m_attributeDefinition.add(reference);
    }

    public boolean removeAttributeDefinition(AttributeDefinition reference) {
        assert (reference != null);
        return this.m_attributeDefinition.remove(reference);
    }

    public void clearAttributeDefinitions() {
        this.m_attributeDefinition.clear();
    }

    public String toXML(XMLMarshaller m) throws Spml2Exception {
        return m.marshall(this);
    }

    public boolean isValid() {
        return true;
    }

    public String toXML(int indent) throws Spml2Exception {
        ReflectiveXMLMarshaller m = new ReflectiveXMLMarshaller();
        m.setIndent(indent);
        return m.marshall(this);
    }

    public String toXML() throws Spml2Exception {
        return this.toXML(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DSMLSchema)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DSMLSchema schema = (DSMLSchema)o;
        if (this.m_attributeDefinition != null ? !this.m_attributeDefinition.equals(schema.m_attributeDefinition) : schema.m_attributeDefinition != null) {
            return false;
        }
        return !(this.m_objectClassDefinition != null ? !this.m_objectClassDefinition.equals(schema.m_objectClassDefinition) : schema.m_objectClassDefinition != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.m_objectClassDefinition != null ? this.m_objectClassDefinition.hashCode() : 0);
        result = 29 * result + (this.m_attributeDefinition != null ? this.m_attributeDefinition.hashCode() : 0);
        return result;
    }
}

