/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.profiles.dsml;

import java.util.Map;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLUnmarshaller;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.profiles.dsml.FilterItemVisitor;
import org.openspml.v2.profiles.dsml.NamedFilterItem;
import org.openspml.v2.util.xml.XmlBuffer;

public class ExtensibleMatch
extends NamedFilterItem {
    private static final String code_id = "$Id: ExtensibleMatch.java,v 1.8 2006/06/29 22:31:46 kas Exp $";
    private DSMLValue mValue = null;
    private Boolean mDnAttributes = null;
    private String mMatchingRule = null;

    protected ExtensibleMatch(String name, DSMLValue value, String matchingRule, Boolean dnAttributes) throws DSMLProfileException {
        super(name);
        this.mValue = value;
        this.mDnAttributes = dnAttributes;
        this.mMatchingRule = matchingRule;
    }

    protected void toXML(XmlBuffer buffer) throws DSMLProfileException {
        super.toXML("extensibleMatch", buffer);
    }

    protected void addSubclassAttributes(XmlBuffer buffer) throws DSMLProfileException {
        super.addSubclassAttributes(buffer);
        if (this.mDnAttributes != null) {
            buffer.addAttribute("dnAttributes", this.mDnAttributes);
        } else {
            buffer.addAttribute("dnAttributes", "false");
        }
        if (this.mMatchingRule != null) {
            buffer.addAttribute("matchingRule", this.mMatchingRule);
        }
    }

    protected void addSubclassElements(XmlBuffer buffer) throws DSMLProfileException {
        super.addSubclassElements(buffer);
        if (this.mValue != null) {
            this.mValue.toXML(buffer);
        }
    }

    protected ExtensibleMatch() {
    }

    public void parseXml(DSMLUnmarshaller um, Object e) throws DSMLProfileException {
        um.visitExtensibleMatch(this, e);
    }

    public ExtensibleMatch(String name, DSMLValue value) throws DSMLProfileException {
        this(name, value, null, null);
    }

    public ExtensibleMatch(String name, String value) throws DSMLProfileException {
        this(name, new DSMLValue(value), null, null);
    }

    public ExtensibleMatch(String name, String value, String matchingRule) throws DSMLProfileException {
        this(name, new DSMLValue(value), matchingRule, null);
    }

    public ExtensibleMatch(String name, String value, String matchingRule, boolean dnAttributes) throws DSMLProfileException {
        this(name, new DSMLValue(value), matchingRule, new Boolean(dnAttributes));
    }

    public DSMLValue getValue() {
        return this.mValue;
    }

    public void setValue(DSMLValue value) throws DSMLProfileException {
        if (value == null) {
            throw new DSMLProfileException("Value cannot be null; it's a required element.");
        }
        this.mValue = value;
    }

    public boolean getDnAttributes() {
        return this.mDnAttributes != null ? this.mDnAttributes : false;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.mDnAttributes = new Boolean(dnAttributes);
    }

    public String getMatchingRule() {
        return this.mMatchingRule;
    }

    public void setMatchingRule(String matchingRule) {
        this.mMatchingRule = matchingRule;
    }

    public boolean matches(Map attrs) throws DSMLProfileException {
        throw new DSMLProfileException("Not implemented.");
    }

    public void accept(FilterItemVisitor visitor) throws DSMLProfileException {
        visitor.visitExtensibleMatch(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensibleMatch)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtensibleMatch extensibleMatch = (ExtensibleMatch)o;
        if (this.mDnAttributes != null ? !this.mDnAttributes.equals(extensibleMatch.mDnAttributes) : extensibleMatch.mDnAttributes != null) {
            return false;
        }
        if (this.mMatchingRule != null ? !this.mMatchingRule.equals(extensibleMatch.mMatchingRule) : extensibleMatch.mMatchingRule != null) {
            return false;
        }
        return !(this.mValue != null ? !this.mValue.equals(extensibleMatch.mValue) : extensibleMatch.mValue != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.mValue != null ? this.mValue.hashCode() : 0);
        result = 29 * result + (this.mDnAttributes != null ? this.mDnAttributes.hashCode() : 0);
        result = 29 * result + (this.mMatchingRule != null ? this.mMatchingRule.hashCode() : 0);
        return result;
    }
}

