/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.profiles.dsml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.profiles.dsml.AttributeDescription;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLUnmarshaller;
import org.openspml.v2.util.xml.XmlBuffer;

public class AttributeDescriptions
implements DSMLUnmarshaller.Parseable,
OpenContentElement {
    private static final String code_id = "$Id: AttributeDescriptions.java,v 1.3 2006/06/21 22:41:37 kas Exp $";
    private List mAttributeDescriptions = new ArrayList();

    public AttributeDescriptions() {
    }

    public AttributeDescriptions(AttributeDescription[] descs) throws DSMLProfileException {
        if (descs != null) {
            this.mAttributeDescriptions.addAll(Arrays.asList(descs));
        }
    }

    public AttributeDescription[] getAttributeDescriptions() {
        return this.mAttributeDescriptions.toArray(new AttributeDescription[this.mAttributeDescriptions.size()]);
    }

    public void addAttributeDescription(AttributeDescription desc) {
        if (desc != null) {
            this.mAttributeDescriptions.add(desc);
        }
    }

    public void addAttributeDescriptions(AttributeDescription[] descs) {
        for (int k = 0; k < descs.length; ++k) {
            AttributeDescription desc = descs[k];
            this.addAttributeDescription(desc);
        }
    }

    public void setAttributeDescriptions(AttributeDescription[] descs) {
        this.clearAttributeDescriptions();
        this.addAttributeDescriptions(descs);
    }

    public void clearAttributeDescriptions() {
        this.mAttributeDescriptions.clear();
    }

    public String toXML(int indent) throws DSMLProfileException {
        try {
            XmlBuffer buffer = new XmlBuffer();
            buffer.setNamespace(new URI("urn:oasis:names:tc:DSML:2:0:core"));
            buffer.setPrefix("dsml");
            buffer.setIndent(indent);
            buffer.addStartTag("attributes");
            buffer.incIndent();
            for (int k = 0; k < this.mAttributeDescriptions.size(); ++k) {
                AttributeDescription desc = (AttributeDescription)this.mAttributeDescriptions.get(k);
                desc.toXML(buffer);
            }
            buffer.decIndent();
            buffer.addEndTag("attributes");
            return buffer.toString();
        }
        catch (URISyntaxException e) {
            throw new DSMLProfileException(e);
        }
    }

    public String toXML() throws DSMLProfileException {
        return this.toXML(0);
    }

    public void parseXml(DSMLUnmarshaller um, Object xmlObj) throws DSMLProfileException {
        um.visitAttributeDescriptions(this, xmlObj);
    }
}

