/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spmlupdates;

import java.util.Arrays;
import java.util.List;
import org.openspml.v2.msg.spml.ExecutionMode;
import org.openspml.v2.msg.spmlsearch.Query;
import org.openspml.v2.msg.spmlupdates.BasicRequest;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

public class UpdatesRequest
extends BasicRequest {
    private static final String code_id = "$Id: UpdatesRequest.java,v 1.4 2006/04/25 21:22:09 kas Exp $";
    private ListWithType m_query = new ArrayListWithType(Query.class);
    private ListWithType m_updatedByCapability = new ArrayListWithType(String.class);
    private String m_updatedSince = null;
    private String m_token = null;
    private Integer m_maxSelect = null;

    public UpdatesRequest() {
    }

    public UpdatesRequest(String requestId, ExecutionMode executionMode, Query[] query, String[] updatedByCapability, String updatedSince, String token, Integer maxSelect) {
        super(requestId, executionMode);
        if (query != null) {
            this.m_query.addAll(Arrays.asList(query));
        }
        if (updatedByCapability != null) {
            this.m_updatedByCapability.addAll(Arrays.asList(updatedByCapability));
        }
        this.m_updatedSince = updatedSince;
        this.m_token = token;
        this.m_maxSelect = maxSelect;
    }

    public Query[] getQueries() {
        return this.m_query.toArray(new Query[this.m_query.size()]);
    }

    public void addQuery(Query query) {
        if (query != null) {
            this.m_query.add(query);
        }
    }

    public boolean removeQuery(Query query) {
        return this.m_query.remove(query);
    }

    public void clearQueries() {
        this.m_query.clear();
    }

    public String[] getUpdatedByCapabilities() {
        return this.m_updatedByCapability.toArray(new String[this.m_updatedByCapability.size()]);
    }

    public void addUpdatedByCapability(List updatedByCapability) {
        if (updatedByCapability != null) {
            this.m_updatedByCapability.add(updatedByCapability);
        }
    }

    public boolean removeUpdatedByCapability(List updatedByCapability) {
        return this.m_updatedByCapability.remove(updatedByCapability);
    }

    public void clearUpdatedByCapabilities() {
        this.m_updatedByCapability.clear();
    }

    public String getUpdatedSince() {
        return this.m_updatedSince;
    }

    public void setUpdatedSince(String updatedSince) {
        this.m_updatedSince = updatedSince;
    }

    public String getToken() {
        return this.m_token;
    }

    public void setToken(String token) {
        this.m_token = token;
    }

    public int getMaxSelect() {
        if (this.m_maxSelect == null) {
            return 0;
        }
        return this.m_maxSelect;
    }

    public void setMaxSelect(int maxSelect) {
        this.m_maxSelect = new Integer(maxSelect);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatesRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdatesRequest updatesRequest = (UpdatesRequest)o;
        if (this.m_maxSelect != null ? !this.m_maxSelect.equals(updatesRequest.m_maxSelect) : updatesRequest.m_maxSelect != null) {
            return false;
        }
        if (!this.m_query.equals(updatesRequest.m_query)) {
            return false;
        }
        if (this.m_token != null ? !this.m_token.equals(updatesRequest.m_token) : updatesRequest.m_token != null) {
            return false;
        }
        if (!this.m_updatedByCapability.equals(updatesRequest.m_updatedByCapability)) {
            return false;
        }
        return !(this.m_updatedSince != null ? !this.m_updatedSince.equals(updatesRequest.m_updatedSince) : updatesRequest.m_updatedSince != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.m_query.hashCode();
        result = 29 * result + this.m_updatedByCapability.hashCode();
        result = 29 * result + (this.m_updatedSince != null ? this.m_updatedSince.hashCode() : 0);
        result = 29 * result + (this.m_token != null ? this.m_token.hashCode() : 0);
        result = 29 * result + (this.m_maxSelect != null ? this.m_maxSelect.hashCode() : 0);
        return result;
    }
}

