/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spmlsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openspml.v2.msg.spml.ExecutionMode;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spmlsearch.BasicRequest;
import org.openspml.v2.msg.spmlsearch.Query;

public class SearchRequest
extends BasicRequest {
    private static final String code_id = "$Id: SearchRequest.java,v 1.5 2006/06/27 00:47:19 kas Exp $";
    private Query m_query = null;
    private List m_includeDataForCapability = new ArrayList();
    private ReturnData m_returnData = null;
    private Integer m_maxSelect = null;

    public SearchRequest() {
    }

    public SearchRequest(String requestId, ExecutionMode executionMode, Query query, String[] includeDataForCapability, ReturnData returnData, Integer maxSelect) {
        super(requestId, executionMode);
        this.m_query = query;
        if (includeDataForCapability != null) {
            this.m_includeDataForCapability.addAll(Arrays.asList(includeDataForCapability));
        }
        this.m_returnData = returnData;
        this.m_maxSelect = maxSelect;
    }

    public SearchRequest(String requestId, ExecutionMode executionMode, Query query, String[] includeDataForCapability, ReturnData returnData, int maxSelect) {
        this(requestId, executionMode, query, includeDataForCapability, returnData, new Integer(maxSelect));
    }

    public SearchRequest(String requestId, ExecutionMode executionMode, Query query, String[] includeDataForCapability, ReturnData returnData) {
        this(requestId, executionMode, query, includeDataForCapability, returnData, null);
    }

    public Query getQuery() {
        return this.m_query;
    }

    public void setQuery(Query query) {
        this.m_query = query;
    }

    public String[] getIncludeDataForCapability() {
        return this.m_includeDataForCapability.toArray(new String[this.m_includeDataForCapability.size()]);
    }

    public void clearIncludeDataForCapability() {
        this.m_includeDataForCapability.clear();
    }

    public void addIncludeDataForCapability(String includeDataForCapability) {
        if (includeDataForCapability == null) {
            return;
        }
        this.m_includeDataForCapability.add(includeDataForCapability);
    }

    public boolean removeIncludeDataForCapability(String includeDataForCapability) {
        if (includeDataForCapability == null) {
            return false;
        }
        return this.m_includeDataForCapability.remove(includeDataForCapability);
    }

    public ReturnData getReturnData() {
        return this.m_returnData;
    }

    public void setReturnData(ReturnData returnData) {
        this.m_returnData = returnData;
    }

    public int getMaxSelect() {
        return this.m_maxSelect != null ? this.m_maxSelect : 0;
    }

    public void setMaxSelect(int maxSelect) {
        this.m_maxSelect = new Integer(maxSelect);
    }

    public void useDefaultMaxSelect() {
        this.setMaxSelect(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchRequest searchRequest = (SearchRequest)o;
        if (!((Object)this.m_includeDataForCapability).equals(searchRequest.m_includeDataForCapability)) {
            return false;
        }
        if (this.m_maxSelect != null ? !this.m_maxSelect.equals(searchRequest.m_maxSelect) : searchRequest.m_maxSelect != null) {
            return false;
        }
        if (this.m_query != null ? !this.m_query.equals(searchRequest.m_query) : searchRequest.m_query != null) {
            return false;
        }
        return !(this.m_returnData != null ? !this.m_returnData.equals(searchRequest.m_returnData) : searchRequest.m_returnData != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.m_query != null ? this.m_query.hashCode() : 0);
        result = 29 * result + ((Object)this.m_includeDataForCapability).hashCode();
        result = 29 * result + (this.m_returnData != null ? this.m_returnData.hashCode() : 0);
        result = 29 * result + (this.m_maxSelect != null ? this.m_maxSelect.hashCode() : 0);
        return result;
    }
}

