/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.ExtensibleMarshallable;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.util.Spml2Exception;

public class Response
extends ExtensibleMarshallable {
    public static final String code_id = "$Id: Response.java,v 1.6 2006/06/29 21:01:21 rfrech Exp $";
    private List m_errorMessage = new ArrayList();
    private StatusCode m_status = null;
    private String m_requestID = null;
    private ErrorCode m_error = null;

    public Response() {
    }

    protected Response(String[] errorMessages, StatusCode status, String requestId, ErrorCode errorCode) {
        if (errorMessages != null) {
            this.m_errorMessage.addAll(Arrays.asList(errorMessages));
        }
        assert (status != null);
        this.m_status = status;
        this.m_requestID = requestId;
        this.m_error = errorCode;
    }

    public Response(StatusCode status) {
        this(null, status, null, null);
    }

    public Response(StatusCode status, String requestId) {
        this(null, status, requestId, null);
    }

    public String[] getErrorMessages() {
        return this.m_errorMessage.toArray(new String[this.m_errorMessage.size()]);
    }

    public void addErrorMessage(String errorMessage) {
        assert (errorMessage != null);
        this.m_errorMessage.add(errorMessage);
    }

    public boolean removeErrorMessage(String errorMessage) {
        assert (errorMessage != null);
        return this.m_errorMessage.remove(errorMessage);
    }

    public void clearErrorMessages() {
        this.m_errorMessage.clear();
    }

    public StatusCode getStatus() {
        return this.m_status;
    }

    public void setStatus(StatusCode status) {
        this.m_status = status;
        assert (this.m_status != null);
    }

    public String getRequestID() {
        return this.m_requestID;
    }

    public void setRequestID(String requestID) {
        this.m_requestID = requestID;
    }

    public ErrorCode getError() {
        return this.m_error;
    }

    public void setError(ErrorCode error) {
        this.m_error = error;
    }

    public String toXML(XMLMarshaller m) throws Spml2Exception {
        return m.marshall(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Response response = (Response)o;
        if (this.m_error != null ? !this.m_error.equals(response.m_error) : response.m_error != null) {
            return false;
        }
        if (this.m_errorMessage != null ? !((Object)this.m_errorMessage).equals(response.m_errorMessage) : response.m_errorMessage != null) {
            return false;
        }
        if (this.m_requestID != null ? !this.m_requestID.equals(response.m_requestID) : response.m_requestID != null) {
            return false;
        }
        return !(this.m_status != null ? !this.m_status.equals(response.m_status) : response.m_status != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.m_errorMessage != null ? ((Object)this.m_errorMessage).hashCode() : 0);
        result = 29 * result + (this.m_status != null ? this.m_status.hashCode() : 0);
        result = 29 * result + (this.m_requestID != null ? this.m_requestID.hashCode() : 0);
        result = 29 * result + (this.m_error != null ? this.m_error.hashCode() : 0);
        return result;
    }
}

