/*
 * Decompiled with CFR 0.152.
 */
package org.openspml.v2.msg.spml;

import java.util.Arrays;
import org.openspml.v2.msg.spml.BatchableRequest;
import org.openspml.v2.msg.spml.ExecutionMode;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.util.xml.ArrayListWithType;
import org.openspml.v2.util.xml.ListWithType;

public class ModifyRequest
extends BatchableRequest {
    private static final String code_id = "$Id: ModifyRequest.java,v 1.5 2006/06/29 21:01:21 rfrech Exp $";
    private PSOIdentifier m_psoID = null;
    private ListWithType m_modification = new ArrayListWithType(Modification.class);
    private ReturnData m_returnData = ReturnData.EVERYTHING;

    public ModifyRequest() {
    }

    public ModifyRequest(String requestId, ExecutionMode executionMode, PSOIdentifier psoID, Modification[] modifications, ReturnData returnData) {
        super(requestId, executionMode);
        assert (psoID != null);
        this.m_psoID = psoID;
        if (modifications != null) {
            this.m_modification.addAll(Arrays.asList(modifications));
        }
        this.m_returnData = returnData;
    }

    public PSOIdentifier getPsoID() {
        return this.m_psoID;
    }

    public void setPsoID(PSOIdentifier psoID) {
        assert (psoID != null);
        this.m_psoID = psoID;
    }

    public Modification[] getModifications() {
        return this.m_modification.toArray(new Modification[this.m_modification.size()]);
    }

    public void addModification(Modification modification) {
        assert (modification != null);
        this.m_modification.add(modification);
    }

    public boolean removeModification(Modification modification) {
        assert (modification != null);
        return this.m_modification.remove(modification);
    }

    public void clearModifications() {
        this.m_modification.clear();
    }

    public ReturnData getReturnData() {
        return this.m_returnData;
    }

    public void setReturnData(ReturnData returnData) {
        this.m_returnData = returnData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifyRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModifyRequest modifyRequestType = (ModifyRequest)o;
        if (this.m_modification != null ? !this.m_modification.equals(modifyRequestType.m_modification) : modifyRequestType.m_modification != null) {
            return false;
        }
        if (!this.m_psoID.equals(modifyRequestType.m_psoID)) {
            return false;
        }
        return !(this.m_returnData != null ? !this.m_returnData.equals(modifyRequestType.m_returnData) : modifyRequestType.m_returnData != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.m_psoID.hashCode();
        result = 29 * result + (this.m_modification != null ? this.m_modification.hashCode() : 0);
        result = 29 * result + (this.m_returnData != null ? this.m_returnData.hashCode() : 0);
        return result;
    }
}

