/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.AbstractSchemaLoader;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.parsers.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionSchemaLoader
extends AbstractSchemaLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionSchemaLoader.class);
    private final SchemaPartitionDao dao;
    private SchemaEntityFactory factory;
    private Partition partition;
    private AttributeTypeRegistry atRegistry;
    private final AttributeType mOidAT;
    private final AttributeType mNameAT;
    private final AttributeType cnAT;
    private final AttributeType byteCodeAT;
    private final AttributeType descAT;
    private final AttributeType fqcnAT;
    private static Map<String, LdapDN> staticAttributeTypeDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticMatchingRulesDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticObjectClassesDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticComparatorsDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticNormalizersDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticSyntaxCheckersDNs = new HashMap<String, LdapDN>();
    private static Map<String, LdapDN> staticSyntaxesDNs = new HashMap<String, LdapDN>();

    public PartitionSchemaLoader(Partition partition, Registries registries) throws Exception {
        this.factory = new SchemaEntityFactory(registries);
        this.partition = partition;
        this.atRegistry = registries.getAttributeTypeRegistry();
        this.dao = new SchemaPartitionDao(this.partition, registries);
        this.mOidAT = this.atRegistry.lookup("m-oid");
        this.mNameAT = this.atRegistry.lookup("m-name");
        this.cnAT = this.atRegistry.lookup("cn");
        this.byteCodeAT = this.atRegistry.lookup("m-bytecode");
        this.descAT = this.atRegistry.lookup("m-description");
        this.fqcnAT = this.atRegistry.lookup("m-fqcn");
        this.initStaticDNs("system");
        this.initStaticDNs("core");
        this.initStaticDNs("apache");
        this.initStaticDNs("apachemeta");
        this.initStaticDNs("other");
        this.initStaticDNs("collective");
        this.initStaticDNs("java");
        this.initStaticDNs("cosine");
        this.initStaticDNs("inetorgperson");
    }

    private void initStaticDNs(String schemaName) throws Exception {
        LdapDN dn = new LdapDN("ou=attributeTypes,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.atRegistry.getNormalizerMapping());
        staticAttributeTypeDNs.put(schemaName, dn);
        dn = new LdapDN("ou=objectClasses,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.atRegistry.getNormalizerMapping());
        staticObjectClassesDNs.put(schemaName, dn);
        dn = new LdapDN("ou=matchingRules,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.atRegistry.getNormalizerMapping());
        staticMatchingRulesDNs.put(schemaName, dn);
        dn = new LdapDN("ou=comparators,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.atRegistry.getNormalizerMapping());
        staticComparatorsDNs.put(schemaName, dn);
        dn = new LdapDN("ou=normalizers,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.atRegistry.getNormalizerMapping());
        staticNormalizersDNs.put(schemaName, dn);
        dn = new LdapDN("ou=syntaxCheckers,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.atRegistry.getNormalizerMapping());
        staticSyntaxCheckersDNs.put(schemaName, dn);
        dn = new LdapDN("ou=syntaxes,cn=" + schemaName + ",ou=schema");
        dn.normalize(this.atRegistry.getNormalizerMapping());
        staticSyntaxesDNs.put(schemaName, dn);
    }

    public void loadEnabled(Registries targetRegistries) throws Exception {
        EntryFilteringCursor cursor = this.dao.listAllNames();
        while (cursor.next()) {
            ServerEntry entry = (ServerEntry)cursor.get();
            String oid = entry.get(this.mOidAT).getString();
            EntryAttribute names = entry.get(this.mNameAT);
            targetRegistries.getOidRegistry().register(oid, oid);
            for (Value value : names) {
                targetRegistries.getOidRegistry().register(value.getString(), oid);
            }
        }
        cursor.close();
        Map<String, Schema> allSchemaMap = this.getSchemas();
        HashSet<Schema> enabledSchemaSet = new HashSet<Schema>();
        for (Schema schema : allSchemaMap.values()) {
            if (!schema.isDisabled()) {
                LOG.debug("will attempt to load enabled schema: {}", (Object)schema.getSchemaName());
                enabledSchemaSet.add(schema);
                continue;
            }
            LOG.debug("will NOT attempt to load disabled schema: {}", (Object)schema.getSchemaName());
        }
        this.loadWithDependencies(enabledSchemaSet, targetRegistries);
    }

    public Set<String> listDependentSchemaNames(String schemaName) throws Exception {
        HashSet<String> dependees = new HashSet<String>();
        Set<ServerEntry> results = this.dao.listSchemaDependents(schemaName);
        if (results.isEmpty()) {
            return dependees;
        }
        for (ServerEntry sr : results) {
            EntryAttribute cn = sr.get(this.cnAT);
            dependees.add(cn.getString());
        }
        return dependees;
    }

    public Set<String> listEnabledDependentSchemaNames(String schemaName) throws Exception {
        HashSet<String> dependees = new HashSet<String>();
        Set<ServerEntry> results = this.dao.listEnabledSchemaDependents(schemaName);
        if (results.isEmpty()) {
            return dependees;
        }
        for (ServerEntry sr : results) {
            EntryAttribute cn = sr.get(this.cnAT);
            dependees.add(cn.getString());
        }
        return dependees;
    }

    public Map<String, Schema> getSchemas() throws Exception {
        return this.dao.getSchemas();
    }

    public Set<String> getSchemaNames() throws Exception {
        return this.dao.getSchemaNames();
    }

    public Schema getSchema(String schemaName) throws Exception {
        return this.dao.getSchema(schemaName);
    }

    public Schema getSchema(String schemaName, Properties schemaProperties) throws Exception {
        return this.getSchema(schemaName);
    }

    public final void loadWithDependencies(Collection<Schema> schemas, Registries targetRegistries) throws Exception {
        HashMap<String, Schema> notLoaded = new HashMap<String, Schema>();
        for (Schema schema : schemas) {
            notLoaded.put(schema.getSchemaName(), schema);
        }
        Iterator list = notLoaded.values().iterator();
        while (list.hasNext()) {
            Schema schema;
            schema = (Schema)list.next();
            this.loadDepsFirst(schema, new Stack(), notLoaded, schema, targetRegistries, null);
            list = notLoaded.values().iterator();
        }
    }

    public final void load(Schema schema, Registries targetRegistries, boolean isDepLoad) throws Exception {
        if (schema.isDisabled() && isDepLoad) {
            this.dao.enableSchema(schema.getSchemaName());
        }
        if (targetRegistries.getLoadedSchemas().containsKey(schema.getSchemaName())) {
            LOG.debug("schema {} already seems to be loaded", (Object)schema.getSchemaName());
            return;
        }
        LOG.debug("loading {} schema ...", (Object)schema.getSchemaName());
        this.loadComparators(schema, targetRegistries);
        this.loadNormalizers(schema, targetRegistries);
        this.loadSyntaxCheckers(schema, targetRegistries);
        this.loadSyntaxes(schema, targetRegistries);
        this.loadMatchingRules(schema, targetRegistries);
        this.loadAttributeTypes(schema, targetRegistries);
        this.loadObjectClasses(schema, targetRegistries);
        this.loadMatchingRuleUses(schema, targetRegistries);
        this.loadDitContentRules(schema, targetRegistries);
        this.loadNameForms(schema, targetRegistries);
        this.loadDitStructureRules(schema, targetRegistries);
        this.notifyListenerOrRegistries(schema, targetRegistries);
    }

    private void loadMatchingRuleUses(Schema schema, Registries targetRegistries) {
    }

    private void loadDitStructureRules(Schema schema, Registries targetRegistries) {
    }

    private void loadNameForms(Schema schema, Registries targetRegistries) {
    }

    private void loadDitContentRules(Schema schema, Registries targetRegistries) {
    }

    private void loadObjectClasses(Schema schema, Registries targetRegistries) throws Exception {
        LinkedList<ObjectClass> deferred = new LinkedList<ObjectClass>();
        LdapDN dn = staticObjectClassesDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=objectClasses,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.atRegistry.getNormalizerMapping());
            staticObjectClassesDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
            return;
        }
        LOG.debug("{} schema: loading objectClasses", (Object)schema.getSchemaName());
        EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
        while (list.next()) {
            ClonedServerEntry result = (ClonedServerEntry)list.get();
            LdapDN resultDN = result.getDn();
            resultDN.normalize(this.atRegistry.getNormalizerMapping());
            ClonedServerEntry attrs = this.lookupPartition(resultDN);
            ObjectClass oc = this.factory.getObjectClass((ServerEntry)attrs, targetRegistries, schema.getSchemaName());
            try {
                targetRegistries.getObjectClassRegistry().register(oc);
            }
            catch (Exception ne) {
                deferred.add(oc);
            }
        }
        LOG.debug("Deferred queue size = {}", (Object)deferred.size());
        if (LOG.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Deferred queue contains: ");
            for (ObjectClass extra : deferred) {
                buf.append(extra.getName());
                buf.append('[');
                buf.append(extra.getOid());
                buf.append("]");
                buf.append("\n");
            }
        }
        int lastCount = deferred.size();
        while (!deferred.isEmpty()) {
            LOG.debug("Deferred queue size = {}", (Object)deferred.size());
            ObjectClass oc = (ObjectClass)deferred.removeFirst();
            Exception lastException = null;
            try {
                targetRegistries.getObjectClassRegistry().register(oc);
            }
            catch (Exception ne) {
                deferred.addLast(oc);
                lastException = ne;
            }
            if (deferred.size() < lastCount) {
                lastCount = deferred.size();
                continue;
            }
            StringBuffer buf = new StringBuffer();
            buf.append("A cycle must exist somewhere within the objectClasses of the ");
            buf.append(schema.getSchemaName());
            buf.append(" schema.  We cannot seem to register the following objectClasses:\n");
            for (ObjectClass extra : deferred) {
                buf.append(extra.getName());
                buf.append('[');
                buf.append(extra.getOid());
                buf.append("]");
                buf.append("\n");
            }
            NamingException ne = new NamingException(buf.toString());
            ne.setRootCause(lastException);
        }
    }

    private void loadAttributeTypes(Schema schema, Registries targetRegistries) throws Exception {
        LinkedList<AttributeType> deferred = new LinkedList<AttributeType>();
        LdapDN dn = staticAttributeTypeDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=attributeTypes,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.atRegistry.getNormalizerMapping());
            staticAttributeTypeDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
            return;
        }
        LOG.debug("{} schema: loading attributeTypes", (Object)schema.getSchemaName());
        EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
        while (list.next()) {
            ServerEntry result = (ServerEntry)list.get();
            LdapDN resultDN = result.getDn();
            resultDN.normalize(this.atRegistry.getNormalizerMapping());
            ClonedServerEntry attrs = this.lookupPartition(resultDN);
            AttributeType at = this.factory.getAttributeType((ServerEntry)attrs, targetRegistries, schema.getSchemaName());
            try {
                targetRegistries.getAttributeTypeRegistry().register(at);
            }
            catch (Exception ne) {
                deferred.add(at);
            }
        }
        LOG.debug("Deferred queue size = {}", (Object)deferred.size());
        if (LOG.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("Deferred queue contains: ");
            for (AttributeType extra : deferred) {
                buf.append(extra.getName());
                buf.append('[');
                buf.append(extra.getOid());
                buf.append("]");
                buf.append("\n");
            }
        }
        int lastCount = deferred.size();
        while (!deferred.isEmpty()) {
            LOG.debug("Deferred queue size = {}", (Object)deferred.size());
            AttributeType at = (AttributeType)deferred.removeFirst();
            Exception lastException = null;
            try {
                targetRegistries.getAttributeTypeRegistry().register(at);
            }
            catch (Exception ne) {
                deferred.addLast(at);
                lastException = ne;
            }
            if (deferred.size() < lastCount) {
                lastCount = deferred.size();
                continue;
            }
            StringBuffer buf = new StringBuffer();
            buf.append("A cycle must exist somewhere within the attributeTypes of the ");
            buf.append(schema.getSchemaName());
            buf.append(" schema.  We cannot seem to register the following attributeTypes:\n");
            for (AttributeType extra : deferred) {
                buf.append(extra.getName());
                buf.append('[');
                buf.append(extra.getOid());
                buf.append("]");
                buf.append("\n");
            }
            NamingException ne = new NamingException(buf.toString());
            ne.setRootCause(lastException);
        }
    }

    private void loadMatchingRules(Schema schema, Registries targetRegistries) throws Exception {
        LdapDN dn = staticMatchingRulesDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=matchingRules,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.atRegistry.getNormalizerMapping());
            staticMatchingRulesDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
            return;
        }
        LOG.debug("{} schema: loading matchingRules", (Object)schema.getSchemaName());
        EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
        while (list.next()) {
            ServerEntry result = (ServerEntry)list.get();
            LdapDN resultDN = result.getDn();
            resultDN.normalize(this.atRegistry.getNormalizerMapping());
            ClonedServerEntry attrs = this.lookupPartition(resultDN);
            MatchingRule mrule = this.factory.getMatchingRule((ServerEntry)attrs, targetRegistries, schema.getSchemaName());
            targetRegistries.getMatchingRuleRegistry().register(mrule);
        }
    }

    private void loadSyntaxes(Schema schema, Registries targetRegistries) throws Exception {
        LdapDN dn = staticSyntaxesDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=syntaxes,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.atRegistry.getNormalizerMapping());
            staticSyntaxesDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
            return;
        }
        LOG.debug("{} schema: loading syntaxes", (Object)schema.getSchemaName());
        EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
        while (list.next()) {
            ServerEntry result = (ServerEntry)list.get();
            LdapDN resultDN = result.getDn();
            resultDN.normalize(this.atRegistry.getNormalizerMapping());
            ClonedServerEntry attrs = this.lookupPartition(resultDN);
            Syntax syntax = this.factory.getSyntax((ServerEntry)attrs, targetRegistries, schema.getSchemaName());
            targetRegistries.getSyntaxRegistry().register(syntax);
        }
    }

    private void loadSyntaxCheckers(Schema schema, Registries targetRegistries) throws Exception {
        LdapDN dn = staticSyntaxCheckersDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=syntaxCheckers,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.atRegistry.getNormalizerMapping());
            staticSyntaxCheckersDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
            return;
        }
        LOG.debug("{} schema: loading syntaxCheckers", (Object)schema.getSchemaName());
        EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
        while (list.next()) {
            ServerEntry result = (ServerEntry)list.get();
            LdapDN resultDN = result.getDn();
            resultDN.normalize(this.atRegistry.getNormalizerMapping());
            ClonedServerEntry attrs = this.lookupPartition(resultDN);
            SyntaxChecker sc = this.factory.getSyntaxChecker((ServerEntry)attrs, targetRegistries);
            SyntaxCheckerDescription syntaxCheckerDescription = this.getSyntaxCheckerDescription(schema.getSchemaName(), (ServerEntry)attrs);
            targetRegistries.getSyntaxCheckerRegistry().register(syntaxCheckerDescription, sc);
        }
    }

    private void loadNormalizers(Schema schema, Registries targetRegistries) throws Exception {
        LdapDN dn = staticNormalizersDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=normalizers,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.atRegistry.getNormalizerMapping());
            staticNormalizersDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
            return;
        }
        LOG.debug("{} schema: loading normalizers", (Object)schema.getSchemaName());
        EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
        while (list.next()) {
            ClonedServerEntry result = (ClonedServerEntry)list.get();
            LdapDN resultDN = result.getDn();
            resultDN.normalize(this.atRegistry.getNormalizerMapping());
            ClonedServerEntry attrs = this.lookupPartition(resultDN);
            Normalizer normalizer = this.factory.getNormalizer((ServerEntry)attrs, targetRegistries);
            NormalizerDescription normalizerDescription = this.getNormalizerDescription(schema.getSchemaName(), (ServerEntry)attrs);
            targetRegistries.getNormalizerRegistry().register(normalizerDescription, normalizer);
        }
    }

    private String getOid(ServerEntry entry) throws Exception {
        EntryAttribute oid = entry.get(this.mOidAT);
        if (oid == null) {
            return null;
        }
        return oid.getString();
    }

    private NormalizerDescription getNormalizerDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        NormalizerDescription description = new NormalizerDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    private ClonedServerEntry lookupPartition(LdapDN dn) throws Exception {
        return this.partition.lookup(new LookupOperationContext(null, dn));
    }

    private void loadComparators(Schema schema, Registries targetRegistries) throws Exception {
        LdapDN dn = staticComparatorsDNs.get(schema.getSchemaName());
        if (dn == null) {
            dn = new LdapDN("ou=comparators,cn=" + schema.getSchemaName() + ",ou=schema");
            dn.normalize(this.atRegistry.getNormalizerMapping());
            staticComparatorsDNs.put(schema.getSchemaName(), dn);
        }
        if (!this.partition.hasEntry(new EntryOperationContext(null, dn))) {
            return;
        }
        LOG.debug("{} schema: loading comparators", (Object)schema.getSchemaName());
        EntryFilteringCursor list = this.partition.list(new ListOperationContext(null, dn));
        while (list.next()) {
            ClonedServerEntry result = (ClonedServerEntry)list.get();
            LdapDN resultDN = result.getDn();
            resultDN.normalize(this.atRegistry.getNormalizerMapping());
            ClonedServerEntry attrs = this.lookupPartition(resultDN);
            Comparator comparator = this.factory.getComparator((ServerEntry)attrs, targetRegistries);
            ComparatorDescription comparatorDescription = this.getComparatorDescription(schema.getSchemaName(), (ServerEntry)attrs);
            targetRegistries.getComparatorRegistry().register(comparatorDescription, comparator);
        }
    }

    private ComparatorDescription getComparatorDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        ComparatorDescription description = new ComparatorDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    private SyntaxCheckerDescription getSyntaxCheckerDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        SyntaxCheckerDescription description = new SyntaxCheckerDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    public void loadWithDependencies(Schema schema, Registries registries) throws Exception {
        HashMap<String, Schema> notLoaded = new HashMap<String, Schema>();
        notLoaded.put(schema.getSchemaName(), schema);
        Properties props = new Properties();
        this.loadDepsFirst(schema, new Stack(), notLoaded, schema, registries, props);
    }
}

