/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaChangeHandler;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SchemaObjectRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaSchemaHandler
implements SchemaChangeHandler {
    private final SchemaEntityFactory factory;
    private final PartitionSchemaLoader loader;
    private final Registries globalRegistries;
    private final AttributeType disabledAT;
    private final String OU_OID;
    private final AttributeType cnAT;
    private final AttributeType dependenciesAT;

    public MetaSchemaHandler(Registries globalRegistries, PartitionSchemaLoader loader) throws NamingException {
        this.globalRegistries = globalRegistries;
        this.disabledAT = globalRegistries.getAttributeTypeRegistry().lookup("m-disabled");
        this.loader = loader;
        this.OU_OID = globalRegistries.getOidRegistry().getOid("ou");
        this.factory = new SchemaEntityFactory(globalRegistries);
        this.cnAT = globalRegistries.getAttributeTypeRegistry().lookup("cn");
        this.dependenciesAT = globalRegistries.getAttributeTypeRegistry().lookup("m-dependencies");
    }

    @Override
    public boolean modify(LdapDN name, ModificationOperation modOp, ServerEntry mods, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        boolean hasModification = false;
        EntryAttribute disabledInMods = mods.get(this.disabledAT);
        if (disabledInMods != null) {
            this.disable(name, modOp, disabledInMods, entry.get(this.disabledAT));
        }
        boolean isEnabled = false;
        EntryAttribute disabled = targetEntry.get(this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.getString().equals("TRUE")) {
            isEnabled = true;
        }
        EntryAttribute dependencies = mods.get(this.dependenciesAT);
        if (dependencies != null) {
            this.checkForDependencies(isEnabled, targetEntry);
        }
        return hasModification;
    }

    @Override
    public boolean modify(LdapDN name, List<Modification> mods, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        boolean hasModification = false;
        EntryAttribute disabledInEntry = entry.get(this.disabledAT);
        Modification disabledModification = ServerEntryUtils.getModificationItem(mods, (AttributeType)this.disabledAT);
        if (disabledModification != null) {
            hasModification = this.disable(name, disabledModification.getOperation(), (EntryAttribute)((ServerAttribute)disabledModification.getAttribute()), disabledInEntry);
        }
        boolean isEnabled = false;
        EntryAttribute disabled = targetEntry.get(this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.contains(new String[]{"TRUE"})) {
            isEnabled = true;
        }
        ServerAttribute dependencies = ServerEntryUtils.getAttribute(mods, (AttributeType)this.dependenciesAT);
        if (dependencies != null) {
            this.checkForDependencies(isEnabled, targetEntry);
        }
        return hasModification;
    }

    @Override
    public void move(LdapDN oriChildName, LdapDN newParentName, Rdn newRn, boolean deleteOldRn, ServerEntry entry, boolean cascaded) throws NamingException {
    }

    @Override
    public void add(LdapDN name, ServerEntry entry) throws Exception {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        parentDn.normalize(this.globalRegistries.getAttributeTypeRegistry().getNormalizerMapping());
        if (!parentDn.toNormName().equals(this.OU_OID + "=schema")) {
            throw new LdapInvalidNameException("The parent dn of a schema should be " + this.OU_OID + "=schema and not: " + parentDn.toNormName(), ResultCodeEnum.NAMING_VIOLATION);
        }
        boolean isEnabled = false;
        EntryAttribute disabled = entry.get(this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.contains(new String[]{"TRUE"})) {
            isEnabled = true;
        }
        this.checkForDependencies(isEnabled, entry);
        if (isEnabled) {
            Schema schema = this.factory.getSchema(entry);
            this.globalRegistries.addToLoadedSet(schema);
        }
    }

    @Override
    public void delete(LdapDN name, ServerEntry entry, boolean cascade) throws Exception {
        EntryAttribute cn = entry.get(this.cnAT);
        String schemaName = cn.getString();
        Set<String> dependents = this.loader.listDependentSchemaNames(schemaName);
        if (!dependents.isEmpty()) {
            throw new LdapOperationNotSupportedException("Cannot delete schema that has dependents: " + dependents, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        this.globalRegistries.removeFromLoadedSet(schemaName);
    }

    @Override
    public void rename(LdapDN name, ServerEntry entry, Rdn newRdn, boolean cascade) throws Exception {
        String rdnAttribute = newRdn.getUpType();
        String rdnAttributeOid = this.globalRegistries.getOidRegistry().getOid(rdnAttribute);
        if (!rdnAttributeOid.equals(this.cnAT.getOid())) {
            throw new LdapOperationNotSupportedException("Cannot allow rename with rdnAttribute set to " + rdnAttribute + ": cn must be used instead.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String schemaName = this.getSchemaName(name);
        Set<String> dependents = this.loader.listDependentSchemaNames(schemaName);
        if (!dependents.isEmpty()) {
            throw new LdapOperationNotSupportedException("Cannot allow a rename on " + schemaName + " schema while it has depentents.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        boolean isEnabled = false;
        EntryAttribute disabled = entry.get(this.disabledAT);
        if (disabled == null) {
            isEnabled = true;
        } else if (!disabled.get().equals("TRUE")) {
            isEnabled = true;
        }
        if (!isEnabled) {
            return;
        }
        String newSchemaName = newRdn.getUpValue();
        this.globalRegistries.getComparatorRegistry().renameSchema(schemaName, newSchemaName);
        this.globalRegistries.getNormalizerRegistry().renameSchema(schemaName, newSchemaName);
        this.globalRegistries.getSyntaxCheckerRegistry().renameSchema(schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getAttributeTypeRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getDitContentRuleRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getDitStructureRuleRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getMatchingRuleRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getMatchingRuleUseRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getNameFormRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getObjectClassRegistry(), schemaName, newSchemaName);
        this.renameSchema((SchemaObjectRegistry)this.globalRegistries.getSyntaxRegistry(), schemaName, newSchemaName);
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws NamingException {
        throw new LdapOperationNotSupportedException("Moving around schemas is not allowed.", ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    @Override
    public void replace(LdapDN oriChildName, LdapDN newParentName, ServerEntry entry, boolean cascade) throws NamingException {
        throw new LdapOperationNotSupportedException("Moving around schemas is not allowed.", ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    private boolean disable(LdapDN name, ModificationOperation modOp, EntryAttribute disabledInMods, EntryAttribute disabledInEntry) throws Exception {
        switch (modOp) {
            case ADD_ATTRIBUTE: {
                if (disabledInEntry != null || !"TRUE".equalsIgnoreCase(disabledInMods.getString())) break;
                return this.disableSchema(this.getSchemaName(name));
            }
            case REMOVE_ATTRIBUTE: {
                if (disabledInEntry == null || !"TRUE".equalsIgnoreCase(disabledInEntry.getString())) break;
                return this.enableSchema(this.getSchemaName(name));
            }
            case REPLACE_ATTRIBUTE: {
                boolean isCurrentlyDisabled = false;
                if (disabledInEntry != null) {
                    isCurrentlyDisabled = "TRUE".equalsIgnoreCase(disabledInEntry.getString());
                }
                boolean isNewStateDisabled = false;
                if (disabledInMods != null) {
                    isNewStateDisabled = "TRUE".equalsIgnoreCase(disabledInMods.getString());
                }
                if (isCurrentlyDisabled && !isNewStateDisabled) {
                    return this.enableSchema(this.getSchemaName(name));
                }
                if (isCurrentlyDisabled || !isNewStateDisabled) break;
                return this.disableSchema(this.getSchemaName(name));
            }
            default: {
                throw new IllegalArgumentException("Unknown modify operation type: " + modOp);
            }
        }
        return false;
    }

    private String getSchemaName(LdapDN schema) {
        return (String)schema.getRdn().getValue();
    }

    private boolean disableSchema(String schemaName) throws Exception {
        Map schemas = this.globalRegistries.getLoadedSchemas();
        Schema schema = (Schema)schemas.get(schemaName);
        if (schema == null || schema.isDisabled()) {
            return false;
        }
        Set<String> dependents = this.loader.listEnabledDependentSchemaNames(schemaName);
        if (!dependents.isEmpty()) {
            throw new LdapOperationNotSupportedException("Cannot disable schema with enabled dependents: " + dependents, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        schema.disable();
        this.globalRegistries.unload(schemaName);
        return true;
    }

    private boolean enableSchema(String schemaName) throws Exception {
        if (this.globalRegistries.getLoadedSchemas().containsKey(schemaName)) {
            return false;
        }
        Schema schema = this.loader.getSchema(schemaName);
        this.loader.loadWithDependencies(schema, this.globalRegistries);
        schema.enable();
        return true;
    }

    private void checkForDependencies(boolean isEnabled, ServerEntry entry) throws Exception {
        EntryAttribute dependencies = entry.get(this.dependenciesAT);
        if (dependencies == null) {
            return;
        }
        if (isEnabled) {
            Map loaded = this.globalRegistries.getLoadedSchemas();
            for (Value value : dependencies) {
                String dependency = value.getString();
                if (loaded.containsKey(dependency)) continue;
                throw new LdapOperationNotSupportedException("Unwilling to perform operation on enabled schema with disabled or missing dependencies: " + dependency, ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
        } else {
            Set<String> allSchemas = this.loader.getSchemaNames();
            for (Value value : dependencies) {
                String dependency = value.getString();
                if (allSchemas.contains(dependency)) continue;
                throw new LdapOperationNotSupportedException("Unwilling to perform operation on schema with missing dependencies: " + dependency, ResultCodeEnum.UNWILLING_TO_PERFORM);
            }
        }
    }

    private void renameSchema(SchemaObjectRegistry registry, String originalSchemaName, String newSchemaName) {
        for (SchemaObject obj : registry) {
            if (!obj.getSchema().equalsIgnoreCase(originalSchemaName)) continue;
            obj.setSchema(newSchemaName);
        }
    }
}

