/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.parsers.ComparatorDescription;
import org.apache.directory.shared.ldap.util.Base64;

public class MetaComparatorHandler
extends AbstractSchemaChangeHandler {
    private final SchemaEntityFactory factory;
    private final ComparatorRegistry comparatorRegistry;
    private final MatchingRuleRegistry matchingRuleRegistry;
    private final AttributeType byteCodeAT;
    private final AttributeType descAT;
    private final AttributeType fqcnAT;

    public MetaComparatorHandler(Registries targetRegistries, PartitionSchemaLoader loader) throws Exception {
        super(targetRegistries, loader);
        this.comparatorRegistry = targetRegistries.getComparatorRegistry();
        this.matchingRuleRegistry = targetRegistries.getMatchingRuleRegistry();
        this.factory = new SchemaEntityFactory(targetRegistries);
        this.byteCodeAT = targetRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
        this.descAT = targetRegistries.getAttributeTypeRegistry().lookup("m-description");
        this.fqcnAT = targetRegistries.getAttributeTypeRegistry().lookup("m-fqcn");
    }

    protected boolean modify(LdapDN name, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        Comparator comparator = this.factory.getComparator(targetEntry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            this.comparatorRegistry.unregister(oid);
            ComparatorDescription description = this.getComparatorDescription(schema.getSchemaName(), targetEntry);
            this.comparatorRegistry.register(description, comparator);
            return true;
        }
        return false;
    }

    private ComparatorDescription getComparatorDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        ComparatorDescription description = new ComparatorDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode((byte[])bytes)));
        }
        return description;
    }

    public void add(LdapDN name, ServerEntry entry) throws Exception {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        this.checkOidIsUniqueForComparator(entry);
        Comparator comparator = this.factory.getComparator(entry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            ComparatorDescription comparatorDescription = this.getComparatorDescription(schema.getSchemaName(), entry);
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    public void add(ComparatorDescription comparatorDescription) throws Exception {
        Schema schema;
        Comparator comparator = this.factory.getComparator(comparatorDescription, this.targetRegistries);
        String schemaName = "other";
        if (comparatorDescription.getExtensions().get("X-SCHEMA") != null) {
            schemaName = (String)((List)comparatorDescription.getExtensions().get("X-SCHEMA")).get(0);
        }
        if (!(schema = this.loader.getSchema(schemaName)).isDisabled()) {
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    public void delete(LdapDN name, ServerEntry entry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        this.delete(oid, cascade);
    }

    public void delete(String oid, boolean cascade) throws NamingException {
        if (this.matchingRuleRegistry.hasMatchingRule(oid)) {
            throw new LdapOperationNotSupportedException("The comparator with OID " + oid + " cannot be deleted until all " + "matchingRules using that comparator have also been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        if (this.comparatorRegistry.hasComparator(oid)) {
            this.comparatorRegistry.unregister(oid);
        }
    }

    public void rename(LdapDN name, ServerEntry entry, Rdn newRdn, boolean cascade) throws Exception {
        String oldOid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oldOid)) {
            throw new LdapOperationNotSupportedException("The comparator with OID " + oldOid + " cannot have it's OID changed until all " + "matchingRules using that comparator have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = (String)newRdn.getValue();
        this.checkOidIsUniqueForComparator(oid);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            Comparator comparator = this.factory.getComparator(entry, this.targetRegistries);
            this.comparatorRegistry.unregister(oldOid);
            ComparatorDescription comparatorDescription = this.getComparatorDescription(schema.getSchemaName(), entry);
            comparatorDescription.setNumericOid(oid);
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, Rdn newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oldOid)) {
            throw new LdapOperationNotSupportedException("The comparator with OID " + oldOid + " cannot have it's OID changed until all " + "matchingRules using that comparator have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String oid = (String)newRdn.getValue();
        this.checkOidIsUniqueForComparator(oid);
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Comparator comparator = this.factory.getComparator(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.comparatorRegistry.unregister(oldOid);
        }
        if (!newSchema.isDisabled()) {
            ComparatorDescription comparatorDescription = this.getComparatorDescription(newSchema.getSchemaName(), entry);
            comparatorDescription.setNumericOid(oid);
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        if (this.matchingRuleRegistry.hasMatchingRule(oid)) {
            throw new LdapOperationNotSupportedException("The comparator with OID " + oid + " cannot be moved to another schema until all " + "matchingRules using that comparator have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        Comparator comparator = this.factory.getComparator(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.comparatorRegistry.unregister(oid);
        }
        if (!newSchema.isDisabled()) {
            ComparatorDescription comparatorDescription = this.getComparatorDescription(newSchema.getSchemaName(), entry);
            this.comparatorRegistry.register(comparatorDescription, comparator);
        }
    }

    private void checkOidIsUniqueForComparator(String oid) throws NamingException {
        if (this.targetRegistries.getComparatorRegistry().hasComparator(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema comparator is not unique.", ResultCodeEnum.OTHER);
        }
    }

    private void checkOidIsUniqueForComparator(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.targetRegistries.getComparatorRegistry().hasComparator(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema comparator is not unique.", ResultCodeEnum.OTHER);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a comparator should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a comparator should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("comparators")) {
            throw new LdapInvalidNameException("The parent entry of a comparator should have a relative name of ou=comparators.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

