/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.util.HashMap;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.normalizers.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartitionNexus
implements Partition {
    public static final String ADMIN_UID = "admin";
    public static final String ADMIN_PASSWORD_STRING = "secret";
    public static final byte[] ADMIN_PASSWORD_BYTES = StringTools.getBytesUtf8((String)"secret");

    public static final LdapDN getAdminName() {
        LdapDN adminDn = null;
        try {
            adminDn = new LdapDN("uid=admin,ou=system");
        }
        catch (Exception e) {
            throw new InternalError();
        }
        try {
            HashMap<String, OidNormalizer> oidsMap = new HashMap<String, OidNormalizer>();
            oidsMap.put("uid", new OidNormalizer("0.9.2342.19200300.100.1.1", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("userid", new OidNormalizer("0.9.2342.19200300.100.1.1", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("0.9.2342.19200300.100.1.1", new OidNormalizer("0.9.2342.19200300.100.1.1", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("ou", new OidNormalizer("2.5.4.11", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("organizationalUnitName", new OidNormalizer("2.5.4.11", (Normalizer)new NoOpNormalizer()));
            oidsMap.put("2.5.4.11", new OidNormalizer("2.5.4.11", (Normalizer)new NoOpNormalizer()));
            adminDn.normalize(oidsMap);
        }
        catch (InvalidNameException ine) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return adminDn;
    }

    public static final LdapDN getGroupsBaseName() {
        LdapDN groupsBaseDn = null;
        try {
            groupsBaseDn = new LdapDN("ou=groups,ou=system");
        }
        catch (Exception e) {
            throw new InternalError();
        }
        return groupsBaseDn;
    }

    public static final LdapDN getUsersBaseName() {
        LdapDN usersBaseDn = null;
        try {
            usersBaseDn = new LdapDN("ou=users,ou=system");
        }
        catch (Exception e) {
            throw new InternalError();
        }
        return usersBaseDn;
    }

    public abstract LdapContext getLdapContext();

    public abstract ClonedServerEntry getRootDSE(GetRootDSEOperationContext var1) throws Exception;

    public abstract boolean compare(CompareOperationContext var1) throws Exception;

    public abstract void addContextPartition(AddContextPartitionOperationContext var1) throws Exception;

    public abstract void removeContextPartition(RemoveContextPartitionOperationContext var1) throws Exception;

    public abstract Partition getSystemPartition();

    public abstract Partition getPartition(LdapDN var1) throws Exception;

    public abstract LdapDN getMatchedName(GetMatchedNameOperationContext var1) throws Exception;

    public abstract LdapDN getSuffix(GetSuffixOperationContext var1) throws Exception;

    public abstract Set<String> listSuffixes(ListSuffixOperationContext var1) throws Exception;

    public abstract void registerSupportedExtensions(Set<String> var1) throws Exception;

    public abstract void registerSupportedSaslMechanisms(Set<String> var1) throws Exception;
}

