/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.Map;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.normalization.FilterNormalizingVisitor;
import org.apache.directory.server.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationInterceptor.class);
    private FilterNormalizingVisitor normVisitor;
    private Map<String, OidNormalizer> attrNormalizers;
    private AttributeTypeRegistry attributeRegistry;

    public void init(DirectoryService directoryService) throws Exception {
        LOG.debug("Initialiazing the NormalizationInterceptor");
        OidRegistry oidRegistry = directoryService.getRegistries().getOidRegistry();
        this.attributeRegistry = directoryService.getRegistries().getAttributeTypeRegistry();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.attributeRegistry, oidRegistry);
        this.normVisitor = new FilterNormalizingVisitor((NameComponentNormalizer)ncn, directoryService.getRegistries());
        this.attrNormalizers = this.attributeRegistry.getNormalizerMapping();
    }

    public void destroy() {
    }

    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        opContext.getEntry().getDn().normalize(this.attrNormalizers);
        this.addRdnAttributesToEntry(opContext.getDn(), (ServerEntry)opContext.getEntry());
        nextInterceptor.add(opContext);
    }

    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        nextInterceptor.delete(opContext);
    }

    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        nextInterceptor.modify(opContext);
    }

    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        LdapDN rdn = new LdapDN();
        rdn.add(opContext.getNewRdn());
        rdn.normalize(this.attrNormalizers);
        opContext.setNewRdn(rdn.getRdn());
        opContext.getDn().normalize(this.attrNormalizers);
        nextInterceptor.rename(opContext);
    }

    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        opContext.getParent().normalize(this.attrNormalizers);
        nextInterceptor.move(opContext);
    }

    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        LdapDN rdn = new LdapDN();
        rdn.add(opContext.getNewRdn());
        rdn.normalize(this.attrNormalizers);
        opContext.setNewRdn(rdn.getRdn());
        opContext.getDn().normalize(this.attrNormalizers);
        opContext.getParent().normalize(this.attrNormalizers);
        nextInterceptor.moveAndRename(opContext);
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        ExprNode filter = opContext.getFilter();
        ExprNode result = (ExprNode)filter.accept((FilterVisitor)this.normVisitor);
        if (result == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor((Cursor<ServerEntry>)new EmptyCursor(), opContext);
        }
        opContext.setFilter(result);
        return nextInterceptor.search(opContext);
    }

    public boolean hasEntry(NextInterceptor nextInterceptor, EntryOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return nextInterceptor.hasEntry(opContext);
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return nextInterceptor.list(opContext);
    }

    private String[] normalizeAttrsId(String[] attrIds) throws Exception {
        if (attrIds == null) {
            return attrIds;
        }
        String[] normalizedAttrIds = new String[attrIds.length];
        int pos = 0;
        for (String id : attrIds) {
            String oid = this.attributeRegistry.lookup(id).getOid();
            normalizedAttrIds[pos++] = oid;
        }
        return normalizedAttrIds;
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        if (opContext.getAttrsId() != null) {
            opContext.setAttrsId(this.normalizeAttrsId(opContext.getAttrsIdArray()));
        }
        return nextInterceptor.lookup(opContext);
    }

    public LdapDN getMatchedName(NextInterceptor nextInterceptor, GetMatchedNameOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return nextInterceptor.getMatchedName(opContext);
    }

    public LdapDN getSuffix(NextInterceptor nextInterceptor, GetSuffixOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return nextInterceptor.getSuffix(opContext);
    }

    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        AttributeType at = opContext.getSession().getDirectoryService().getRegistries().getAttributeTypeRegistry().lookup(opContext.getOid());
        if (at.getSyntax().isHumanReadable() && opContext.getValue().isBinary()) {
            String value = opContext.getValue().getString();
            opContext.setValue((Value<?>)new ClientStringValue(value));
        }
        return next.compare(opContext);
    }

    public void bind(NextInterceptor next, BindOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        next.bind(opContext);
    }

    public void addContextPartition(NextInterceptor next, AddContextPartitionOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        next.addContextPartition(opContext);
    }

    public void removeContextPartition(NextInterceptor next, RemoveContextPartitionOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        next.removeContextPartition(opContext);
    }

    private void addRdnAttributesToEntry(LdapDN dn, ServerEntry entry) throws Exception {
        if (dn == null || entry == null) {
            return;
        }
        Rdn rdn = dn.getRdn();
        for (AttributeTypeAndValue ava : rdn) {
            String value = ava.getNormValue().getString();
            String upValue = ava.getUpValue().getString();
            String upId = ava.getUpType();
            if (entry.contains(upId, new String[]{value})) continue;
            String message = "The RDN '" + upId + "=" + upValue + "' is not present in the entry";
            LOG.warn(message);
            if (!entry.containsAttribute(new String[]{upId})) {
                this.addUnescapedUpValue(entry, upId, upValue);
                continue;
            }
            AttributeType at = this.attributeRegistry.lookup(upId);
            if (at.isSingleValue()) {
                entry.removeAttributes(new String[]{upId});
                this.addUnescapedUpValue(entry, upId, upValue);
                continue;
            }
            this.addUnescapedUpValue(entry, upId, upValue);
        }
    }

    private void addUnescapedUpValue(ServerEntry entry, String upId, String upValue) throws Exception {
        Object unescapedUpValue = Rdn.unescapeValue((String)upValue);
        if (unescapedUpValue instanceof String) {
            entry.add(upId, new String[]{(String)unescapedUpValue});
        } else {
            entry.add(upId, (byte[][])new byte[][]{(byte[])unescapedUpValue});
        }
    }
}

