/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.journal;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.journal.Journal;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(JournalInterceptor.class);
    private boolean journalEnabled;
    private AtomicLong revision;
    private Journal journal;

    public void init(DirectoryService directoryService) throws Exception {
        super.init(directoryService);
        if (directoryService.getJournal().isEnabled()) {
            this.journalEnabled = true;
            this.journal = directoryService.getJournal();
            this.revision = new AtomicLong(System.currentTimeMillis());
        }
        LOG.debug("JournalInterceptor has been initialized");
    }

    private void log(long revision, LdifEntry ldif) throws Exception {
        this.journal.log(JournalInterceptor.getPrincipal(), revision, ldif);
    }

    public void add(NextInterceptor next, AddOperationContext opContext) throws Exception {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            ClonedServerEntry addEntry = opContext.getEntry();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.Add);
            ldif.setDn(opContext.getDn());
            Set list = addEntry.getAttributeTypes();
            for (AttributeType attributeType : list) {
                ldif.addAttribute(((ServerAttribute)addEntry.get(attributeType)).toClientAttribute());
            }
            this.log(opRevision, ldif);
        }
        try {
            next.add(opContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (Exception e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void delete(NextInterceptor next, DeleteOperationContext opContext) throws Exception {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.Delete);
            ldif.setDn(opContext.getDn());
            this.journal.log(JournalInterceptor.getPrincipal(), opRevision, ldif);
        }
        try {
            next.delete(opContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (Exception e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void modify(NextInterceptor next, ModifyOperationContext opContext) throws Exception {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.Modify);
            ldif.setDn(opContext.getDn());
            for (Modification modification : opContext.getModItems()) {
                ldif.addModificationItem(modification);
            }
            this.journal.log(JournalInterceptor.getPrincipal(), opRevision, ldif);
        }
        try {
            next.modify(opContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (Exception e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void rename(NextInterceptor next, RenameOperationContext opContext) throws Exception {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.ModRdn);
            ldif.setDn(opContext.getDn());
            ldif.setNewRdn(opContext.getNewRdn().toString());
            ldif.setDeleteOldRdn(opContext.getDelOldDn());
            this.journal.log(JournalInterceptor.getPrincipal(), opRevision, ldif);
        }
        try {
            next.rename(opContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (Exception e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void moveAndRename(NextInterceptor next, MoveAndRenameOperationContext opContext) throws Exception {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.ModDn);
            ldif.setDn(opContext.getDn());
            ldif.setNewRdn(opContext.getNewRdn().toString());
            ldif.setDeleteOldRdn(opContext.getDelOldDn());
            ldif.setNewSuperior(opContext.getNewDn().toString());
            this.journal.log(JournalInterceptor.getPrincipal(), opRevision, ldif);
        }
        try {
            next.moveAndRename(opContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (Exception e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }

    public void move(NextInterceptor next, MoveOperationContext opContext) throws Exception {
        long opRevision = 0L;
        if (this.journalEnabled) {
            opRevision = this.revision.incrementAndGet();
            LdifEntry ldif = new LdifEntry();
            ldif.setChangeType(ChangeType.ModDn);
            ldif.setDn(opContext.getDn());
            ldif.setNewSuperior(opContext.getParent().toString());
            this.journal.log(JournalInterceptor.getPrincipal(), opRevision, ldif);
        }
        try {
            next.move(opContext);
            if (this.journalEnabled) {
                this.journal.ack(opRevision);
            }
        }
        catch (Exception e) {
            if (this.journalEnabled) {
                this.journal.nack(opRevision);
            }
            throw e;
        }
    }
}

