/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.name.LdapDN;

public class ScopeEvaluator
implements Evaluator {
    public boolean evaluate(ExprNode node, String dn, ServerEntry record) throws NamingException {
        ScopeNode snode = (ScopeNode)node;
        switch (snode.getScope()) {
            case OBJECT: {
                return dn.equals(snode.getBaseDn());
            }
            case ONELEVEL: {
                if (dn.endsWith(snode.getBaseDn())) {
                    LdapDN candidateDn = new LdapDN(dn);
                    LdapDN scopeDn = new LdapDN(snode.getBaseDn());
                    return scopeDn.size() + 1 == candidateDn.size();
                }
            }
            case SUBTREE: {
                return dn.endsWith(snode.getBaseDn());
            }
        }
        throw new NamingException("Unrecognized search scope!");
    }
}

