/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.pool;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.pool.BlockingLdapPool;
import edu.vt.middleware.ldap.pool.DefaultLdapFactory;
import edu.vt.middleware.ldap.pool.LdapFactory;
import edu.vt.middleware.ldap.pool.LdapPoolConfig;
import edu.vt.middleware.ldap.pool.LdapPoolException;
import edu.vt.middleware.ldap.pool.LdapPoolExhaustedException;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftLimitLdapPool
extends BlockingLdapPool {
    public SoftLimitLdapPool() {
        super(new LdapPoolConfig(), new DefaultLdapFactory());
    }

    public SoftLimitLdapPool(LdapFactory<Ldap> lf) {
        super(new LdapPoolConfig(), lf);
    }

    public SoftLimitLdapPool(LdapPoolConfig lpc, LdapFactory<Ldap> lf) {
        super(lpc, lf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ldap checkOut() throws LdapPoolException {
        Ldap l;
        block16: {
            l = null;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("waiting on pool lock for check out " + this.poolLock.getQueueLength()));
            }
            this.poolLock.lock();
            try {
                if (this.available.size() <= 0) break block16;
                try {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)"retrieve available ldap object");
                    }
                    l = this.retrieveAvailable();
                }
                catch (NoSuchElementException e) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)"could not remove ldap object from list", (Throwable)e);
                    }
                    throw new IllegalStateException("Pool is empty", e);
                }
            }
            finally {
                this.poolLock.unlock();
            }
        }
        if (l == null) {
            l = (Ldap)this.createActive();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("created new active ldap object: " + l));
            }
            if (l == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"created failed, block until an object is available");
                }
                l = this.blockAvailable();
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("created new active ldap object: " + l));
            }
        }
        if (l == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)"Could not service check out request");
            }
            throw new LdapPoolExhaustedException("Pool is empty and object creation failed");
        }
        this.activateAndValidate(l);
        return l;
    }
}

