/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.ldap.jaas;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.LdapConfig;
import edu.vt.middleware.ldap.auth.Authenticator;
import edu.vt.middleware.ldap.auth.AuthenticatorConfig;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapBeanProvider;
import edu.vt.middleware.ldap.jaas.JaasAuthenticator;
import edu.vt.middleware.ldap.jaas.LdapCredential;
import edu.vt.middleware.ldap.jaas.LdapDnPrincipal;
import edu.vt.middleware.ldap.jaas.LdapGroup;
import edu.vt.middleware.ldap.jaas.LdapPrincipal;
import edu.vt.middleware.ldap.jaas.LdapRole;
import edu.vt.middleware.ldap.props.LdapProperties;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoginModule
implements LoginModule {
    public static final String LOGIN_NAME = "javax.security.auth.login.name";
    public static final String LOGIN_DN = "edu.vt.middleware.ldap.jaas.login.entryDn";
    public static final String LOGIN_PASSWORD = "javax.security.auth.login.password";
    private static final String IGNORE_LDAP_REGEX = "useFirstPass|tryFirstPass|storePass|setLdapPrincipal|setLdapDnPrincipal|setLdapCredential|defaultRole|principalGroupName|roleGroupName|userRoleAttribute|roleFilter|roleAttribute|noResultsIsError";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected boolean useFirstPass;
    protected boolean tryFirstPass;
    protected boolean storePass;
    protected boolean setLdapPrincipal;
    protected boolean setLdapDnPrincipal;
    protected boolean setLdapCredential;
    protected List<LdapRole> defaultRole = new ArrayList<LdapRole>();
    protected String principalGroupName;
    protected String roleGroupName;
    protected boolean success;
    protected Set<Principal> principals;
    protected Set<LdapCredential> credentials;
    protected Set<Principal> roles;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Begin initialize");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (key.equalsIgnoreCase("useFirstPass")) {
                this.useFirstPass = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase("tryFirstPass")) {
                this.tryFirstPass = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase("storePass")) {
                this.storePass = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase("setLdapPrincipal")) {
                this.setLdapPrincipal = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase("setLdapDnPrincipal")) {
                this.setLdapDnPrincipal = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase("setLdapCredential")) {
                this.setLdapCredential = Boolean.valueOf(value);
                continue;
            }
            if (key.equalsIgnoreCase("defaultRole")) {
                for (String s : value.split(",")) {
                    this.defaultRole.add(new LdapRole(s.trim()));
                }
                continue;
            }
            if (key.equalsIgnoreCase("principalGroupName")) {
                this.principalGroupName = value;
                continue;
            }
            if (!key.equalsIgnoreCase("roleGroupName")) continue;
            this.roleGroupName = value;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("useFirstPass = " + this.useFirstPass));
            this.logger.debug((Object)("tryFirstPass = " + this.tryFirstPass));
            this.logger.debug((Object)("storePass = " + this.storePass));
            this.logger.debug((Object)("setLdapPrincipal = " + this.setLdapPrincipal));
            this.logger.debug((Object)("setLdapDnPrincipal = " + this.setLdapDnPrincipal));
            this.logger.debug((Object)("setLdapCredential = " + this.setLdapCredential));
            this.logger.debug((Object)("defaultRole = " + this.defaultRole));
            this.logger.debug((Object)("principalGroupName = " + this.principalGroupName));
            this.logger.debug((Object)("roleGroupName = " + this.roleGroupName));
        }
        this.principals = new TreeSet<Principal>();
        this.credentials = new HashSet<LdapCredential>();
        this.roles = new TreeSet<Principal>();
    }

    @Override
    public abstract boolean login() throws LoginException;

    @Override
    public boolean commit() throws LoginException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Begin commit");
        }
        if (this.success) {
            LdapGroup group;
            if (this.subject.isReadOnly()) {
                throw new LoginException("Subject is read-only.");
            }
            this.subject.getPrincipals().addAll(this.principals);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Committed the following principals: " + this.principals));
            }
            this.subject.getPrivateCredentials().addAll(this.credentials);
            this.subject.getPrincipals().addAll(this.roles);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Committed the following roles: " + this.roles));
            }
            if (this.principalGroupName != null) {
                group = new LdapGroup(this.principalGroupName);
                for (Principal principal : this.principals) {
                    group.addMember(principal);
                }
                this.subject.getPrincipals().add((Principal)((Object)group));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Committed the following principal group: " + group));
                }
            }
            if (this.roleGroupName != null) {
                group = new LdapGroup(this.roleGroupName);
                for (Principal role : this.roles) {
                    group.addMember(role);
                }
                this.subject.getPrincipals().add((Principal)((Object)group));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Committed the following role group: " + group));
                }
            }
        }
        this.principals.clear();
        this.credentials.clear();
        this.roles.clear();
        return true;
    }

    @Override
    public boolean abort() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Begin abort");
        }
        this.success = false;
        this.logout();
        return true;
    }

    @Override
    public boolean logout() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Begin logout");
        }
        this.principals.clear();
        this.credentials.clear();
        this.roles.clear();
        Iterator<LdapPrincipal> prinIter = this.subject.getPrincipals(LdapPrincipal.class).iterator();
        while (prinIter.hasNext()) {
            this.subject.getPrincipals().remove(prinIter.next());
        }
        Iterator<LdapDnPrincipal> dnPrinIter = this.subject.getPrincipals(LdapDnPrincipal.class).iterator();
        while (dnPrinIter.hasNext()) {
            this.subject.getPrincipals().remove(dnPrinIter.next());
        }
        Iterator<LdapRole> roleIter = this.subject.getPrincipals(LdapRole.class).iterator();
        while (roleIter.hasNext()) {
            this.subject.getPrincipals().remove(roleIter.next());
        }
        Iterator<LdapGroup> groupIter = this.subject.getPrincipals(LdapGroup.class).iterator();
        while (groupIter.hasNext()) {
            this.subject.getPrincipals().remove(groupIter.next());
        }
        Iterator<LdapCredential> credIter = this.subject.getPrivateCredentials(LdapCredential.class).iterator();
        while (credIter.hasNext()) {
            this.subject.getPrivateCredentials().remove(credIter.next());
        }
        return true;
    }

    public static Ldap createLdap(Map<String, ?> options) {
        LdapConfig ldapConfig = new LdapConfig();
        LdapProperties ldapProperties = new LdapProperties(ldapConfig);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (key.matches(IGNORE_LDAP_REGEX)) continue;
            ldapProperties.setProperty(key, value);
        }
        ldapProperties.configure();
        return new Ldap(ldapConfig);
    }

    public static Authenticator createAuthenticator(Map<String, ?> options) {
        AuthenticatorConfig authConfig = new AuthenticatorConfig();
        LdapProperties authProperties = new LdapProperties(authConfig);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (key.matches(IGNORE_LDAP_REGEX)) continue;
            authProperties.setProperty(key, value);
        }
        authProperties.configure();
        return new JaasAuthenticator(authConfig);
    }

    protected void getCredentials(NameCallback nameCb, PasswordCallback passCb, boolean useCallback) throws LoginException {
        block8: {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Begin getCredentials");
                this.logger.trace((Object)("  useFistPass = " + this.useFirstPass));
                this.logger.trace((Object)("  tryFistPass = " + this.tryFirstPass));
                this.logger.trace((Object)("  useCallback = " + useCallback));
                this.logger.trace((Object)("  callbackhandler class = " + this.callbackHandler.getClass().getName()));
                this.logger.trace((Object)("  name callback class = " + nameCb.getClass().getName()));
                this.logger.trace((Object)("  password callback class = " + passCb.getClass().getName()));
            }
            try {
                if ((this.useFirstPass || this.tryFirstPass) && !useCallback) {
                    nameCb.setName((String)this.sharedState.get(LOGIN_NAME));
                    passCb.setPassword((char[])this.sharedState.get(LOGIN_PASSWORD));
                    break block8;
                }
                if (this.callbackHandler != null) {
                    this.callbackHandler.handle(new Callback[]{nameCb, passCb});
                    break block8;
                }
                throw new LoginException("No CallbackHandler available. Set useFirstPass, tryFirstPass, or provide a CallbackHandler");
            }
            catch (IOException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)"Error reading data from callback handler", (Throwable)e);
                }
                this.success = false;
                throw new LoginException(e.getMessage());
            }
            catch (UnsupportedCallbackException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)"Unsupported callback", (Throwable)e);
                }
                this.success = false;
                throw new LoginException(e.getMessage());
            }
        }
    }

    protected void storeCredentials(NameCallback nameCb, PasswordCallback passCb, String loginDn) {
        if (this.storePass) {
            if (nameCb != null && nameCb.getName() != null) {
                this.sharedState.put(LOGIN_NAME, nameCb.getName());
            }
            if (passCb != null && passCb.getPassword() != null) {
                this.sharedState.put(LOGIN_PASSWORD, passCb.getPassword());
            }
            if (loginDn != null) {
                this.sharedState.put(LOGIN_DN, loginDn);
            }
        }
    }

    protected List<LdapRole> attributesToRoles(Attributes attributes) throws NamingException {
        ArrayList<LdapRole> roles = new ArrayList<LdapRole>();
        if (attributes != null) {
            LdapAttributes ldapAttrs = LdapBeanProvider.getLdapBeanFactory().newLdapAttributes();
            ldapAttrs.addAttributes(attributes);
            for (LdapAttribute ldapAttr : ldapAttrs.getAttributes()) {
                for (String attrValue : ldapAttr.getStringValues()) {
                    roles.add(new LdapRole(attrValue));
                }
            }
        }
        return roles;
    }
}

