/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.config.security;

import edu.internet2.middleware.shibboleth.common.config.security.AbstractX509CredentialBeanDefinitionParser;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.springframework.beans.FatalBeanException;

public class FilesystemX509CredentialBeanDefinitionParser
extends AbstractX509CredentialBeanDefinitionParser {
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:security", "X509Filesystem");

    protected byte[] getEncodedCRL(String certCRLContent) {
        try {
            FileInputStream ins = new FileInputStream(certCRLContent);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return encoded;
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to read CRL(s) from file " + certCRLContent, (Throwable)e);
        }
    }

    protected byte[] getEncodedCertificate(String certConfigContent) {
        try {
            FileInputStream ins = new FileInputStream(certConfigContent);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return encoded;
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to read certificate(s) from file " + certConfigContent, (Throwable)e);
        }
    }

    protected byte[] getEncodedPrivateKey(String keyConfigContent) {
        try {
            FileInputStream ins = new FileInputStream(keyConfigContent);
            byte[] encoded = new byte[ins.available()];
            ins.read(encoded);
            return encoded;
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to read private key from file " + keyConfigContent, (Throwable)e);
        }
    }
}

