/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector;

import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.StoredIDDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.StoredIDStore;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.principalConnector.BasePrincipalConnector;
import edu.internet2.middleware.shibboleth.common.profile.provider.SAMLProfileRequestContext;
import java.sql.SQLException;
import org.opensaml.saml1.core.NameIdentifier;
import org.opensaml.saml2.core.NameID;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredIDPrincipalConnector
extends BasePrincipalConnector {
    private final Logger log = LoggerFactory.getLogger(StoredIDPrincipalConnector.class);
    private StoredIDStore pidStore;

    public StoredIDPrincipalConnector(StoredIDDataConnector idProducer) {
        if (idProducer == null) {
            throw new IllegalArgumentException("ID producing data connector may not be null");
        }
        this.pidStore = idProducer.getStoredIDStore();
    }

    public String resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String persistentId;
        SAMLProfileRequestContext requestContext = resolutionContext.getAttributeRequestContext();
        if (requestContext.getSubjectNameIdentifier() instanceof NameIdentifier) {
            persistentId = ((NameIdentifier)requestContext.getSubjectNameIdentifier()).getNameIdentifier();
        } else if (requestContext.getSubjectNameIdentifier() instanceof NameID) {
            persistentId = ((NameID)requestContext.getSubjectNameIdentifier()).getValue();
        } else {
            throw new AttributeResolutionException("Subject name identifier is not of a supported type");
        }
        try {
            StoredIDStore.PersistentIdEntry pidEntry = this.pidStore.getActivePersistentIdEntry(persistentId);
            if (pidEntry == null) {
                return null;
            }
            if (!DatatypeHelper.safeEquals((Object)requestContext.getInboundMessageIssuer(), (Object)pidEntry.getPeerEntityId())) {
                this.log.warn("Requester '{}' attempted to use identifier '{}' which was issued to the entity '{}'", new Object[]{requestContext.getInboundMessageIssuer(), pidEntry.getPersistentId(), pidEntry.getPeerEntityId()});
                return null;
            }
            return pidEntry.getPrincipalName();
        }
        catch (SQLException e) {
            this.log.error("Error retrieving persistent ID from database", (Throwable)e);
            throw new AttributeResolutionException("Error retrieving persistent ID from database", e);
        }
    }

    public void validate() throws AttributeResolutionException {
        if (this.pidStore == null) {
            throw new AttributeResolutionException("Persistent ID store was null");
        }
        try {
            this.pidStore.getPersistentIdEntry("test", false);
        }
        catch (SQLException e) {
            throw new AttributeResolutionException("Persistent ID store can not perform persistent ID search", e);
        }
    }
}

