/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.RDBMSColumnDescriptor;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDBMSDataConnector
extends BaseDataConnector {
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnector.class);
    private DataSource dataSource;
    private TemplateEngine queryCreator;
    private String queryTemplateName;
    private String queryTemplate;
    private int queryTimeout;
    private boolean readOnlyConnection;
    private boolean usesStoredProcedure;
    private boolean noResultIsError;
    private Map<String, RDBMSColumnDescriptor> columnDescriptors;
    private Cache resultsCache;

    public RDBMSDataConnector(DataSource source, Cache cache) {
        this.dataSource = source;
        this.resultsCache = cache;
        this.readOnlyConnection = true;
        this.usesStoredProcedure = false;
        this.noResultIsError = false;
        this.columnDescriptors = new HashMap<String, RDBMSColumnDescriptor>();
    }

    public void registerTemplate(TemplateEngine engine, String template) {
        if (this.getId() == null) {
            throw new IllegalStateException("Template cannot be registered until plugin id has been set");
        }
        this.queryCreator = engine;
        this.queryTemplate = template;
        this.queryTemplateName = "shibboleth.resolver.dc." + this.getId();
        this.queryCreator.registerTemplate(this.queryTemplateName, this.queryTemplate);
    }

    public boolean isCachingResuts() {
        return this.resultsCache != null;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int timeout) {
        this.queryTimeout = timeout;
    }

    public boolean isConnectionReadOnly() {
        return this.readOnlyConnection;
    }

    public void setConnectionReadOnly(boolean isReadOnly) {
        this.readOnlyConnection = isReadOnly;
    }

    public boolean getUsesStoredProcedure() {
        return this.usesStoredProcedure;
    }

    public void setUsesStoredProcedure(boolean storedProcedure) {
        this.usesStoredProcedure = storedProcedure;
    }

    public boolean isNoResultIsError() {
        return this.noResultIsError;
    }

    public void setNoResultIsError(boolean isError) {
        this.noResultIsError = isError;
    }

    public Map<String, RDBMSColumnDescriptor> getColumnDescriptor() {
        return this.columnDescriptors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validate() throws AttributeResolutionException {
        this.log.debug("RDBMS data connector {} - Validating configuration.", (Object)this.getId());
        if (this.dataSource == null) {
            this.log.error("RDBMS data connector {} - Datasource is null", (Object)this.getId());
            throw new AttributeResolutionException("Datasource is null");
        }
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            if (connection == null) {
                this.log.error("RDBMS data connector {} - Unable to create connections", (Object)this.getId());
                throw new AttributeResolutionException("Unable to create connections for RDBMS data connector " + this.getId());
            }
            DatabaseMetaData dbmd = connection.getMetaData();
            if (!dbmd.supportsStoredProcedures() && this.usesStoredProcedure) {
                this.log.error("RDBMS data connector {} - Database does not support stored procedures.", (Object)this.getId());
                throw new AttributeResolutionException("Database does not support stored procedures.");
            }
            this.log.debug("RDBMS data connector {} - Connector configuration is valid.", (Object)this.getId());
        }
        catch (SQLException e) {
            try {
                if (e.getSQLState() != null) {
                    this.log.error("RDBMS data connector {} - Invalid connector configuration; SQL state: {}, SQL Code: {}", (Object)new Object[]{this.getId(), e.getSQLState(), e.getErrorCode()}, (Object)e);
                    throw new AttributeResolutionException("Invalid connector configuration", e);
                }
                this.log.error("RDBMS data connector {} - Invalid connector configuration", (Object)new Object[]{this.getId()}, (Object)e);
                throw new AttributeResolutionException("Invalid connector configuration", e);
            }
            catch (Throwable throwable) {
                try {
                    if (connection == null) throw throwable;
                    if (connection.isClosed()) throw throwable;
                    connection.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    this.log.error("RDBMS data connector {} - Error closing database connection; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getId(), e2.getSQLState(), e2.getErrorCode()}, (Object)e2);
                }
                throw throwable;
            }
        }
        try {
            if (connection == null) return;
            if (connection.isClosed()) return;
            connection.close();
            return;
        }
        catch (SQLException e) {
            this.log.error("RDBMS data connector {} - Error closing database connection; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getId(), e.getSQLState(), e.getErrorCode()}, (Object)e);
            return;
        }
    }

    @Override
    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String query = this.queryCreator.createStatement(this.queryTemplateName, resolutionContext, this.getDependencyIds(), null);
        this.log.debug("RDBMS data connector {} - Search Query: {}", (Object)this.getId(), (Object)query);
        Map<String, BaseAttribute> resolvedAttributes = null;
        resolvedAttributes = this.retrieveAttributesFromCache(resolutionContext.getAttributeRequestContext().getPrincipalName(), query);
        if (resolvedAttributes == null) {
            resolvedAttributes = this.retrieveAttributesFromDatabase(query);
        }
        this.cacheResult(resolutionContext.getAttributeRequestContext().getPrincipalName(), query, resolvedAttributes);
        return resolvedAttributes;
    }

    protected Map<String, BaseAttribute> retrieveAttributesFromCache(String principal, String query) throws AttributeResolutionException {
        if (this.resultsCache == null) {
            return null;
        }
        Element cacheElement = this.resultsCache.get((Serializable)((Object)query));
        if (cacheElement != null && !cacheElement.isExpired()) {
            this.log.debug("RDBMS data connector {} - Fetched attributes from cache for principal {}", (Object)this.getId(), (Object)principal);
            return (Map)cacheElement.getObjectValue();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, BaseAttribute> retrieveAttributesFromDatabase(String query) throws AttributeResolutionException {
        Map<String, BaseAttribute> map;
        Connection connection = null;
        ResultSet queryResult = null;
        try {
            connection = this.dataSource.getConnection();
            if (this.readOnlyConnection) {
                connection.setReadOnly(true);
            }
            this.log.debug("RDBMS data connector {} - Querying database for attributes with query {}", (Object)this.getId(), (Object)query);
            Statement stmt = connection.createStatement();
            stmt.setQueryTimeout(this.queryTimeout);
            queryResult = stmt.executeQuery(query);
            Map<String, BaseAttribute> resolvedAttributes = this.processResultSet(queryResult);
            if (resolvedAttributes.isEmpty() && this.noResultIsError) {
                this.log.debug("RDBMS data connector {} - No attributes from query", (Object)this.getId());
                throw new AttributeResolutionException("No attributes returned from query");
            }
            this.log.debug("RDBMS data connector {} - Retrieved attributes: {}", (Object)this.getId(), resolvedAttributes.keySet());
            map = resolvedAttributes;
        }
        catch (SQLException e) {
            try {
                this.log.debug("RDBMS data connector {} - Unable to execute SQL query {}; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getId(), query, e.getSQLState(), e.getErrorCode()}, (Object)e);
                throw new AttributeResolutionException("Unable to execute SQL query", e);
            }
            catch (Throwable throwable) {
                try {
                    if (queryResult != null) {
                        queryResult.close();
                    }
                    if (connection == null) throw throwable;
                    if (connection.isClosed()) throw throwable;
                    connection.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    this.log.debug("RDBMS data connector {} - Unable to close database connection; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getId(), e2.getSQLState(), e2.getErrorCode()}, (Object)e2);
                }
                throw throwable;
            }
        }
        try {
            if (queryResult != null) {
                queryResult.close();
            }
            if (connection == null) return map;
            if (connection.isClosed()) return map;
            connection.close();
            return map;
        }
        catch (SQLException e) {
            this.log.debug("RDBMS data connector {} - Unable to close database connection; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getId(), e.getSQLState(), e.getErrorCode()}, (Object)e);
        }
        return map;
    }

    protected Map<String, BaseAttribute> processResultSet(ResultSet resultSet) throws AttributeResolutionException {
        HashMap<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
        try {
            if (!resultSet.next()) {
                return attributes;
            }
            ResultSetMetaData resultMD = resultSet.getMetaData();
            int numOfCols = resultMD.getColumnCount();
            do {
                for (int i = 1; i <= numOfCols; ++i) {
                    String columnName = resultMD.getColumnName(i);
                    RDBMSColumnDescriptor columnDescriptor = this.columnDescriptors.get(columnName);
                    String attributeId = columnDescriptor == null || columnDescriptor.getAttributeID() == null ? columnName : columnDescriptor.getAttributeID();
                    BasicAttribute attribute = (BasicAttribute)attributes.get(attributeId);
                    if (attribute == null) {
                        attribute = new BasicAttribute(attributeId);
                    }
                    attributes.put(((BaseAttribute)attribute).getId(), attribute);
                    Collection attributeValues = ((BaseAttribute)attribute).getValues();
                    if (columnDescriptor == null || columnDescriptor.getDataType() == null) {
                        attributeValues.add(resultSet.getObject(i));
                        continue;
                    }
                    this.addValueByType(attributeValues, columnDescriptor.getDataType(), resultSet, i);
                }
            } while (resultSet.next());
        }
        catch (SQLException e) {
            this.log.debug("RDBMS data connector {} - Unable to read data from query result; SQL State: {}, SQL Code: {}", (Object)new Object[]{this.getId(), e.getSQLState(), e.getErrorCode()}, (Object)e);
        }
        return attributes;
    }

    protected void addValueByType(Collection values, DATA_TYPES type, ResultSet resultSet, int columnIndex) throws SQLException {
        switch (type) {
            case BigDecimal: {
                values.add(resultSet.getBigDecimal(columnIndex));
                break;
            }
            case Boolean: {
                values.add(resultSet.getBoolean(columnIndex));
                break;
            }
            case Byte: {
                values.add(resultSet.getByte(columnIndex));
                break;
            }
            case ByteArray: {
                values.add(resultSet.getBytes(columnIndex));
                break;
            }
            case Date: {
                values.add(resultSet.getDate(columnIndex));
                break;
            }
            case Double: {
                values.add(resultSet.getDouble(columnIndex));
                break;
            }
            case Float: {
                values.add(Float.valueOf(resultSet.getFloat(columnIndex)));
                break;
            }
            case Integer: {
                values.add(resultSet.getInt(columnIndex));
                break;
            }
            case Long: {
                values.add(resultSet.getLong(columnIndex));
                break;
            }
            case Object: {
                values.add(resultSet.getObject(columnIndex));
                break;
            }
            case Short: {
                values.add(resultSet.getShort(columnIndex));
                break;
            }
            case Time: {
                values.add(resultSet.getTime(columnIndex));
                break;
            }
            case Timestamp: {
                values.add(resultSet.getTimestamp(columnIndex));
                break;
            }
            case URL: {
                values.add(resultSet.getURL(columnIndex));
                break;
            }
            default: {
                values.add(resultSet.getString(columnIndex));
            }
        }
    }

    protected void cacheResult(String principal, String query, Map<String, BaseAttribute> attributes) {
        if (this.resultsCache == null) {
            return;
        }
        this.log.debug("RDBMS data connector {} - Caching attributes for principal {}", (Object)this.getId(), (Object)principal);
        Element cacheElement = new Element((Object)query, attributes);
        this.resultsCache.put(cacheElement);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DATA_TYPES {
        BigDecimal,
        Boolean,
        Byte,
        ByteArray,
        Date,
        Double,
        Float,
        Integer,
        Long,
        Object,
        Short,
        String,
        Time,
        Timestamp,
        URL;

    }
}

