/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.ValueMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedAttributeDefinition
extends BaseAttributeDefinition {
    private static Logger log = LoggerFactory.getLogger(MappedAttributeDefinition.class);
    private String defaultValue;
    private boolean passThru;
    private Collection<ValueMap> valueMaps = new ArrayList<ValueMap>(5);

    @Override
    protected BaseAttribute doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        BasicAttribute attribute = new BasicAttribute();
        attribute.setId(this.getId());
        Collection<Object> values = this.getValuesFromAllDependencies(resolutionContext);
        if (values == null || values.isEmpty()) {
            log.debug("Attribute Definition {}: No values from dependency attribute attribute {}", (Object)this.getId(), this.getDependencyIds());
            if (!DatatypeHelper.isEmpty((String)this.getDefaultValue())) {
                log.debug("Attribute Definition {}: Default value is not empty, adding it as the value for this attribute", (Object)this.getId());
                attribute.getValues().add(this.getDefaultValue());
            }
            return attribute;
        }
        for (Object o : values) {
            if (o == null) {
                log.debug("Attribute Definition {}: null attribute value, skipping it", (Object)this.getId());
                continue;
            }
            Set<String> mappedValues = this.mapValue(o.toString());
            attribute.getValues().addAll(mappedValues);
        }
        return attribute;
    }

    protected Set<String> mapValue(String value) {
        log.debug("Attribute Definition {}: mapping depdenency attribute value {}", (Object)this.getId(), (Object)value);
        LazySet mappedValues = new LazySet();
        boolean valueMapMatch = false;
        if (!DatatypeHelper.isEmpty((String)value)) {
            for (ValueMap valueMap : this.valueMaps) {
                mappedValues.addAll(valueMap.evaluate(value));
                if (mappedValues.isEmpty()) continue;
                valueMapMatch = true;
            }
            if (!valueMapMatch) {
                if (this.passThru) {
                    mappedValues.add((Object)value);
                } else if (this.getDefaultValue() != null) {
                    mappedValues.add((Object)this.getDefaultValue());
                }
            }
        }
        log.debug("Attribute Definition {}: mapped depdenency attribute value {} to the values {}", new Object[]{this.getId(), value, mappedValues});
        return mappedValues;
    }

    @Override
    public void validate() throws AttributeResolutionException {
        if (this.passThru && !DatatypeHelper.isEmpty((String)this.defaultValue)) {
            log.error("MappedAttributeDefinition (" + this.getId() + ") may not have a DefaultValue string with passThru enabled.");
            throw new AttributeResolutionException("MappedAttributeDefinition (" + this.getId() + ") may not have a DefaultValue string with passThru enabled.");
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String newDefaultValue) {
        this.defaultValue = newDefaultValue;
    }

    public boolean isPassThru() {
        return this.passThru;
    }

    public void setPassThru(boolean newPassThru) {
        this.passThru = newPassThru;
    }

    public Collection<ValueMap> getValueMaps() {
        return this.valueMaps;
    }
}

