/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.common.attribute.encoding.provider;

import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.AttributeEncodingException;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.SAML1AttributeEncoder;
import edu.internet2.middleware.shibboleth.common.attribute.encoding.provider.AbstractScopedAttributeEncoder;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml1.core.Attribute;
import org.opensaml.saml1.core.AttributeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML1ScopedStringAttributeEncoder
extends AbstractScopedAttributeEncoder<Attribute>
implements SAML1AttributeEncoder {
    private final Logger log = LoggerFactory.getLogger(SAML1ScopedStringAttributeEncoder.class);
    private final SAMLObjectBuilder<Attribute> attributeBuilder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
    private String namespace;

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String newNamespace) {
        this.namespace = newNamespace;
    }

    @Override
    public Attribute encode(BaseAttribute attribute) throws AttributeEncodingException {
        Attribute samlAttribute = (Attribute)this.attributeBuilder.buildObject();
        samlAttribute.setAttributeName(this.getAttributeName());
        samlAttribute.setAttributeNamespace(this.getNamespace());
        samlAttribute.getAttributeValues().addAll(this.encodeAttributeValues(AttributeValue.DEFAULT_ELEMENT_NAME, attribute));
        List attributeValues = samlAttribute.getAttributeValues();
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("Unable to encode {} attribute.  It does not contain any values", (Object)attribute.getId());
            return null;
        }
        return samlAttribute;
    }
}

