/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.util;

import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.handler.CopySearchResultHandler;
import edu.vt.middleware.ldap.handler.ExtendedSearchResultHandler;
import edu.vt.middleware.ldap.handler.SearchCriteria;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchResult;

public class RangeSearchResultHandler
extends CopySearchResultHandler
implements ExtendedSearchResultHandler {
    public static final String END_OF_RANGE = "*";
    public static final String RANGE_FORMAT = "%1$s;Range=%2$s-%3$s";
    public static final String RANGE_PATTERN_STRING = "^(.*?);Range=([\\d\\*]+)-([\\d\\*]+)";
    public static final Pattern RANGE_PATTERN = Pattern.compile("^(.*?);Range=([\\d\\*]+)-([\\d\\*]+)", 2);
    private Ldap ldap;

    public RangeSearchResultHandler() {
    }

    public RangeSearchResultHandler(Ldap ldap) {
        this.ldap = ldap;
    }

    public Ldap getSearchResultLdap() {
        return this.ldap;
    }

    public void setSearchResultLdap(Ldap l) {
        this.ldap = l;
    }

    protected Attributes processAttributes(SearchCriteria sc, SearchResult sr) throws NamingException {
        Attributes attrs = sr.getAttributes();
        NamingEnumeration<? extends Attribute> attrsEnumeration = attrs.getAll();
        while (attrsEnumeration.hasMore()) {
            Matcher matcher;
            Attribute attr = attrsEnumeration.next();
            if (attr == null || !(matcher = RANGE_PATTERN.matcher(attr.getID())).find()) continue;
            String msg = "attribute '" + attr.getID() + "' result '" + sr.getName() + "'";
            String attrTypeName = matcher.group(1);
            this.logger.debug((Object)("Found Range option " + msg));
            if (attrTypeName == null || attrTypeName.isEmpty()) {
                this.logger.error((Object)("Unable to determine the attribute type name for " + msg));
                throw new RuntimeException("Unable to determine the attribute type name for " + msg);
            }
            Attribute newAttr = attrs.get(attrTypeName);
            if (newAttr == null) {
                newAttr = new BasicAttribute(attrTypeName, attr.isOrdered());
                attrs.put(newAttr);
            }
            NamingEnumeration<?> attrValues = attr.getAll();
            while (attrValues.hasMore()) {
                newAttr.add(attrValues.next());
            }
            sr.getAttributes().remove(attr.getID());
            if (attr.getID().endsWith(END_OF_RANGE)) continue;
            String initialRange = matcher.group(2);
            if (initialRange == null || initialRange.isEmpty()) {
                this.logger.error((Object)("Unable to determine initial range for " + msg));
                throw new RuntimeException("Unable to determine initial range for " + msg);
            }
            String terminalRange = matcher.group(3);
            if (terminalRange == null || terminalRange.isEmpty()) {
                this.logger.error((Object)("Unable to determine terminal range for " + msg));
                throw new RuntimeException("Unable to determine terminal range for " + msg);
            }
            int start = 0;
            int end = 0;
            try {
                start = Integer.parseInt(initialRange);
                end = Integer.parseInt(terminalRange);
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)("Unable to parse range for " + msg));
                throw new RuntimeException("Unable to parse range for " + msg);
            }
            int diff = end - start;
            String nextAttrID = String.format(RANGE_FORMAT, attrTypeName, end + 1, end + diff + 1);
            this.logger.debug((Object)("Searching for '" + nextAttrID + "' to increment " + msg));
            Attributes nextAttrs = this.ldap.getAttributes(sr.getName(), new String[]{nextAttrID});
            NamingEnumeration<? extends Attribute> nextAttrsEnum = nextAttrs.getAll();
            while (nextAttrsEnum.hasMore()) {
                Attribute nextAttr = nextAttrsEnum.next();
                if (nextAttr == null) {
                    this.logger.error((Object)("Null attribute returned for '" + nextAttrID + "' when incrementing " + msg));
                    throw new RuntimeException("Null attribute returned for '" + nextAttrID + "' when incrementing " + msg);
                }
                sr.getAttributes().put(nextAttr);
            }
            attrs = this.processAttributes(sc, sr);
        }
        return attrs;
    }
}

