/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.util;

import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.ldappc.spml.PSP;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferencesDefinition;
import edu.internet2.middleware.ldappc.spml.request.LdapFilterQueryClause;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.subject.Subject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.opensaml.util.resource.FilesystemResource;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OCEtoMarshallableAdapter;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.AddRequest;
import org.openspml.v2.msg.spml.AddResponse;
import org.openspml.v2.msg.spml.CapabilityData;
import org.openspml.v2.msg.spml.DeleteRequest;
import org.openspml.v2.msg.spml.LookupRequest;
import org.openspml.v2.msg.spml.LookupResponse;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.ModifyRequest;
import org.openspml.v2.msg.spml.ModifyResponse;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.QueryClause;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.SchemaEntityRef;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spmlref.Reference;
import org.openspml.v2.msg.spmlsearch.Query;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.msg.spmlsearch.SearchRequest;
import org.openspml.v2.msg.spmlsearch.SearchResponse;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.util.Spml2Exception;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;

public class PSPUtil {
    public static final String TIMESTAMP_FORMAT = "yyyy/MM/dd-HH:mm:ss.SSS";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss.SSS");

    public static GenericApplicationContext createSpringContext(List<Resource> resources) throws ResourceException {
        GenericApplicationContext gContext = new GenericApplicationContext();
        SpringConfigurationUtils.populateRegistry((BeanDefinitionRegistry)gContext, resources);
        gContext.refresh();
        gContext.registerShutdownHook();
        return gContext;
    }

    public static GenericApplicationContext createSpringContext(String ... configs) throws ResourceException {
        return PSPUtil.createSpringContext(PSPUtil.getResources(null, configs));
    }

    public static CapabilityData fromReferences(Collection<Reference> references) throws Spml2Exception {
        if (!references.isEmpty()) {
            CapabilityData referenceCapabilityData = new CapabilityData(true, PSOReferencesDefinition.REFERENCE_URI);
            for (Reference reference : references) {
                OCEtoMarshallableAdapter oce = new OCEtoMarshallableAdapter((Marshallable)reference);
                referenceCapabilityData.addOpenContentElement((OpenContentElement)oce);
            }
            return referenceCapabilityData;
        }
        return null;
    }

    public static List<Resource> getResources(String path, String ... resourceNames) throws ResourceException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String resourceName : resourceNames) {
            File file = null;
            file = path == null ? GrouperUtil.fileFromResourceName((String)resourceName) : new File(path + System.getProperty("file.separator") + resourceName);
            if (file == null) {
                throw new IllegalArgumentException("Unable to find file '" + resourceName + "'.");
            }
            if (!file.isFile() || !file.canRead()) {
                throw new IllegalArgumentException("Unable to read file '" + resourceName + "'.");
            }
            resources.add((Resource)new FilesystemResource(file.getAbsolutePath()));
        }
        return resources;
    }

    public static int getScope(Scope scope) {
        if (scope.equals(Scope.ONELEVEL)) {
            return 0;
        }
        if (scope.equals(Scope.SUBTREE)) {
            return 2;
        }
        if (scope.equals(Scope.PSO)) {
            return 0;
        }
        throw new IllegalArgumentException("Unknow scope " + scope);
    }

    public static String getString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Subject) {
            return GrouperUtil.subjectToString((Subject)((Subject)object));
        }
        if (object instanceof PSOIdentifier) {
            return PSPUtil.toString((PSOIdentifier)object);
        }
        if (object instanceof Reference) {
            return PSPUtil.toString((Reference)object);
        }
        return object.toString();
    }

    public static CapabilityData setReferences(PSO pso, Collection<Reference> references) throws Spml2Exception {
        CapabilityData capabilityData = PSPUtil.fromReferences(references);
        if (capabilityData != null) {
            pso.addCapabilityData(capabilityData);
        }
        return capabilityData;
    }

    public static String toString(AddRequest addRequest) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)addRequest, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("psoID", (Object)PSPUtil.toString(addRequest.getPsoID()));
        toStringBuilder.append("targetID", (Object)addRequest.getTargetId());
        toStringBuilder.append("returnData", (Object)addRequest.getReturnData());
        toStringBuilder.appendSuper(PSPUtil.toString((Request)addRequest));
        return toStringBuilder.toString();
    }

    public static String toString(AddResponse addResponse) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)addResponse, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("pso", (Object)PSPUtil.toString(addResponse.getPso()));
        toStringBuilder.appendSuper(PSPUtil.toString((Response)addResponse));
        return toStringBuilder.toString();
    }

    public static String toString(DeleteRequest deleteRequest) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)deleteRequest, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("psoID", (Object)PSPUtil.toString(deleteRequest.getPsoID()));
        toStringBuilder.append("recursive", deleteRequest.isRecursive());
        toStringBuilder.appendSuper(PSPUtil.toString((Request)deleteRequest));
        return toStringBuilder.toString();
    }

    public static String toString(DSMLModification dsmlModification) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)dsmlModification, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("name", (Object)dsmlModification.getName());
        toStringBuilder.append("op", (Object)dsmlModification.getOperation());
        return toStringBuilder.toString();
    }

    public static String toString(LookupRequest lookupRequest) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)lookupRequest, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("psoID", (Object)PSPUtil.toString(lookupRequest.getPsoID()));
        toStringBuilder.append("returnData", (Object)lookupRequest.getReturnData());
        toStringBuilder.append("requestID", (Object)lookupRequest.getRequestID());
        return toStringBuilder.toString();
    }

    public static String toString(LookupResponse lookupResponse) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)lookupResponse, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("pso", (Object)PSPUtil.toString(lookupResponse.getPso()));
        toStringBuilder.appendSuper(PSPUtil.toString((Response)lookupResponse));
        return toStringBuilder.toString();
    }

    public static String toString(ModifyRequest modifyRequest) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)modifyRequest, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("psoID", (Object)PSPUtil.toString(modifyRequest.getPsoID()));
        for (Modification modification : modifyRequest.getModifications()) {
            for (Object object : modification.getOpenContentElements(DSMLModification.class)) {
                toStringBuilder.append("mod", (Object)PSPUtil.toString((DSMLModification)object));
            }
            Map<String, List<Reference>> references = PSP.getReferences(modification.getCapabilityData());
            for (String typeOfReference : references.keySet()) {
                toStringBuilder.append("typeOfReference", (Object)typeOfReference);
            }
        }
        toStringBuilder.append("returnData", (Object)modifyRequest.getReturnData());
        toStringBuilder.appendSuper(PSPUtil.toString((Request)modifyRequest));
        return toStringBuilder.toString();
    }

    public static String toString(ModifyResponse modifyResponse) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)modifyResponse, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("pso", (Object)PSPUtil.toString(modifyResponse.getPso()));
        toStringBuilder.appendSuper(PSPUtil.toString((Response)modifyResponse));
        return toStringBuilder.toString();
    }

    public static String toString(PSO pso) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)pso, ToStringStyle.SHORT_PREFIX_STYLE);
        if (pso != null) {
            toStringBuilder.append("psoID", (Object)PSPUtil.toString(pso.getPsoID()));
        }
        return toStringBuilder.toString();
    }

    public static String toString(PSOIdentifier psoIdentifier) {
        if (psoIdentifier == null) {
            return null;
        }
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)psoIdentifier, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("id", (Object)("'" + psoIdentifier.getID() + "'"));
        toStringBuilder.append("targetID", (Object)psoIdentifier.getTargetID());
        toStringBuilder.append("containerID", (Object)PSPUtil.getString(psoIdentifier.getContainerID()));
        return toStringBuilder.toString();
    }

    public static String toString(Query query) {
        if (query == null) {
            return null;
        }
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)query, ToStringStyle.SHORT_PREFIX_STYLE);
        for (QueryClause queryClause : query.getQueryClauses()) {
            if (!(queryClause instanceof LdapFilterQueryClause)) continue;
            toStringBuilder.append("filter", (Object)((LdapFilterQueryClause)queryClause).getFilter());
        }
        toStringBuilder.append("basePsoID", (Object)PSPUtil.toString(query.getBasePsoID()));
        toStringBuilder.append("scope", (Object)query.getScope());
        toStringBuilder.append("targetID", (Object)query.getTargetID());
        return toStringBuilder.toString();
    }

    public static String toString(Reference reference) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)reference, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("toPsoID", (Object)PSPUtil.toString(reference.getToPsoID()));
        toStringBuilder.append("type", (Object)reference.getTypeOfReference());
        return toStringBuilder.toString();
    }

    public static String toString(Request request) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)request, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("requestID", (Object)request.getRequestID());
        return toStringBuilder.toString();
    }

    public static String toString(Response response) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)response, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("status", (Object)response.getStatus());
        if (response.getStatus() != null && response.getStatus().equals(StatusCode.FAILURE)) {
            toStringBuilder.append("error", (Object)response.getError());
            toStringBuilder.append("errorMessages", (Object[])response.getErrorMessages());
        }
        toStringBuilder.append("requestID", (Object)response.getRequestID());
        return toStringBuilder.toString();
    }

    public static String toString(SearchRequest searchRequest) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)searchRequest, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("query", (Object)PSPUtil.toString(searchRequest.getQuery()));
        toStringBuilder.append("returnData", (Object)searchRequest.getReturnData());
        toStringBuilder.append("maxSelect", searchRequest.getMaxSelect());
        toStringBuilder.appendSuper(PSPUtil.toString((Request)searchRequest));
        return toStringBuilder.toString();
    }

    public static String toString(SearchResponse searchResponse) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)searchResponse, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("psos", searchResponse.getPSOs().length);
        toStringBuilder.appendSuper(PSPUtil.toString((Response)searchResponse));
        return toStringBuilder.toString();
    }

    public static String toString(SchemaEntityRef schemaEntityRef) {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)schemaEntityRef, ToStringStyle.SHORT_PREFIX_STYLE);
        if (schemaEntityRef != null) {
            toStringBuilder.append("targetID", (Object)schemaEntityRef.getTargetID());
            toStringBuilder.append("entityName", (Object)schemaEntityRef.getEntityName());
            toStringBuilder.append("isContainer", schemaEntityRef.isContainer());
        }
        return toStringBuilder.toString();
    }

    public static String uniqueRequestId() {
        return dateFormat.format(new Date()) + "_" + GrouperUtil.uniqueId();
    }
}

