/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.synchronize;

import edu.internet2.middleware.ldappc.util.PSPUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.XMLMarshaller;
import org.openspml.v2.msg.spml.CapabilityData;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.ModificationMode;
import org.openspml.v2.msg.spmlref.Reference;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ReflectiveDOMXMLUnmarshaller;
import org.openspml.v2.util.xml.ReflectiveXMLMarshaller;

public class AttributeModifier {
    static final String DEFAULT_NO_VALUE = null;
    static final boolean DEFAULT_SENSITIVITY = false;
    private String attributeName;
    private Values adds;
    private Values deletes;
    private Values retained;
    private String noValue;
    private boolean caseSensitive = false;
    private ReflectiveXMLMarshaller m = new ReflectiveXMLMarshaller();
    private ReflectiveDOMXMLUnmarshaller u = new ReflectiveDOMXMLUnmarshaller();

    public AttributeModifier(String attributeName) {
        this(attributeName, DEFAULT_NO_VALUE, false);
    }

    public AttributeModifier(String attributeName, String noValue) {
        this(attributeName, noValue, false);
    }

    public AttributeModifier(String attributeName, boolean caseSensitive) {
        this(attributeName, DEFAULT_NO_VALUE, caseSensitive);
    }

    public AttributeModifier(String attributeName, String noValue, boolean caseSensitive) {
        this.setAttributeName(attributeName);
        this.setNoValue(noValue);
        this.setCaseSensitive(caseSensitive);
        this.adds = new Values();
        this.deletes = new Values();
        this.retained = new Values();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getNoValue() {
        return this.noValue;
    }

    public void setNoValue(String noValue) {
        this.noValue = noValue;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void clear() {
        this.adds.clear();
        this.deletes.clear();
        this.retained.clear();
    }

    public void init() {
        this.clear();
    }

    public void init(Attribute attribute) throws NamingException {
        this.clear();
        if (attribute != null) {
            NamingEnumeration<?> enumeration = attribute.getAll();
            while (enumeration.hasMore()) {
                Object value = enumeration.next();
                if (!(value instanceof String)) {
                    throw new InvalidAttributeValueException(attribute.getID() + " has an invalid value of type [" + value.getClass().getName() + "].");
                }
                this.deletes.add((String)value);
            }
        }
    }

    public void init(Collection<String> collection) {
        this.clear();
        if (collection != null) {
            this.deletes.addAll(collection);
        }
    }

    public void initDSML(DSMLValue ... dsmlValues) {
        this.clear();
        for (DSMLValue dsmlValue : dsmlValues) {
            this.deletes.add(dsmlValue.getValue());
        }
    }

    public void initReference(Collection<Reference> references) throws Spml2Exception {
        this.clear();
        for (Reference reference : references) {
            this.deletes.add(reference.toXML((XMLMarshaller)this.m));
        }
    }

    public void store(String attrValue) {
        if (this.deletes.remove(attrValue)) {
            this.retained.add(attrValue);
        } else if (!this.retained.contains(attrValue) && !this.adds.contains(attrValue)) {
            this.adds.add(attrValue);
        }
    }

    public void store(DSMLValue[] dsmlValues) {
        for (DSMLValue dsmlValue : dsmlValues) {
            this.store(dsmlValue.getValue());
        }
    }

    public void store(Collection<Reference> references) throws Spml2Exception {
        for (Reference reference : references) {
            this.store(reference.toXML((XMLMarshaller)this.m));
        }
    }

    public Attribute getAdditions() {
        return this.makeAttribute(this.adds);
    }

    public ModificationItem[] getModifications() throws NamingException {
        ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
        if (this.adds.size() > 0) {
            mods.add(new ModificationItem(1, this.makeAttribute(this.adds)));
        }
        if (this.deletes.size() > 0) {
            mods.add(new ModificationItem(3, this.makeAttribute(this.deletes)));
        }
        mods.trimToSize();
        return mods.toArray(new ModificationItem[0]);
    }

    public List<Modification> getDSMLModification() throws DSMLProfileException {
        Modification modification;
        DSMLModification dsmlMod;
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        if (this.adds.size() == 0 && this.deletes.size() == 0) {
            return modifications;
        }
        if (this.adds.size() > 0) {
            dsmlMod = new DSMLModification(this.attributeName, this.makeDSMLValues(this.adds), ModificationMode.ADD);
            modification = new Modification();
            modification.addOpenContentElement((OpenContentElement)dsmlMod);
            modification.setModificationMode(ModificationMode.ADD);
            modifications.add(modification);
        }
        if (this.deletes.size() > 0) {
            dsmlMod = new DSMLModification(this.attributeName, this.makeDSMLValues(this.deletes), ModificationMode.DELETE);
            modification = new Modification();
            modification.addOpenContentElement((OpenContentElement)dsmlMod);
            modification.setModificationMode(ModificationMode.DELETE);
            modifications.add(modification);
        }
        return modifications;
    }

    public List<Modification> getReferenceModification() throws Spml2Exception {
        Modification modification;
        CapabilityData capabilityData;
        Reference reference;
        ArrayList<Reference> references;
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        if (this.adds.size() == 0 && this.deletes.size() == 0) {
            return modifications;
        }
        if (this.adds.size() > 0) {
            references = new ArrayList<Reference>();
            for (String add : this.adds) {
                reference = (Reference)this.u.unmarshall(add);
                references.add(reference);
            }
            capabilityData = PSPUtil.fromReferences(references);
            modification = new Modification();
            modification.addCapabilityData(capabilityData);
            modification.setModificationMode(ModificationMode.ADD);
            modifications.add(modification);
        }
        if (this.deletes.size() > 0) {
            references = new ArrayList();
            for (String delete : this.deletes) {
                reference = (Reference)this.u.unmarshall(delete);
                references.add(reference);
            }
            capabilityData = PSPUtil.fromReferences(references);
            modification = new Modification();
            modification.addCapabilityData(capabilityData);
            modification.setModificationMode(ModificationMode.DELETE);
            modifications.add(modification);
        }
        return modifications;
    }

    public Values getAdds() {
        return this.adds;
    }

    public Values getDeletes() {
        return this.deletes;
    }

    private Attribute makeAttribute(Values attributeSet) {
        BasicAttribute attribute = new BasicAttribute(this.attributeName);
        for (String value : attributeSet) {
            attribute.add(value);
        }
        return attribute;
    }

    private DSMLValue[] makeDSMLValues(Values attributeSet) {
        ArrayList<DSMLValue> dsmlValues = new ArrayList<DSMLValue>(attributeSet.size());
        for (String value : attributeSet) {
            dsmlValues.add(new DSMLValue(value));
        }
        return dsmlValues.toArray(new DSMLValue[0]);
    }

    public void retainAll() {
        this.retained.addAll(this.deletes);
        this.deletes.clear();
    }

    protected String makeComparisonString(String value) {
        return this.caseSensitive ? value : value.toLowerCase();
    }

    public Values getRetainedValues() {
        return this.retained;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.attributeName);
        buffer.append(" adds " + this.adds.toString());
        buffer.append(" deletes " + this.deletes.toString());
        buffer.append(" retained " + this.retained.toString());
        return buffer.toString();
    }

    public class Values
    implements Iterable<String> {
        private static final long serialVersionUID = 1L;
        private Map<String, String> map = new HashMap<String, String>();

        public boolean add(String value) {
            boolean addedValue = false;
            String comparisonString = AttributeModifier.this.makeComparisonString(value);
            if (!this.map.containsKey(comparisonString)) {
                this.map.put(comparisonString, value);
                addedValue = true;
            }
            return addedValue;
        }

        public boolean addAll(Iterable<String> iterable) {
            boolean hasChanged = false;
            for (String value : iterable) {
                if (this.contains(value)) continue;
                this.add(value);
                hasChanged = true;
            }
            return hasChanged;
        }

        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return this.map.values().iterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof String)) {
                return false;
            }
            return this.map.containsKey(AttributeModifier.this.makeComparisonString((String)object));
        }

        public boolean remove(String value) {
            return this.map.remove(AttributeModifier.this.makeComparisonString(value)) != null;
        }

        public int size() {
            return this.map.size();
        }

        public String toString() {
            return this.map.toString();
        }
    }
}

