/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.request;

import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.MarshallableElement;
import org.openspml.v2.msg.PrefixAndNamespaceTuple;
import org.openspml.v2.util.Spml2Exception;
import org.openspml.v2.util.xml.ObjectFactory;
import org.openspml.v2.util.xml.UnknownSpml2TypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdappcMarshallableCreator
implements ObjectFactory.MarshallableCreator {
    private static final Logger LOG = LoggerFactory.getLogger(LdappcMarshallableCreator.class);
    public static final String URI = "http://grouper.internet2.edu/ldappc";
    public static final String PREFIX = "ldappc";
    public static final String pkg = LdappcMarshallableCreator.class.getPackage().getName();

    static PrefixAndNamespaceTuple[] staticGetNamespacesInfo() {
        return new PrefixAndNamespaceTuple[]{new PrefixAndNamespaceTuple(PREFIX, URI)};
    }

    public Marshallable createMarshallable(String nameAndPrefix, String uri) throws Spml2Exception {
        if (URI.equals(uri)) {
            Class cls = this.findClass(nameAndPrefix, uri);
            MarshallableElement e = ObjectFactory.getInstance().createMarshallableElement(cls);
            if (!(e instanceof Marshallable)) {
                throw new UnknownSpml2TypeException("Unknown object with nameAndPrefix '" + nameAndPrefix + "' and uri '" + uri + "'");
            }
            return (Marshallable)e;
        }
        return null;
    }

    private Class findClass(String nameAndPrefix, String uri) throws Spml2Exception {
        if (URI.equals(uri)) {
            String name = nameAndPrefix;
            int idx = name.indexOf(":");
            if (idx != -1) {
                name = name.substring(idx + 1);
            }
            String classname = pkg + "." + this.firstCharToUpper(name);
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                LOG.error("Class Not Found for nameAndPrefix '" + nameAndPrefix + "' and uri '" + uri + "'", (Throwable)e);
                throw new Spml2Exception((Throwable)e);
            }
        }
        return null;
    }

    private String firstCharToUpper(String name) {
        String fChar = name.substring(0, 1);
        fChar = fChar.toUpperCase();
        return fChar + name.substring(1);
    }
}

