/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.request;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.request.ProvisioningResponse;
import edu.internet2.middleware.ldappc.spml.request.SynchronizedResponse;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OCEtoMarshallableAdapter;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.AddRequest;
import org.openspml.v2.msg.spml.DeleteRequest;
import org.openspml.v2.msg.spml.ModifyRequest;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.util.Spml2Exception;

public class DiffResponse
extends ProvisioningResponse {
    public void addRequest(AddRequest addRequest) {
        try {
            this.addOpenContentElement((OpenContentElement)new OCEtoMarshallableAdapter((Marshallable)addRequest));
        }
        catch (Spml2Exception e) {
            throw new LdappcException("An SPML2 error occurred.", e);
        }
    }

    public void addRequest(DeleteRequest deleteRequest) {
        try {
            this.addOpenContentElement((OpenContentElement)new OCEtoMarshallableAdapter((Marshallable)deleteRequest));
        }
        catch (Spml2Exception e) {
            throw new LdappcException("An SPML2 error occurred.", e);
        }
    }

    public void addRequest(ModifyRequest modifyRequest) {
        try {
            this.addOpenContentElement((OpenContentElement)new OCEtoMarshallableAdapter((Marshallable)modifyRequest));
        }
        catch (Spml2Exception e) {
            throw new LdappcException("An SPML2 error occurred.", e);
        }
    }

    public void addResponse(SynchronizedResponse synchronizedResponse) {
        try {
            this.addOpenContentElement((OpenContentElement)new OCEtoMarshallableAdapter((Marshallable)synchronizedResponse));
        }
        catch (Spml2Exception e) {
            throw new LdappcException("An SPML2 error occurred.", e);
        }
    }

    public List<AddRequest> getAddRequests() {
        ArrayList<AddRequest> requests = new ArrayList<AddRequest>();
        for (Object oce : this.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
            Object o = ((OCEtoMarshallableAdapter)oce).getAdaptedObject();
            if (!(o instanceof AddRequest)) continue;
            requests.add((AddRequest)o);
        }
        return requests;
    }

    public List<DeleteRequest> getDeleteRequests() {
        ArrayList<DeleteRequest> requests = new ArrayList<DeleteRequest>();
        for (Object oce : this.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
            Object o = ((OCEtoMarshallableAdapter)oce).getAdaptedObject();
            if (!(o instanceof DeleteRequest)) continue;
            requests.add((DeleteRequest)o);
        }
        return requests;
    }

    public List<ModifyRequest> getModifyRequests() {
        ArrayList<ModifyRequest> requests = new ArrayList<ModifyRequest>();
        for (Object oce : this.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
            Object o = ((OCEtoMarshallableAdapter)oce).getAdaptedObject();
            if (!(o instanceof ModifyRequest)) continue;
            requests.add((ModifyRequest)o);
        }
        return requests;
    }

    public List<Request> getRequests() {
        ArrayList<Request> requests = new ArrayList<Request>();
        requests.addAll(this.getAddRequests());
        requests.addAll(this.getDeleteRequests());
        requests.addAll(this.getModifyRequests());
        return requests;
    }

    public List<SynchronizedResponse> getSynchronizedResponses() {
        ArrayList<SynchronizedResponse> responses = new ArrayList<SynchronizedResponse>();
        for (Object oce : this.getOpenContentElements(OCEtoMarshallableAdapter.class)) {
            Object o = ((OCEtoMarshallableAdapter)oce).getAdaptedObject();
            if (!(o instanceof SynchronizedResponse)) continue;
            responses.add((SynchronizedResponse)((Object)o));
        }
        return responses;
    }

    public List<PSOIdentifier> getPsoIds() {
        ArrayList<PSOIdentifier> psoIds = new ArrayList<PSOIdentifier>();
        for (AddRequest addRequest : this.getAddRequests()) {
            psoIds.add(addRequest.getPsoID());
        }
        for (ModifyRequest modifyRequest : this.getModifyRequests()) {
            psoIds.add(modifyRequest.getPsoID());
        }
        for (SynchronizedResponse synchronizedResponse : this.getSynchronizedResponses()) {
            psoIds.add(synchronizedResponse.getPsoID());
        }
        return psoIds;
    }

    public Map<PSOIdentifier, Request> getRequestMap() {
        HashMap<PSOIdentifier, Request> map = new HashMap<PSOIdentifier, Request>();
        for (AddRequest addRequest : this.getAddRequests()) {
            map.put(addRequest.getPsoID(), (Request)addRequest);
        }
        for (DeleteRequest deleteRequest : this.getDeleteRequests()) {
            map.put(deleteRequest.getPsoID(), (Request)deleteRequest);
        }
        for (ModifyRequest modifyRequest : this.getModifyRequests()) {
            map.put(modifyRequest.getPsoID(), (Request)modifyRequest);
        }
        return map;
    }

    public Map<PSOIdentifier, Response> getResponseMap() {
        HashMap<PSOIdentifier, Response> map = new HashMap<PSOIdentifier, Response>();
        for (SynchronizedResponse response : this.getSynchronizedResponses()) {
            map.put(response.getPsoID(), response);
        }
        return map;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 29 * result + (this.getId() != null ? this.getId().hashCode() : 0);
        result = 29 * result + (this.getError() != null ? this.getError().hashCode() : 0);
        result = 29 * result + (this.getErrorMessages() != null ? ((Object)Arrays.asList(this.getErrorMessages())).hashCode() : 0);
        result = 29 * result + (this.getRequestID() != null ? this.getRequestID().hashCode() : 0);
        result = 29 * result + (this.getStatus() != null ? this.getStatus().hashCode() : 0);
        result = 29 * result + (this.getOpenContentAttrs() != null ? ((Object)Arrays.asList(this.getOpenContentAttrs())).hashCode() : 0);
        for (Request request : this.getRequests()) {
            result = 29 * result + request.hashCode();
        }
        for (SynchronizedResponse response : this.getSynchronizedResponses()) {
            result = 29 * result + response.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        Response other;
        Request other2;
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffResponse)) {
            return false;
        }
        DiffResponse that = (DiffResponse)((Object)o);
        if (this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null) {
            return false;
        }
        if (this.getError() != null ? !this.getError().equals(that.getError()) : that.getError() != null) {
            return false;
        }
        if (this.getErrorMessages() != null ? !((Object)Arrays.asList(this.getErrorMessages())).equals(Arrays.asList(that.getErrorMessages())) : that.getErrorMessages() != null) {
            return false;
        }
        if (this.getRequestID() != null ? !this.getRequestID().equals(that.getRequestID()) : that.getRequestID() != null) {
            return false;
        }
        if (this.getStatus() != null ? !this.getStatus().equals(that.getStatus()) : that.getStatus() != null) {
            return false;
        }
        if (this.getOpenContentAttrs() != null ? !((Object)Arrays.asList(this.getOpenContentAttrs())).equals(Arrays.asList(that.getOpenContentAttrs())) : that.getOpenContentAttrs() != null) {
            return false;
        }
        Map<PSOIdentifier, Request> thisRequestMap = this.getRequestMap();
        Map<PSOIdentifier, Request> thatRequestMap = that.getRequestMap();
        for (PSOIdentifier psoID : thisRequestMap.keySet()) {
            other2 = thatRequestMap.get(psoID);
            if (other2 == null) {
                return false;
            }
            if (thisRequestMap.get(psoID).equals((Object)other2)) continue;
            return false;
        }
        for (PSOIdentifier psoID : thatRequestMap.keySet()) {
            other2 = thisRequestMap.get(psoID);
            if (other2 == null) {
                return false;
            }
            if (thatRequestMap.get(psoID).equals((Object)other2)) continue;
            return false;
        }
        Map<PSOIdentifier, Response> thisResponseMap = this.getResponseMap();
        Map<PSOIdentifier, Response> thatResponseMap = that.getResponseMap();
        for (PSOIdentifier psoID : thisResponseMap.keySet()) {
            other = thatResponseMap.get(psoID);
            if (other == null) {
                return false;
            }
            if (thisResponseMap.get(psoID).equals((Object)other)) continue;
            return false;
        }
        for (PSOIdentifier psoID : thatResponseMap.keySet()) {
            other = thisResponseMap.get(psoID);
            if (other == null) {
                return false;
            }
            if (thatResponseMap.get(psoID).equals((Object)other)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.appendSuper(super.toString());
        for (AddRequest addRequest : this.getAddRequests()) {
            toStringBuilder.append("add", (Object)PSPUtil.toString(addRequest));
        }
        for (ModifyRequest modifyRequest : this.getModifyRequests()) {
            toStringBuilder.append("modify", (Object)PSPUtil.toString(modifyRequest));
        }
        for (DeleteRequest deleteRequest : this.getDeleteRequests()) {
            toStringBuilder.append("delete", (Object)PSPUtil.toString(deleteRequest));
        }
        for (SynchronizedResponse synchronizedResponse : this.getSynchronizedResponses()) {
            toStringBuilder.append("synchronized", (Object)synchronizedResponse.toString());
        }
        return toStringBuilder.toString();
    }
}

