/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.provider;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSP;
import edu.internet2.middleware.ldappc.spml.definitions.PSODefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferencesDefinition;
import edu.internet2.middleware.ldappc.spml.provider.BaseSpmlTargetProvider;
import edu.internet2.middleware.ldappc.util.LdapUtil;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.service.ServiceException;
import edu.vt.middleware.ldap.BaseLdap;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.bean.LdapAttribute;
import edu.vt.middleware.ldap.bean.LdapAttributes;
import edu.vt.middleware.ldap.bean.LdapEntry;
import edu.vt.middleware.ldap.pool.LdapPool;
import edu.vt.middleware.ldap.pool.LdapPoolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.AddRequest;
import org.openspml.v2.msg.spml.AddResponse;
import org.openspml.v2.msg.spml.DeleteRequest;
import org.openspml.v2.msg.spml.DeleteResponse;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.LookupRequest;
import org.openspml.v2.msg.spml.LookupResponse;
import org.openspml.v2.msg.spml.Modification;
import org.openspml.v2.msg.spml.ModificationMode;
import org.openspml.v2.msg.spml.ModifyRequest;
import org.openspml.v2.msg.spml.ModifyResponse;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spmlref.Reference;
import org.openspml.v2.msg.spmlsearch.SearchRequest;
import org.openspml.v2.msg.spmlsearch.SearchResponse;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLModification;
import org.openspml.v2.profiles.dsml.DSMLProfileException;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.openspml.v2.util.Spml2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class LdapTargetProvider
extends BaseSpmlTargetProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LdapTargetProvider.class);
    private String ldapPoolId;
    private LdapPool<Ldap> ldapPool;
    private boolean logLdif;
    private boolean logSpml;

    public String getLdapPoolId() {
        return this.ldapPoolId;
    }

    public void setLdapPoolId(String ldapPoolId) {
        this.ldapPoolId = ldapPoolId;
    }

    public LdapPool<Ldap> getLdapPool() {
        return this.ldapPool;
    }

    public boolean isLogLdif() {
        return this.logLdif;
    }

    public void setLogLdif(boolean logLdif) {
        this.logLdif = logLdif;
    }

    public boolean isLogSpml() {
        return this.logSpml;
    }

    public void setLogSpml(boolean logSpml) {
        this.logSpml = logSpml;
    }

    protected void onNewContextCreated(ApplicationContext newServiceContext) throws ServiceException {
        LdapPool<Ldap> oldPool = this.ldapPool;
        try {
            LOG.debug("Loading ldap pool '{}'", (Object)this.getLdapPoolId());
            this.ldapPool = (LdapPool)newServiceContext.getBean(this.getLdapPoolId());
        }
        catch (Exception e) {
            this.ldapPool = oldPool;
            LOG.error(this.getId() + " configuration is not valid, retaining old configuration", (Throwable)e);
            throw new ServiceException(this.getId() + " configuration is not valid, retaining old configuration", e);
        }
    }

    /*
     * Exception decompiling
     */
    public AddResponse execute(AddRequest addRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteResponse execute(DeleteRequest deleteRequest) {
        String msg = PSPUtil.toString(deleteRequest);
        LOG.info("{}", (Object)msg);
        if (this.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteRequest));
        }
        DeleteResponse deleteResponse = new DeleteResponse();
        deleteResponse.setRequestID(this.getOrGenerateRequestID((Request)deleteRequest));
        if (!this.isValidTargetId(deleteRequest.getPsoID(), (Response)deleteResponse)) {
            LOG.error(PSPUtil.toString((Response)deleteResponse));
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
            }
            return deleteResponse;
        }
        String dn = deleteRequest.getPsoID().getID();
        Ldap ldap = null;
        try {
            ldap = (Ldap)this.ldapPool.checkOut();
            LOG.info("{}", (Object)msg);
            String escapedDn = LdapUtil.escapeForwardSlash(dn);
            LOG.debug("{} escaped dn '{}'", (Object)msg, (Object)escapedDn);
            ldap.delete(escapedDn);
        }
        catch (LdapPoolException e) {
            this.fail((Response)deleteResponse, ErrorCode.CUSTOM_ERROR, (Exception)((Object)e));
            LOG.error(PSPUtil.toString((Response)deleteResponse), (Throwable)e);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
            }
            DeleteResponse deleteResponse2 = deleteResponse;
            return deleteResponse2;
        }
        catch (NameNotFoundException e) {
            this.fail((Response)deleteResponse, ErrorCode.NO_SUCH_IDENTIFIER, e);
            LOG.error(PSPUtil.toString((Response)deleteResponse), (Throwable)e);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
            }
            DeleteResponse deleteResponse3 = deleteResponse;
            return deleteResponse3;
        }
        catch (NamingException e) {
            this.fail((Response)deleteResponse, ErrorCode.CUSTOM_ERROR, e);
            LOG.error(PSPUtil.toString((Response)deleteResponse), (Throwable)e);
            if (this.isLogSpml()) {
                LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
            }
            DeleteResponse deleteResponse4 = deleteResponse;
            return deleteResponse4;
        }
        finally {
            this.ldapPool.checkIn((BaseLdap)ldap);
        }
        deleteResponse.setStatus(StatusCode.SUCCESS);
        if (this.isLogSpml()) {
            LOG.info("\n{}", (Object)this.toXML((Marshallable)deleteResponse));
        }
        return deleteResponse;
    }

    /*
     * Exception decompiling
     */
    public LookupResponse execute(LookupRequest lookupRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 27[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ModifyResponse execute(ModifyRequest modifyRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public SearchResponse execute(SearchRequest searchRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected PSO getPSO(LdapEntry entry, ReturnData returnData) throws Spml2Exception {
        String msg = "get pso for '" + entry.getDn() + "' target '" + this.getTargetDefinition().getId() + "'";
        PSO pso = new PSO();
        PSODefinition psoDefinition = this.getPSODefinition(entry);
        LOG.debug("{} schema entity '{}'", (Object)msg, (Object)psoDefinition.getId());
        pso.addOpenContentAttr("entityName", psoDefinition.getId());
        PSOIdentifier psoID = new PSOIdentifier();
        psoID.setTargetID(this.getTargetDefinition().getId());
        try {
            psoID.setID(LdapUtil.canonicalizeDn(entry.getDn()));
        }
        catch (InvalidNameException e) {
            LOG.error(msg + " Unable to canonicalize entry dn.", (Throwable)e);
            throw new Spml2Exception((Throwable)e);
        }
        pso.setPsoID(psoID);
        LdapAttributes ldapAttributes = entry.getLdapAttributes();
        if (returnData.equals(ReturnData.DATA) || returnData.equals(ReturnData.EVERYTHING)) {
            TreeMap<String, String> attributeNameMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (String attributeName : psoDefinition.getAttributeNames()) {
                attributeNameMap.put(attributeName, attributeName);
            }
            TreeMap<String, String> referenceNameMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            if (returnData.equals(ReturnData.EVERYTHING)) {
                for (String referenceName : psoDefinition.getReferenceNames()) {
                    referenceNameMap.put(referenceName, referenceName);
                }
            }
            Extensible data = new Extensible();
            ArrayList<Reference> references = new ArrayList<Reference>();
            for (LdapAttribute ldapAttribute : ldapAttributes.getAttributes()) {
                if (attributeNameMap.containsKey(ldapAttribute.getName())) {
                    data.addOpenContentElement((OpenContentElement)this.getDsmlAttr((String)attributeNameMap.get(ldapAttribute.getName()), ldapAttribute.getStringValues()));
                } else if (returnData.equals(ReturnData.EVERYTHING) && referenceNameMap.containsKey(ldapAttribute.getName())) {
                    references.addAll(this.getReferences((String)referenceNameMap.get(ldapAttribute.getName()), ldapAttribute.getStringValues()));
                } else {
                    LOG.trace("{} ignoring attribute '{}'", (Object)msg, (Object)ldapAttribute.getName());
                }
                if (data.getOpenContentElements().length > 0) {
                    pso.setData(data);
                }
                if (!returnData.equals(ReturnData.EVERYTHING)) continue;
                PSPUtil.setReferences(pso, references);
            }
        }
        return pso;
    }

    protected PSODefinition getPSODefinition(LdapEntry entry) throws LdappcException {
        Attributes attributes = entry.getLdapAttributes().toAttributes();
        PSODefinition definition = null;
        for (PSODefinition psoDefinition : this.getTargetDefinition().getPsoDefinitions()) {
            String idAttrName = psoDefinition.getPsoIdentifierDefinition().getIdentifyingAttribute().getName();
            String idAttrValue = psoDefinition.getPsoIdentifierDefinition().getIdentifyingAttribute().getValue();
            Attribute attribute = attributes.get(idAttrName);
            if (attribute == null || !attribute.contains(idAttrValue)) continue;
            if (definition != null) {
                LOG.error("More than one schema entity found for " + entry.getDn());
                throw new LdappcException("More than one schema entity found for " + entry.getDn());
            }
            definition = psoDefinition;
        }
        if (definition == null) {
            LOG.error("Unable to determine schema entity for " + entry.getDn());
            throw new LdappcException("Unable to determine schema entity for " + entry.getDn());
        }
        return definition;
    }

    protected DSMLAttr getDsmlAttr(String name, Collection<String> values) throws DSMLProfileException {
        DSMLValue[] dsmlValues = null;
        DSMLAttr dsmlAttr = new DSMLAttr(name, dsmlValues);
        for (String value : values) {
            dsmlAttr.addValue(new DSMLValue(value));
        }
        return dsmlAttr;
    }

    protected List<Reference> getReferences(String name, Collection<String> values) throws Spml2Exception {
        try {
            ArrayList<Reference> references = new ArrayList<Reference>();
            for (String value : values) {
                Reference reference = new Reference();
                PSOIdentifier toPSOId = new PSOIdentifier();
                toPSOId.setID(LdapUtil.canonicalizeDn(value));
                toPSOId.setTargetID(this.getTargetDefinition().getId());
                reference.setToPsoID(toPSOId);
                reference.setTypeOfReference(name);
                references.add(reference);
            }
            return references;
        }
        catch (InvalidNameException e) {
            LOG.error("Unable to canonicalize name", (Throwable)e);
            throw new Spml2Exception((Throwable)e);
        }
    }

    protected List<ModificationItem> getDsmlMods(Modification modification) {
        ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
        for (Object object : modification.getOpenContentElements(DSMLModification.class)) {
            DSMLValue[] dsmlValues;
            DSMLModification dsmlModification = (DSMLModification)object;
            BasicAttribute attribute = new BasicAttribute(dsmlModification.getName());
            for (DSMLValue dsmlValue : dsmlValues = dsmlModification.getValues()) {
                attribute.add(dsmlValue.getValue());
            }
            int op = -1;
            if (dsmlModification.getOperation().equals(ModificationMode.ADD)) {
                op = 1;
            } else if (dsmlModification.getOperation().equals(ModificationMode.DELETE)) {
                op = 3;
            } else if (dsmlModification.getOperation().equals(ModificationMode.REPLACE)) {
                op = 2;
            } else {
                throw new LdappcException("Unknown dsml modification operation : " + dsmlModification.getOperation());
            }
            mods.add(new ModificationItem(op, attribute));
        }
        return mods;
    }

    protected List<ModificationItem> getReferenceMods(Modification modification) {
        ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
        Map<String, List<Reference>> references = PSP.getReferences(modification.getCapabilityData());
        if (references.isEmpty()) {
            return mods;
        }
        for (String typeOfReference : references.keySet()) {
            ArrayList<String> ids = new ArrayList<String>();
            for (Reference reference : references.get(typeOfReference)) {
                if (!reference.getToPsoID().getTargetID().equals(this.getTargetDefinition().getId())) continue;
                String id = reference.getToPsoID().getID();
                if (id == null) {
                    id = "";
                }
                ids.add(id);
            }
            BasicAttribute attribute = new BasicAttribute(typeOfReference);
            for (String id : ids) {
                attribute.add(id);
            }
            int op = -1;
            if (modification.getModificationMode().equals(ModificationMode.ADD)) {
                op = 1;
            } else if (modification.getModificationMode().equals(ModificationMode.DELETE)) {
                op = 3;
            } else if (modification.getModificationMode().equals(ModificationMode.REPLACE)) {
                op = 2;
            } else {
                throw new LdappcException("Unknown modification operation : " + modification.getModificationMode());
            }
            mods.add(new ModificationItem(op, attribute));
        }
        return mods;
    }

    protected void handleEmptyReferences(AddRequest addRequest) throws DSMLProfileException {
        if (!addRequest.getReturnData().equals(ReturnData.DATA)) {
            return;
        }
        LOG.trace("add request before:\n{}", (Object)this.toXML((Marshallable)addRequest));
        String entityName = addRequest.findOpenContentAttrValueByName("entityName");
        if (entityName == null) {
            LOG.debug("TODO");
            return;
        }
        PSODefinition psoDefinition = this.getTargetDefinition().getPSODefinition(entityName);
        if (psoDefinition == null) {
            LOG.debug("TODO");
            return;
        }
        Map<String, DSMLAttr> dsmlAttrs = PSP.getDSMLAttrMap(addRequest.getData());
        for (PSOReferencesDefinition refsDef : psoDefinition.getReferenceDefinitions()) {
            DSMLAttr member;
            String emptyValue = refsDef.getEmptyValue();
            if (emptyValue == null || (member = dsmlAttrs.get(refsDef.getName())) != null && member.getValues().length != 0) continue;
            LOG.debug("TODO");
            addRequest.getData().addOpenContentElement((OpenContentElement)new DSMLAttr(refsDef.getName(), refsDef.getEmptyValue()));
        }
        LOG.trace("add request after:\n{}", (Object)this.toXML((Marshallable)addRequest));
    }

    public boolean isValidTargetId(PSOIdentifier psoID, Response response) {
        if (!psoID.getTargetID().equals(this.getTargetDefinition().getId())) {
            this.fail(response, ErrorCode.INVALID_IDENTIFIER, new String[0]);
            return false;
        }
        return true;
    }
}

