/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.definitions;

import edu.internet2.middleware.ldappc.spml.definitions.PSOAttributeDefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSODefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferenceDefinition;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferencesDefinition;
import edu.internet2.middleware.ldappc.spml.provider.SpmlTargetProvider;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.OCEtoMarshallableAdapter;
import org.openspml.v2.msg.OpenContentElement;
import org.openspml.v2.msg.spml.CapabilitiesList;
import org.openspml.v2.msg.spml.Capability;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.Schema;
import org.openspml.v2.msg.spml.SchemaEntityRef;
import org.openspml.v2.msg.spml.Target;
import org.openspml.v2.msg.spmlref.ReferenceDefinition;
import org.openspml.v2.profiles.DSMLProfileRegistrar;
import org.openspml.v2.profiles.spmldsml.AttributeDefinition;
import org.openspml.v2.profiles.spmldsml.AttributeDefinitionReference;
import org.openspml.v2.profiles.spmldsml.AttributeDefinitionReferences;
import org.openspml.v2.profiles.spmldsml.DSMLSchema;
import org.openspml.v2.profiles.spmldsml.ObjectClassDefinition;
import org.openspml.v2.util.Spml2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(TargetDefinition.class);
    private String id;
    private SpmlTargetProvider provider;
    private List<PSODefinition> psoDefinitions;
    private Target target;
    private boolean bundleModifications;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SpmlTargetProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SpmlTargetProvider provider) {
        this.provider = provider;
    }

    public PSODefinition getPSODefinition(String id) {
        for (PSODefinition psoDefinition : this.psoDefinitions) {
            if (!psoDefinition.getId().equals(id)) continue;
            return psoDefinition;
        }
        return null;
    }

    public List<PSODefinition> getPsoDefinitions() {
        return this.psoDefinitions;
    }

    public void setPsoDefinitions(List<PSODefinition> psoDefinitions) {
        this.psoDefinitions = psoDefinitions;
    }

    public Set<String> getAttributeIds() {
        return null;
    }

    public Set<String> getNames(ReturnData returnData) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (PSODefinition psoDefinition : this.psoDefinitions) {
            names.add(psoDefinition.getPsoIdentifierDefinition().getIdentifyingAttribute().getName());
            if (returnData.equals(ReturnData.DATA) || returnData.equals(ReturnData.EVERYTHING)) {
                names.addAll(psoDefinition.getAttributeNames());
            }
            if (!returnData.equals(ReturnData.EVERYTHING)) continue;
            names.addAll(psoDefinition.getReferenceNames());
        }
        return names;
    }

    public Target getTarget() throws Spml2Exception {
        if (this.target != null) {
            return this.target;
        }
        this.target = new Target();
        this.target.setTargetID(this.getId());
        this.target.setProfile(new DSMLProfileRegistrar().getProfileURI());
        Schema schema = new Schema();
        DSMLSchema dsmlSchema = new DSMLSchema();
        CapabilitiesList cl = new CapabilitiesList();
        LinkedHashMap<String, SchemaEntityRef> schemaEntityRefMap = new LinkedHashMap<String, SchemaEntityRef>();
        for (PSODefinition psoDefinition : this.getPsoDefinitions()) {
            SchemaEntityRef entity = new SchemaEntityRef();
            entity.setEntityName(psoDefinition.getId());
            entity.setTargetID(this.getId());
            schemaEntityRefMap.put(entity.getEntityName(), entity);
            schema.addSupportedSchemaEntity(entity);
            ObjectClassDefinition objectClassDef = new ObjectClassDefinition();
            objectClassDef.setName(psoDefinition.getId());
            AttributeDefinitionReferences attrRefs = new AttributeDefinitionReferences();
            for (PSOAttributeDefinition psoAttributeDefinition : psoDefinition.getAttributeDefinitions()) {
                AttributeDefinition attrDef = new AttributeDefinition();
                attrDef.setName(psoAttributeDefinition.getName());
                dsmlSchema.addAttributeDefinition(attrDef);
                AttributeDefinitionReference attrDefRef = new AttributeDefinitionReference();
                attrDefRef.setName(psoAttributeDefinition.getName());
                attrRefs.addAttributeDefinitionReference(attrDefRef);
            }
            objectClassDef.setMemberAttributes(attrRefs);
            dsmlSchema.addObjectClassDefinition(objectClassDef);
        }
        for (PSODefinition psoDefinition : this.getPsoDefinitions()) {
            for (PSOReferencesDefinition psoReferencesDefinition : psoDefinition.getReferenceDefinitions()) {
                for (PSOReferenceDefinition psoReferenceDefinition : psoReferencesDefinition.getPsoReferenceDefinitions()) {
                    SchemaEntityRef fromEntity = (SchemaEntityRef)schemaEntityRefMap.get(psoDefinition.getId());
                    SchemaEntityRef toEntity = (SchemaEntityRef)schemaEntityRefMap.get(psoReferenceDefinition.getToPSODefinition().getId());
                    Capability capability = new Capability();
                    capability.setNamespaceURI(PSOReferencesDefinition.REFERENCE_URI);
                    capability.addAppliesTo(fromEntity);
                    cl.addCapability(capability);
                    ReferenceDefinition rd = new ReferenceDefinition();
                    rd.setTypeOfReference(psoReferencesDefinition.getName());
                    rd.setSchemaEntity(fromEntity);
                    rd.addCanReferTo(toEntity);
                    OCEtoMarshallableAdapter oce = new OCEtoMarshallableAdapter((Marshallable)rd);
                    capability.addOpenContentElement((OpenContentElement)oce);
                }
            }
        }
        this.target.setCapabilities(cl);
        schema.addOpenContentElement((OpenContentElement)dsmlSchema);
        this.target.addSchema(schema);
        return this.target;
    }

    public boolean isBundleModifications() {
        return this.bundleModifications;
    }

    public void setBundleModifications(boolean bundleModifications) {
        LOG.debug("setting bundleModifications {}", (Object)bundleModifications);
        this.bundleModifications = bundleModifications;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("id", (Object)this.id);
        toStringBuilder.append("bundleModifications", this.bundleModifications);
        return toStringBuilder.toString();
    }
}

