/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.definitions;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSPContext;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferenceDefinition;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spmlref.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSOReferencesDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PSOReferencesDefinition.class);
    private String name;
    private String emptyValue = null;
    private List<PSOReferenceDefinition> psoReferenceDefinitions;
    public static final String REFERENCE_URI_STRING = "urn:oasis:names:tc:SPML:2:0:reference";
    public static final URI REFERENCE_URI;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public void setEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
    }

    public PSOReferenceDefinition getReferenceDefinition(String ref) {
        for (PSOReferenceDefinition r : this.psoReferenceDefinitions) {
            if (!r.getRef().equals(ref)) continue;
            return r;
        }
        return null;
    }

    public List<PSOReferenceDefinition> getPsoReferenceDefinitions() {
        return this.psoReferenceDefinitions;
    }

    public void setPsoReferenceDefinitions(List<PSOReferenceDefinition> psoReferenceDefinitions) {
        this.psoReferenceDefinitions = psoReferenceDefinitions;
    }

    public List<Reference> getReferences(PSPContext context) throws LdappcException {
        String msg = "get references for '" + context.getProvisioningRequest().getId() + "' name '" + this.name + "'";
        LOG.debug("{}", (Object)msg);
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (PSOReferenceDefinition psoReferenceDefinition : this.psoReferenceDefinitions) {
            references.addAll(psoReferenceDefinition.getReferences(context, this.name));
        }
        if (this.emptyValue != null && references.isEmpty()) {
            references.addAll(this.getEmptyReferences());
        }
        LOG.debug("{} returned {}", (Object)msg, (Object)references.size());
        return references;
    }

    public List<Reference> getEmptyReferences() {
        ArrayList<Reference> references = new ArrayList<Reference>();
        LinkedHashSet<String> targetIds = new LinkedHashSet<String>();
        for (PSOReferenceDefinition psoReferenceDefinition : this.psoReferenceDefinitions) {
            targetIds.add(psoReferenceDefinition.getToPSODefinition().getPsoIdentifierDefinition().getTargetDefinition().getId());
        }
        for (String targetId : targetIds) {
            PSOIdentifier psoID = new PSOIdentifier();
            psoID.setTargetID(targetId);
            psoID.setID(this.emptyValue);
            Reference reference = new Reference();
            reference.setToPsoID(psoID);
            reference.setTypeOfReference(this.name);
            references.add(reference);
        }
        return references;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("name", (Object)this.name);
        toStringBuilder.append("emptyValue", (Object)this.emptyValue);
        return toStringBuilder.toString();
    }

    static {
        try {
            REFERENCE_URI = new URI(REFERENCE_URI_STRING);
        }
        catch (URISyntaxException e) {
            LOG.error("Unable to parse URI", (Throwable)e);
            throw new LdappcException("Unable to parse URI", e);
        }
    }
}

