/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.definitions;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.spml.PSPContext;
import edu.internet2.middleware.ldappc.spml.definitions.IdentifyingAttribute;
import edu.internet2.middleware.ldappc.spml.definitions.TargetDefinition;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSOIdentifierDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PSOIdentifierDefinition.class);
    private String baseId;
    private String ref;
    private TargetDefinition targetDefinition;
    private IdentifyingAttribute identifyingAttribute;

    public String getBaseId() {
        return this.baseId;
    }

    public void setBaseId(String baseId) {
        this.baseId = baseId;
    }

    public IdentifyingAttribute getIdentifyingAttribute() {
        return this.identifyingAttribute;
    }

    public void setIdentifyingAttribute(IdentifyingAttribute identifyingAttribute) {
        this.identifyingAttribute = identifyingAttribute;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public TargetDefinition getTargetDefinition() {
        return this.targetDefinition;
    }

    public void setTargetDefinition(TargetDefinition targetDefinition) {
        this.targetDefinition = targetDefinition;
    }

    public List<PSOIdentifier> getPSOIdentifier(PSPContext context) throws LdappcException {
        ArrayList<PSOIdentifier> psoIDs = new ArrayList<PSOIdentifier>();
        String msg = "get psoId for '" + context.getProvisioningRequest().getId() + "' ref '" + this.ref + "'";
        LOG.debug("{}", (Object)msg);
        Map<String, BaseAttribute<?>> attributes = context.getAttributes();
        if (!attributes.containsKey(this.ref)) {
            LOG.debug("{} source attribute does not exist", (Object)msg);
            return psoIDs;
        }
        BaseAttribute<?> attribute = attributes.get(this.ref);
        if (attribute.getValues().isEmpty()) {
            LOG.debug("{} no dependency values", (Object)msg);
            return psoIDs;
        }
        for (Object value : attribute.getValues()) {
            if (!(value instanceof PSOIdentifier)) {
                LOG.error("{} Unable to calculate identifier, returned object is not a " + PSOIdentifier.class + " : {}", (Object)msg, value.getClass());
                throw new LdappcException("Unable to calculate identifier, returned object is not a " + PSOIdentifier.class);
            }
            PSOIdentifier psoIdentifier = (PSOIdentifier)value;
            psoIdentifier.setTargetID(this.targetDefinition.getId());
            psoIDs.add(psoIdentifier);
            LOG.debug("{} returned '{}'", (Object)msg, (Object)PSPUtil.getString(psoIdentifier));
        }
        return psoIDs;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("ref", (Object)this.ref);
        toStringBuilder.append("baseId", (Object)this.baseId);
        toStringBuilder.append("targetDefinitionID", (Object)this.targetDefinition.getId());
        toStringBuilder.append("identifyingAttribute", (Object)this.identifyingAttribute);
        return toStringBuilder.toString();
    }
}

