/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml.config;

import edu.internet2.middleware.ldappc.spml.config.PSOReferencesDefinitionBeanDefinitionParser;
import edu.internet2.middleware.ldappc.spml.definitions.PSOReferenceDefinition;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PSOReferenceDefinitionBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final Logger LOG = LoggerFactory.getLogger(PSOReferenceDefinitionBeanDefinitionParser.class);
    public static final QName TYPE_NAME = new QName("http://grouper.internet2.edu/ldappc", "reference");

    protected Class getBeanClass(Element element) {
        return PSOReferenceDefinition.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        String ref = element.getAttributeNS(null, "ref");
        LOG.debug("Setting ref of element '{}' to '{}'", (Object)element.getLocalName(), (Object)ref);
        builder.addPropertyValue("ref", (Object)ref);
        Element referencesElement = (Element)element.getParentNode();
        Element objectElement = (Element)referencesElement.getParentNode();
        String targetId = objectElement.getAttributeNS(null, "targetId");
        String toObject = element.getAttributeNS(null, "toObject");
        String toPSODefinition = targetId + ":" + toObject;
        LOG.debug("Setting toPSODefinition of element '{}' to: '{}'", (Object)element.getLocalName(), (Object)toPSODefinition);
        builder.addPropertyReference("toPSODefinition", toPSODefinition);
        String onNotFound = element.getAttributeNS(null, "onNotFound");
        LOG.debug("Setting onNotFound of element '{}' to: '{}'", (Object)element.getLocalName(), (Object)onNotFound);
        builder.addPropertyValue("onNotFound", (Object)onNotFound);
        String multipleResults = element.getAttributeNS(null, "multipleResults");
        LOG.debug("Setting multipleResults of element '{}' to: '{}'", (Object)element.getLocalName(), (Object)multipleResults);
        builder.addPropertyValue("multipleResults", (Object)multipleResults);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String ref = element.getAttributeNS(null, "ref");
        Element referencesElement = (Element)element.getParentNode();
        return PSOReferencesDefinitionBeanDefinitionParser.resolveId(referencesElement) + ":" + ref;
    }
}

