/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc.spml;

import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.ldappc.spml.PSP;
import edu.internet2.middleware.ldappc.spml.PSPOptions;
import edu.internet2.middleware.ldappc.spml.request.BulkProvisioningRequest;
import edu.internet2.middleware.ldappc.spml.request.ProvisioningRequest;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Statistics;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.time.StopWatch;
import org.opensaml.util.resource.ResourceException;
import org.openspml.v2.msg.Marshallable;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSPCLI
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(PSPCLI.class);
    private PSP psp;
    private Timer timer;
    private BufferedWriter writer;
    private Date lastModifyTime;
    private Date lastFullSyncTime;
    private int iterations = 0;

    public static void main(String[] args) {
        PSPOptions options = new PSPOptions(args);
        try {
            if (args.length == 0) {
                options.printUsage();
                return;
            }
            options.parseCommandLineOptions();
            PSPCLI pspCLI = new PSPCLI(options);
            if (options.getInterval() == 0) {
                pspCLI.run();
            } else {
                pspCLI.schedule();
            }
        }
        catch (ParseException e) {
            options.printUsage();
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (ResourceException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public PSPCLI(PSPOptions options) throws ResourceException, IOException {
        this.psp = PSP.getPSP(options);
        this.writer = GrouperUtil.isBlank((String)this.psp.getPspOptions().getOutputFile()) ? new BufferedWriter(new OutputStreamWriter(System.out)) : new BufferedWriter(new FileWriter(this.psp.getPspOptions().getOutputFile(), true));
    }

    @Override
    public void run() {
        try {
            LOG.info("Starting {}", (Object)"ldappcng");
            LOG.debug("Starting {} with options {}", (Object)"ldappcng", (Object)this.psp.getPspOptions());
            Date now = new Date();
            StopWatch sw = new StopWatch();
            sw.start();
            if (this.lastModifyTime == null && this.psp.getPspOptions().getLastModifyTime() != null) {
                this.lastModifyTime = this.psp.getPspOptions().getLastModifyTime();
            }
            if (this.lastFullSyncTime == null) {
                this.lastFullSyncTime = now;
            }
            boolean partial = true;
            if (this.psp.getPspOptions().getIntervalFullSync() > 0 && now.getTime() - this.lastFullSyncTime.getTime() > (long)(this.psp.getPspOptions().getIntervalFullSync() * 1000)) {
                partial = false;
            }
            for (ProvisioningRequest request : this.psp.getPspOptions().getRequests()) {
                if (request instanceof BulkProvisioningRequest) {
                    if (!partial || this.lastModifyTime == null) {
                        LOG.info("Performing full synchronization. Time since last full sync {} ms", (Object)(now.getTime() - this.lastFullSyncTime.getTime()));
                    }
                    Date updatedSince = partial ? this.lastModifyTime : null;
                    ((BulkProvisioningRequest)request).setUpdatedSince(updatedSince);
                }
                if (this.psp.getPspOptions().isPrintRequests()) {
                    this.writer.write(this.psp.toXML((Marshallable)request));
                }
                Response response = this.psp.execute((Request)request);
                this.writer.write(this.psp.toXML((Marshallable)response));
            }
            this.writer.flush();
            if (!partial) {
                this.lastFullSyncTime = now;
            }
            this.lastModifyTime = now;
            sw.stop();
            LOG.info("End of {} execution : {} ms", (Object)"ldappcng", (Object)sw.getTime());
            if (this.psp.getPspOptions().getIterations() > 0 && this.iterations++ >= this.psp.getPspOptions().getIterations()) {
                LOG.info("Finish {} execution : {} provisioning cycles performed.", (Object)"ldappcng", (Object)this.iterations);
                this.timer.cancel();
            }
            if (LOG.isDebugEnabled()) {
                for (String stats : PSPCLI.getAllCacheStats()) {
                    LOG.debug(stats);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Unable to write SPML.", (Throwable)e);
            this.timer.cancel();
        }
    }

    public void schedule() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 0L, (long)(1000 * this.psp.getPspOptions().getInterval()));
    }

    public PSP getPSP() {
        return this.psp;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public static List<String> getAllCacheStats() {
        TreeMap<String, String> name2stats = new TreeMap<String, String>();
        ArrayList cacheManagers = new ArrayList(CacheManager.ALL_CACHE_MANAGERS);
        for (CacheManager cacheManager : cacheManagers) {
            for (String cacheName : cacheManager.getCacheNames()) {
                long m;
                Statistics stats = cacheManager.getCache(cacheName).getStatistics();
                long h = stats.getCacheHits();
                if (h + (m = stats.getCacheMisses()) == 0L) continue;
                String ratio = h + m == 0L ? "0%" : MessageFormat.format("{0,number,percent}", 1.0 * (double)h / (double)(h + m));
                String out = String.format("cache hit ratio %4s %6d hits %6d miss : %s", ratio, h, m, cacheName);
                name2stats.put(cacheName, out);
            }
        }
        ArrayList<String> out = new ArrayList<String>();
        for (String cacheName : name2stats.keySet()) {
            out.add((String)name2stats.get(cacheName));
        }
        return out;
    }
}

