/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc;

import edu.internet2.middleware.ldappc.exception.LdappcException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class LdappcOptions {
    private String subjectId = "GrouperSystem";
    private boolean isTest;
    private boolean doGroups = false;
    private boolean doMemberships = false;
    private Date lastModifyTime;
    private int interval = 0;
    private String configManagerLocation;
    private String propertiesFileLocation;
    private String outputFileLocation = "ldappc.ldif";
    private boolean logLdif = false;
    private String attributeResolverLocation;
    public static final String ATTRIBUTE_RESOLVER_FILE_NAME_INTERNAL = "ldappc-internal.xml";
    public static final String ATTRIBUTE_RESOLVER_FILE_NAME_SERVICES = "ldappc-services.xml";
    public static final String ATTRIBUTE_AUTHORITY_NAME = "grouper.AttributeAuthority";
    public static final String ATTRIBUTE_RESOLVER_NAME = "grouper.AttributeResolver";
    private ProvisioningMode mode = ProvisioningMode.PROVISION;
    private Options options = new Options();
    private Option subjectOption = new Option("subject", true, "The SubjectId used to establish Grouper API sessions. Defaults to GrouperSystem.");
    private Option groupsOption = new Option("groups", false, "Provision groups.");
    private Option membershipsOption = new Option("memberships", false, "Provision memberships.");
    private Option lastModifyTimeOption = new Option("lastModifyTime", true, "Select objects changed since this time.");
    private Option configManagerOption = new Option("configManager", true, "Path to configuration file. Defaults to classpath resource ldappc.xml.");
    private Option propertiesFileOption = new Option("properties", true, "Path to properties file. Defaults to classpath resource ldappc.properties.");
    private Option intervalOption = new Option("interval", true, "Number of seconds between provisioning cycles. If omitted, only one provisioning cycle is performed.");
    private Option calculateOption = new Option("calc", true, "Calculate provisioning and write to file.");
    private Option dryRunOption = new Option("dryRun", true, "Write provisioning changes to file only, do not provision changes.");
    private Option logLdifOption = new Option("logLDIF", false, "While provisioning, log changes in LDIF format.");
    private Option attributeResolverLocationOption = new Option("resolver", true, "Path to directory containing Shibboleth Attribute Resolver configuration files.");

    public LdappcOptions() {
        this.subjectOption.setArgName("subjectId");
        this.options.addOption(this.subjectOption);
        this.options.addOption(this.groupsOption);
        this.options.addOption(this.membershipsOption);
        this.lastModifyTimeOption.setArgName("yyyy-MM-dd[_hh:mm:ss]");
        this.options.addOption(this.lastModifyTimeOption);
        this.intervalOption.setArgName("seconds");
        this.options.addOption(this.intervalOption);
        this.configManagerOption.setArgName("path");
        this.options.addOption(this.configManagerOption);
        this.propertiesFileOption.setArgName("path");
        this.options.addOption(this.propertiesFileOption);
        this.options.addOption(this.logLdifOption);
        OptionGroup modeOptionGroup = new OptionGroup();
        this.calculateOption.setArgName("file");
        modeOptionGroup.addOption(this.calculateOption);
        this.dryRunOption.setArgName("file");
        modeOptionGroup.addOption(this.dryRunOption);
        this.options.addOptionGroup(modeOptionGroup);
        this.attributeResolverLocationOption.setArgName("path");
        this.options.addOption(this.attributeResolverLocationOption);
    }

    public LdappcOptions(String[] args) throws ParseException, java.text.ParseException {
        this();
        this.init(args);
    }

    public void init(String[] args) throws ParseException, java.text.ParseException {
        String file;
        PosixParser parser = new PosixParser();
        CommandLine line = parser.parse(this.options, args);
        if (line.hasOption(this.subjectOption.getOpt())) {
            this.setSubjectId(line.getOptionValue(this.subjectOption.getOpt()));
        }
        if (line.hasOption(this.groupsOption.getOpt())) {
            this.setDoGroups(true);
        }
        if (line.hasOption(this.membershipsOption.getOpt())) {
            this.setDoMemberships(true);
        }
        if (!this.getDoGroups() && !this.getDoMemberships()) {
            throw new LdappcException("Specify either " + this.groupsOption.toString() + " or " + this.membershipsOption.toString());
        }
        if (line.hasOption(this.lastModifyTimeOption.getOpt())) {
            StringBuffer dateInput = new StringBuffer(line.getOptionValue(this.lastModifyTimeOption.getOpt()));
            int len = dateInput.length();
            if (len == 10) {
                dateInput.append("_00:00:00");
            } else if (len == 13) {
                dateInput.append(":00:00");
            } else if (len == 16) {
                dateInput.append(":00");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'_'hh:mm:ss");
            df.setLenient(true);
            this.setLastModifyTime(df.parse(dateInput.toString()));
        }
        if (line.hasOption(this.intervalOption.getOpt())) {
            this.setInterval(Integer.parseInt(line.getOptionValue(this.intervalOption.getOpt())));
        }
        if (line.hasOption(this.configManagerOption.getOpt())) {
            file = line.getOptionValue(this.configManagerOption.getOpt());
            if (new File(file).exists()) {
                this.setConfigManagerLocation(file);
            } else {
                throw new LdappcException("Cannot find config file : " + file);
            }
        }
        if (line.hasOption(this.propertiesFileOption.getOpt())) {
            file = line.getOptionValue(this.propertiesFileOption.getOpt());
            if (new File(file).exists()) {
                this.setPropertiesFileLocation(file);
            } else {
                throw new LdappcException("Cannot find properties file : " + file);
            }
        }
        if (line.hasOption(this.calculateOption.getOpt())) {
            this.setOutputFileLocation(line.getOptionValue(this.calculateOption.getOpt()));
            this.setMode(ProvisioningMode.CALCULATE);
        }
        if (line.hasOption(this.dryRunOption.getOpt())) {
            this.setOutputFileLocation(line.getOptionValue(this.dryRunOption.getOpt()));
            this.setMode(ProvisioningMode.DRYRUN);
        }
        if (line.hasOption(this.logLdifOption.getOpt())) {
            this.setLogLdif(true);
        }
        if (line.hasOption(this.attributeResolverLocationOption.getOpt())) {
            this.setAttributeResolverLocation(line.getOptionValue(this.attributeResolverLocationOption.getOpt()));
        }
    }

    public void setIsTest(boolean isTest) {
        this.isTest = isTest;
    }

    public boolean isTest() {
        return this.isTest;
    }

    protected void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    protected void setDoGroups(boolean doGroups) {
        this.doGroups = doGroups;
    }

    public boolean getDoGroups() {
        return this.doGroups;
    }

    protected void setDoMemberships(boolean doMemberships) {
        this.doMemberships = doMemberships;
    }

    public boolean getDoMemberships() {
        return this.doMemberships;
    }

    public void setLastModifyTime(Date lastModifyTime) {
        this.lastModifyTime = lastModifyTime;
    }

    public Date getLastModifyTime() {
        return this.lastModifyTime;
    }

    protected void setInterval(int interval) {
        this.interval = interval;
    }

    public int getInterval() {
        return this.interval;
    }

    protected void setConfigManagerLocation(String configManagerLocation) {
        this.configManagerLocation = configManagerLocation;
    }

    public String getConfigManagerLocation() {
        return this.configManagerLocation;
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("ldappc", this.options, true);
    }

    public ProvisioningMode getMode() {
        return this.mode;
    }

    protected void setMode(ProvisioningMode mode) {
        this.mode = mode;
    }

    public String getOutputFileLocation() {
        return this.outputFileLocation;
    }

    protected void setOutputFileLocation(String outputFileLocation) {
        this.outputFileLocation = outputFileLocation;
    }

    public String getPropertiesFileLocation() {
        return this.propertiesFileLocation;
    }

    public void setPropertiesFileLocation(String propertiesFileLocation) {
        this.propertiesFileLocation = propertiesFileLocation;
    }

    protected void setLogLdif(boolean logLdif) {
        this.logLdif = logLdif;
    }

    public boolean getLogLdif() {
        return this.logLdif;
    }

    public String getAttributeResolverLocation() {
        return this.attributeResolverLocation;
    }

    protected void setAttributeResolverLocation(String attributeResolverLocation) {
        this.attributeResolverLocation = attributeResolverLocation;
    }

    public static enum ProvisioningMode {
        CALCULATE,
        DRYRUN,
        PROVISION;

    }
}

