/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc;

import edu.internet2.middleware.grouper.Group;
import edu.internet2.middleware.grouper.GrouperSession;
import edu.internet2.middleware.grouper.Member;
import edu.internet2.middleware.grouper.Stem;
import edu.internet2.middleware.grouper.StemFinder;
import edu.internet2.middleware.grouper.SubjectFinder;
import edu.internet2.middleware.grouper.audit.GrouperEngineBuiltin;
import edu.internet2.middleware.grouper.audit.GrouperEngineIdentifier;
import edu.internet2.middleware.grouper.exception.AttributeNotFoundException;
import edu.internet2.middleware.grouper.exception.StemNotFoundException;
import edu.internet2.middleware.grouper.filter.ChildGroupFilter;
import edu.internet2.middleware.grouper.filter.GroupAttributeExactFilter;
import edu.internet2.middleware.grouper.filter.GrouperQuery;
import edu.internet2.middleware.grouper.filter.NullFilter;
import edu.internet2.middleware.grouper.filter.QueryFilter;
import edu.internet2.middleware.grouper.filter.UnionFilter;
import edu.internet2.middleware.grouper.hibernate.GrouperContext;
import edu.internet2.middleware.grouper.misc.GrouperStartup;
import edu.internet2.middleware.grouper.shibboleth.dataConnector.GroupDataConnector;
import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.ldappc.ConfigManager;
import edu.internet2.middleware.ldappc.LdappcConfig;
import edu.internet2.middleware.ldappc.LdappcOptions;
import edu.internet2.middleware.ldappc.exception.ConfigurationException;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.synchronize.GroupEntrySynchronizer;
import edu.internet2.middleware.ldappc.synchronize.StringMembershipSynchronizer;
import edu.internet2.middleware.ldappc.util.ExternalSort;
import edu.internet2.middleware.ldappc.util.LdapSearchFilter;
import edu.internet2.middleware.ldappc.util.LdapUtil;
import edu.internet2.middleware.ldappc.util.RangeSearchResultHandler;
import edu.internet2.middleware.ldappc.util.SubjectCache;
import edu.internet2.middleware.shibboleth.common.attribute.AttributeAuthority;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethAttributeResolver;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.subject.Subject;
import edu.vt.middleware.ldap.Ldap;
import edu.vt.middleware.ldap.SearchFilter;
import edu.vt.middleware.ldap.handler.SearchResultHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.opensaml.util.resource.FilesystemResource;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;

public final class Ldappc
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(Ldappc.class);
    private LdappcOptions options;
    private LdappcConfig configuration;
    private Ldap ldap;
    private SubjectCache subjectCache;
    protected Name rootDn;
    private GrouperSession grouperSession;
    private static final int SORT_BATCH_SIZE = 200000;
    private BufferedWriter writer;
    private GenericApplicationContext gContext;
    private AttributeAuthority attributeAuthority;
    private ShibbolethAttributeResolver attributeResolver;
    public static final int STATUS_NEW = 0;
    public static final int STATUS_MODIFIED = 1;
    public static final int STATUS_UNCHANGED = 2;
    public static final int STATUS_UNKNOWN = 3;

    public Ldappc(LdappcOptions options) {
        this(options, null, null);
    }

    public Ldappc(LdappcOptions options, LdappcConfig configuration, Ldap ldap) {
        this.options = options;
        this.configuration = configuration;
        this.ldap = ldap;
        this.initialize();
    }

    public static void main(String[] args) {
        try {
            LOG.debug("Starting Ldappc with the following arguments: {}", Arrays.asList(args));
            LdappcOptions options = new LdappcOptions();
            try {
                if (args.length == 0) {
                    options.printUsage();
                    return;
                }
                options.init(args);
            }
            catch (org.apache.commons.cli.ParseException e) {
                options.printUsage();
                System.err.println(e.getMessage());
                e.printStackTrace();
                return;
            }
            catch (ParseException e) {
                options.printUsage();
                System.err.println(e.getMessage());
                e.printStackTrace();
                return;
            }
            LOG.info("Starting Ldappc");
            Ldappc ldappc = new Ldappc(options);
            if (options.getInterval() == 0) {
                ldappc.run();
            } else {
                ldappc.schedule();
            }
            LOG.info("End of Ldappc execution.");
        }
        catch (LdappcException e) {
            System.err.println(e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        GrouperContext.createNewDefaultContext((GrouperEngineIdentifier)GrouperEngineBuiltin.LDAPPC, (boolean)false, (boolean)true);
        LOG.info("***** Starting Provisioning *****");
        long begin = System.currentTimeMillis();
        this.getGrouperSession();
        this.getContext();
        Date now = new Date();
        try {
            if (LOG.isDebugEnabled()) {
                for (String source : this.configuration.getSourceSubjectHashEstimates().keySet()) {
                    LOG.debug("Estimate({}) = {}", (Object)source, (Object)this.configuration.getSourceSubjectHashEstimate(source));
                }
            }
            switch (this.options.getMode()) {
                case PROVISION: {
                    this.provision();
                    break;
                }
                case DRYRUN: {
                    this.dryRun();
                    break;
                }
                case CALCULATE: {
                    this.calculate();
                }
            }
            this.options.setLastModifyTime(now);
            if (LOG.isInfoEnabled()) {
                int subjectIDLookups = this.getSubjectCache().getSubjectIdLookups();
                int subjectIDTableHits = this.getSubjectCache().getSubjectIdTableHits();
                LOG.info("Subject ID Lookups : {}", (Object)subjectIDLookups);
                LOG.info("Subject Table Hits : {}", (Object)subjectIDTableHits);
                double ratio = (double)Math.round((double)subjectIDTableHits / (double)subjectIDLookups * 1000.0) / 10.0;
                LOG.info("Subject Hit Ratio  : {} %", (Object)ratio);
                long diff = System.currentTimeMillis() - begin;
                LOG.info("Time (seconds)     : {}", (Object)DecimalFormat.getInstance().format((double)diff / 1000.0));
            }
        }
        catch (Exception e) {
            LOG.error("Grouper Provision Failed", (Throwable)e);
            this.cancel();
        }
        finally {
            if (!this.options.isTest() && this.ldap != null) {
                LOG.debug("closing connection to ldap '{}'", (Object)this.ldap.getLdapConfig().getLdapUrl());
                this.ldap.close();
                this.ldap = null;
            }
            if (this.grouperSession != null) {
                LOG.debug("stopping grouper session '{}'", (Object)this.grouperSession);
                this.grouperSession.stop();
                this.grouperSession = null;
            }
        }
    }

    public void initialize() {
        String rootDnStr;
        if (this.configuration == null) {
            this.configuration = new ConfigManager(this.options.getConfigManagerLocation(), this.options.getPropertiesFileLocation());
        }
        if ((rootDnStr = this.configuration.getGroupDnRoot()) == null) {
            throw new ConfigurationException("Group root DN is not defined.");
        }
        this.getContext();
        try {
            this.rootDn = new LdapName(rootDnStr);
        }
        catch (NamingException e) {
            throw new ConfigurationException("Unable to parse root DN.", e);
        }
        this.subjectCache = new SubjectCache(this);
        GrouperStartup.startup();
        if (!this.configuration.getAttributeResolverMapping().isEmpty()) {
            this.initAttributeAuthority();
        }
        if (!this.configuration.getResolverQueries().isEmpty()) {
            this.initAttributeResolver();
        }
    }

    public void provision() throws LdappcException, NamingException, IOException {
        Set<Group> groups = this.buildGroupSet();
        if (this.options.getDoGroups()) {
            this.provisionGroups(groups);
        }
        if (this.options.getDoMemberships()) {
            this.provisionMemberships(groups);
        }
    }

    public File dryRun() throws LdappcException, NamingException, IOException {
        File file = new File(this.options.getOutputFileLocation());
        if (!file.exists()) {
            file.createNewFile();
        }
        this.writer = LdapUtil.openWriter(file);
        this.provision();
        if (this.writer != null) {
            this.writer.close();
        }
        return file;
    }

    public File calculate() throws IOException, ConfigurationException, NamingException {
        File file = new File(this.options.getOutputFileLocation());
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedWriter writer = LdapUtil.openWriter(file);
        GroupEntrySynchronizer synchronizer = new GroupEntrySynchronizer(this, true);
        Set<Group> groups = this.buildGroupSet();
        if (this.options.getDoGroups()) {
            if (LdappcConfig.GroupDNStructure.bushy.equals((Object)this.getConfig().getGroupDnStructure())) {
                TreeSet<Name> stemDns = new TreeSet<Name>();
                for (Group group : groups) {
                    stemDns.addAll(this.calculateStemDns(group));
                }
                for (Name stemDn : stemDns) {
                    BasicAttributes attributes = this.calculateStemAttributes(stemDn);
                    writer.write(LdifUtils.convertToLdif((Attributes)attributes, (LdapDN)new LdapDN(stemDn)) + "\n");
                }
            }
            for (Group group : groups) {
                writer.write(synchronizer.calculateLdif(group, groups) + "\n");
            }
        }
        if (this.options.getDoMemberships()) {
            File membershipFile = this.buildMembershipFile(groups);
            this.parseMembershipUpdates(membershipFile, writer);
        }
        writer.close();
        return file;
    }

    protected Set<Group> buildGroupSet() {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Stem rootStem = StemFinder.findRootStem((GrouperSession)this.getGrouperSession());
        NullFilter groupFilter = new NullFilter();
        Map attrValueMap = this.configuration.getGroupAttrMatchingQueries();
        for (Map.Entry entry : attrValueMap.entrySet()) {
            String name = (String)entry.getKey();
            for (String value : (Set)entry.getValue()) {
                groupFilter = new UnionFilter((QueryFilter)groupFilter, (QueryFilter)new GroupAttributeExactFilter(name, value, rootStem));
            }
        }
        Set subStems = this.configuration.getGroupSubordinateStemQueries();
        for (String stemName : subStems) {
            try {
                Stem stem = StemFinder.findByName((GrouperSession)this.getGrouperSession(), (String)stemName, (boolean)true);
                groupFilter = new UnionFilter((QueryFilter)groupFilter, (QueryFilter)new ChildGroupFilter(stem));
            }
            catch (StemNotFoundException snfe) {
                LOG.error(snfe.getMessage(), (Throwable)snfe);
            }
        }
        GrouperQuery query = GrouperQuery.createQuery((GrouperSession)this.getGrouperSession(), (QueryFilter)groupFilter);
        groups.addAll(query.getGroups());
        Set<String> dataConnectorIds = this.configuration.getResolverQueries();
        if (!dataConnectorIds.isEmpty()) {
            for (String dataConnectorId : dataConnectorIds) {
                GroupDataConnector groupDataConnector = (GroupDataConnector)this.getAttributeResolver().getServiceContext().getBean(dataConnectorId);
                groups.addAll(groupDataConnector.getGroupQueryFilter().getResults(this.getGrouperSession()));
            }
        }
        LOG.debug("provisioning {} groups", (Object)groups.size());
        return groups;
    }

    private void provisionGroups(Set groups) throws NamingException, LdappcException {
        if (this.getConfig().getProvisionGroupsTwoStep()) {
            GroupEntrySynchronizer synchronizerWithoutMemberDns = new GroupEntrySynchronizer(this, false);
            synchronizerWithoutMemberDns.synchronize(groups);
        }
        GroupEntrySynchronizer synchronizerWithMemberDns = new GroupEntrySynchronizer(this, true);
        synchronizerWithMemberDns.synchronize(groups);
    }

    private void provisionMemberships(Set<Group> groups) throws NamingException, IOException {
        HashSet<Name> existingSubjectDns = new HashSet<Name>();
        this.buildSourceSubjectDnSet(existingSubjectDns);
        LOG.debug("found " + existingSubjectDns.size() + " existing subjectDns");
        File updatesFile = this.buildMembershipFile(groups);
        Set<Name> subjectDNs = this.performActualMembershipUpdates(updatesFile);
        for (Name subjectDN : subjectDNs) {
            existingSubjectDns.remove(subjectDN);
        }
        LOG.debug("Clearing old memberships");
        this.clearSubjectEntryMemberships(existingSubjectDns);
    }

    private File buildMembershipFile(Set<Group> groups) throws NamingException, IOException {
        File updatesFile = this.getTempFile();
        BufferedWriter updatesWriter = LdapUtil.openWriter(updatesFile);
        String groupNamingAttribute = this.configuration.getMemberGroupsNamingAttribute();
        if (groupNamingAttribute == null) {
            throw new ConfigurationException("The name of the group naming attribute is null.");
        }
        for (Group group : groups) {
            String groupNameString = this.getGroupNameString(group, groupNamingAttribute);
            if (groupNameString == null) continue;
            for (Member member : group.getMembers()) {
                Set<Name> subjectDns = this.subjectCache.findSubjectDn(member);
                if (subjectDns == null) continue;
                for (Name subjectDn : subjectDns) {
                    updatesWriter.write(subjectDn.toString() + "\t" + groupNameString + "\n");
                }
            }
        }
        updatesWriter.close();
        ExternalSort.sort(updatesFile.getAbsolutePath(), 200000);
        return updatesFile;
    }

    private String getGroupNameString(Group group, String groupNamingAttribute) {
        String groupNameString = null;
        try {
            groupNameString = group.getAttributeOrFieldValue(groupNamingAttribute, false, true);
            if (groupNameString == null) {
                String errorData = this.getErrorData(null, null, null);
                LdappcException e = new LdappcException("Group " + group.getName() + " has no " + groupNamingAttribute + " attribute and cannot be provisioned as a membership");
                LOG.error(errorData, (Throwable)e);
            }
        }
        catch (AttributeNotFoundException e1) {
            LdappcException e = new LdappcException("Group " + group.getName() + " has no " + groupNamingAttribute + " attribute and cannot be provisioned as a membership", e1);
            LOG.error("Attribute not found", (Throwable)e);
        }
        return groupNameString;
    }

    private File getTempFile() throws IOException {
        File tempFile = null;
        String tempDir = this.configuration.getMemberGroupsListTemporaryDirectory();
        if (tempDir != null) {
            tempFile = new File(tempDir);
            if (!tempFile.exists()) {
                tempFile.mkdirs();
            } else if (!tempFile.isDirectory()) {
                throw new ConfigurationException("Temporary directory " + tempDir + " is not a directory");
            }
        }
        return File.createTempFile("ldappc", ".tmp", tempFile);
    }

    private void parseMembershipUpdates(File updatesFile, BufferedWriter writer) throws NamingException {
        BufferedReader updatesReader = LdapUtil.openReader(updatesFile);
        try {
            TreeSet<String> groups = new TreeSet<String>();
            String currentSubjectDn = null;
            String s = null;
            while ((s = updatesReader.readLine()) != null) {
                String[] parts = s.split("\t", 2);
                String subjectDn = parts[0];
                String groupNameString = parts[1];
                if (!subjectDn.equals(currentSubjectDn)) {
                    if (currentSubjectDn != null) {
                        StringMembershipSynchronizer synchronizer = this.getMembershipSynchronizer(currentSubjectDn);
                        writer.write(synchronizer.calculateLdif(groups));
                    }
                    currentSubjectDn = subjectDn;
                    groups.clear();
                }
                groups.add(groupNameString);
            }
            if (currentSubjectDn != null) {
                StringMembershipSynchronizer synchronizer = this.getMembershipSynchronizer(currentSubjectDn);
                writer.write(synchronizer.calculateLdif(groups));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            updatesReader.close();
            if (!LOG.isDebugEnabled()) {
                updatesFile.delete();
            }
        }
        catch (IOException e) {
            throw new LdappcException("IOException reading membership file", e);
        }
    }

    private Set<Name> performActualMembershipUpdates(File updatesFile) throws NamingException {
        HashSet<Name> subjectDNs = new HashSet<Name>();
        BufferedReader updatesReader = LdapUtil.openReader(updatesFile);
        try {
            HashSet<String> groups = new HashSet<String>();
            String currentSubjectDn = null;
            String s = null;
            while ((s = updatesReader.readLine()) != null) {
                String[] parts = s.split("\t", 2);
                String subjectDn = parts[0];
                String groupNameString = parts[1];
                subjectDNs.add(new LdapName(subjectDn));
                if (!subjectDn.equals(currentSubjectDn)) {
                    if (currentSubjectDn != null) {
                        this.updateSubject(currentSubjectDn, groups);
                    }
                    currentSubjectDn = subjectDn;
                    groups.clear();
                }
                groups.add(groupNameString);
            }
            if (currentSubjectDn != null) {
                this.updateSubject(currentSubjectDn, groups);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            updatesReader.close();
            if (!LOG.isDebugEnabled()) {
                updatesFile.delete();
            }
        }
        catch (IOException e) {
            throw new LdappcException("IOException reading membership file", e);
        }
        return subjectDNs;
    }

    private void updateSubject(String objectDN, Set<String> groups) {
        try {
            LOG.debug("synchronizing memberships for '" + objectDN + "'");
            StringMembershipSynchronizer synchronizer = this.getMembershipSynchronizer(objectDN);
            synchronizer.synchronize(groups);
        }
        catch (Exception e) {
            LOG.error("An error occurred ", (Throwable)e);
        }
    }

    private StringMembershipSynchronizer getMembershipSynchronizer(String subjectDn) throws NamingException {
        return new StringMembershipSynchronizer(this, subjectDn);
    }

    private void buildSourceSubjectDnSet(Set<Name> subjectDns) throws NamingException {
        Map<String, LdapSearchFilter> sourceFilterMap = this.configuration.getSourceSubjectLdapFilters();
        for (LdapSearchFilter filter : sourceFilterMap.values()) {
            this.addSubjectDnSet(subjectDns, filter);
            if (!this.getConfig().getProvisionMemberGroups()) continue;
            this.addSubjectDnSet(subjectDns, new LdapSearchFilter(this.getConfig().getGroupDnRoot(), 2, "(&(objectclass=" + this.getConfig().getGroupDnObjectClass() + ")(" + this.getConfig().getGroupDnRdnAttribute() + "=*))", LdapSearchFilter.OnNotFound.fail, false));
        }
    }

    private void addSubjectDnSet(Set<Name> subjectDns, LdapSearchFilter filter) throws NamingException {
        String ldapFilter;
        String listAttribute = this.configuration.getMemberGroupsListAttribute();
        if (listAttribute == null) {
            throw new ConfigurationException("Member groups list attribute is null");
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(filter.getScope());
        searchControls.setCountLimit(0L);
        searchControls.setReturningAttributes(new String[]{listAttribute});
        String listObjectClass = this.configuration.getMemberGroupsListObjectClass();
        String filterExpr = ldapFilter = LdapUtil.convertParameterToAsterisk(filter.getFilter(), 0);
        if (listObjectClass == null) {
            filterExpr = filterExpr + "(" + listAttribute + "=*)";
        } else {
            String subExpr = "(" + listAttribute + "=*)";
            subExpr = subExpr + "(" + "objectClass" + "=" + listObjectClass + ")";
            filterExpr = filterExpr + "(|" + subExpr + ")";
        }
        filterExpr = "(&" + filterExpr + ")";
        String baseDn = filter.getBase();
        LOG.debug("search base '" + baseDn + "' filter '" + filter + "' attrs " + Arrays.asList(searchControls.getReturningAttributes()));
        Iterator searchResults = this.getContext().search(LdapUtil.escapeForwardSlash(baseDn), new SearchFilter(filterExpr), searchControls);
        while (searchResults.hasNext()) {
            SearchResult searchResult = (SearchResult)searchResults.next();
            LdapName subjectDn = new LdapName(searchResult.getName());
            if (searchResult.getAttributes().get(listAttribute) == null) continue;
            subjectDns.add(subjectDn);
        }
    }

    private void clearSubjectEntryMemberships(Set<Name> subjectDnSet) throws NamingException {
        HashSet<String> emptySet = new HashSet<String>();
        for (Name subjectDn : subjectDnSet) {
            try {
                StringMembershipSynchronizer synchronizer = this.getMembershipSynchronizer(subjectDn.toString());
                synchronizer.synchronize(emptySet);
            }
            catch (Exception e) {
                LOG.error("An error occurred ", (Throwable)e);
            }
        }
    }

    private String getErrorData(Member member, Subject subject, Name subjectDn) {
        String errorData = "MEMBER";
        if (member != null) {
            errorData = errorData + Ldappc.getMemberData(member);
        }
        if (subject != null) {
            errorData = errorData + "[ SUBJECT " + this.getSubjectCache().getSubjectData(subject) + " ]";
        }
        if (subjectDn != null) {
            errorData = errorData + "[ SUBJECT DN = " + subjectDn + " ]";
        }
        return errorData;
    }

    public static String getMemberData(Member member) {
        String memberData = "null";
        if (member != null) {
            memberData = "[ UUID = " + member.getUuid() + " ][ SUBJECT ID = " + member.getSubjectId() + " ][ SUBJECT SOURCE ID = " + member.getSubjectSourceId() + " ]";
        }
        return memberData;
    }

    public static String getGroupData(Group group) {
        String grpData = "null";
        if (group != null) {
            grpData = "[ DISPLAY NAME = " + group.getDisplayName() + " ][NAME = " + group.getName() + "][UID = " + group.getUuid() + "]";
        }
        return grpData;
    }

    public SubjectCache getSubjectCache() {
        return this.subjectCache;
    }

    public Ldap getContext() {
        if (this.ldap == null) {
            try {
                this.ldap = new Ldap();
                if (this.options.getPropertiesFileLocation() == null) {
                    File file = GrouperUtil.fileFromResourceName((String)"ldappc.properties");
                    if (file == null) {
                        throw new FileNotFoundException("Unable to find file 'ldappc.properties'");
                    }
                    this.ldap.loadFromProperties((InputStream)new FileInputStream(file));
                } else {
                    this.ldap.loadFromProperties((InputStream)new FileInputStream(this.options.getPropertiesFileLocation()));
                }
                LOG.debug("Connecting to ldap '{}'", (Object)this.ldap.getLdapConfig().getLdapUrl());
                if (this.configuration.useRangeSearchResultHandler()) {
                    ArrayList<SearchResultHandler> handlers = new ArrayList<SearchResultHandler>(Arrays.asList(this.ldap.getLdapConfig().getSearchResultHandlers()));
                    handlers.add((SearchResultHandler)new RangeSearchResultHandler(this.ldap));
                    this.ldap.getLdapConfig().setSearchResultHandlers(handlers.toArray(new SearchResultHandler[0]));
                }
            }
            catch (FileNotFoundException e) {
                LOG.error("Unable to read properties file.", (Throwable)e);
                throw new LdappcException("Unable to read properties file.", e);
            }
        }
        return this.ldap;
    }

    public LdappcConfig getConfig() {
        return this.configuration;
    }

    public LdappcOptions getOptions() {
        return this.options;
    }

    public int determineStatus(Group group) {
        Date memberModifyTime;
        Date lastModifyTime = this.options.getLastModifyTime();
        if (lastModifyTime == null) {
            return 3;
        }
        Date groupCreateTime = group.getCreateTime();
        if (groupCreateTime == null) {
            return 3;
        }
        if (lastModifyTime.before(groupCreateTime)) {
            return 0;
        }
        Date groupModifyTime = group.getModifyTime();
        if (groupModifyTime != null && lastModifyTime.before(groupModifyTime)) {
            return 1;
        }
        if (group.getLastMembershipChange() != null && lastModifyTime.before(memberModifyTime = new Date(group.getLastMembershipChange().getTime()))) {
            return 1;
        }
        return 2;
    }

    public Name getRootDn() {
        return this.rootDn;
    }

    public Name calculateGroupDn(Group group) throws NamingException, LdappcException {
        String attr;
        Name groupDn = null;
        groupDn = LdappcConfig.GroupDNStructure.bushy.equals((Object)this.configuration.getGroupDnStructure()) ? this.calculateStemDn(group) : (Name)this.rootDn.clone();
        String rdnString = null;
        rdnString = LdappcConfig.GroupDNStructure.flat.equals((Object)this.configuration.getGroupDnStructure()) ? ("name".equals(this.configuration.getGroupDnGrouperAttribute()) ? group.getName() : ((attr = group.getAttributeOrFieldValue(this.configuration.getGroupDnGrouperAttribute(), true, false)) != null ? attr : group.getUuid())) : group.getExtension();
        groupDn = groupDn.add(this.configuration.getGroupDnRdnAttribute() + "=" + LdapUtil.makeLdapNameSafe(rdnString));
        return groupDn;
    }

    public Name calculateStemDn(Group group) throws NamingException {
        List<Name> names = this.calculateStemDns(group);
        return names.get(names.size() - 1);
    }

    public List<Name> calculateStemDns(Group group) throws NamingException {
        ArrayList<Name> names = new ArrayList<Name>();
        Name stemDn = (Name)this.rootDn.clone();
        Stem stem = group.getParentStem();
        StringTokenizer stemTokens = new StringTokenizer(stem.getName(), ":");
        while (stemTokens.hasMoreTokens()) {
            String rdnString = stemTokens.nextToken();
            String rdnValue = LdapUtil.makeLdapNameSafe(rdnString);
            stemDn = stemDn.add("ou=" + rdnValue);
            names.add((Name)stemDn.clone());
        }
        return names;
    }

    public BasicAttributes calculateStemAttributes(Name stemDn) throws InvalidNameException {
        BasicAttributes attributes = new BasicAttributes(true);
        attributes.put(new BasicAttribute("objectClass", "organizationalUnit"));
        Rdn rdn = new Rdn(stemDn.get(stemDn.size() - 1));
        attributes.put("ou", rdn.getValue().toString());
        return attributes;
    }

    public BufferedWriter getWriter() {
        return this.writer;
    }

    protected GrouperSession getGrouperSession() {
        if (this.grouperSession == null) {
            Subject subject = SubjectFinder.findById((String)this.options.getSubjectId(), (boolean)true);
            this.grouperSession = GrouperSession.start((Subject)subject);
            LOG.debug("started grouper session '{}'", (Object)this.grouperSession);
        }
        return this.grouperSession;
    }

    protected void schedule() {
        Timer timer = new Timer();
        timer.schedule((TimerTask)this, 0L, (long)(1000 * this.options.getInterval()));
    }

    private GenericApplicationContext getApplicationContext() {
        if (this.gContext == null) {
            try {
                this.gContext = new GenericApplicationContext();
                SpringConfigurationUtils.populateRegistry((BeanDefinitionRegistry)this.gContext, this.getResources());
                this.gContext.refresh();
                this.gContext.registerShutdownHook();
            }
            catch (ResourceException e) {
                LOG.error("Unable to initialize resources", (Throwable)e);
                throw new LdappcException("Unable to initialize resources", e);
            }
        }
        return this.gContext;
    }

    private List<Resource> getResources() throws ResourceException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.options.getAttributeResolverLocation() != null) {
            LOG.debug("loading attribute resolver configuration from '{}'", (Object)this.options.getAttributeResolverLocation());
            String internalPath = this.options.getAttributeResolverLocation() + System.getProperty("file.separator") + "ldappc-internal.xml";
            String servicesPath = this.options.getAttributeResolverLocation() + System.getProperty("file.separator") + "ldappc-services.xml";
            File internal = new File(internalPath);
            if (!internal.exists()) {
                LOG.error("Unable to read attribute resolver configuration file " + internalPath);
                throw new LdappcException("Unable to read attribute resolver configuration file " + internalPath);
            }
            File services = new File(servicesPath);
            if (!services.exists()) {
                LOG.error("Unable to read attribute resolver configuration file " + servicesPath);
                throw new LdappcException("Unable to read attribute resolver configuration file " + servicesPath);
            }
            resources.add((Resource)new FilesystemResource(internalPath));
            resources.add((Resource)new FilesystemResource(servicesPath));
        } else {
            File internal = GrouperUtil.fileFromResourceName((String)"ldappc-internal.xml");
            if (internal == null) {
                LOG.error("Unable to read attribute resolver configuration file ldappc-internal.xml");
                throw new LdappcException("Unable to read attribute resolver configuration file ldappc-internal.xml");
            }
            File services = GrouperUtil.fileFromResourceName((String)"ldappc-services.xml");
            if (services == null) {
                LOG.error("Unable to read attribute resolver configuration file ldappc-services.xml");
                throw new LdappcException("Unable to read attribute resolver configuration file ldappc-services.xml");
            }
            resources.add((Resource)new FilesystemResource(internal.getAbsolutePath()));
            resources.add((Resource)new FilesystemResource(services.getAbsolutePath()));
        }
        return resources;
    }

    private void initAttributeAuthority() {
        try {
            this.getGrouperSession();
            this.gContext = this.getApplicationContext();
            this.attributeAuthority = (AttributeAuthority)this.gContext.getBean("grouper.AttributeAuthority");
        }
        catch (NoSuchBeanDefinitionException e) {
            LOG.error("Unable to initialize the attribute authority", (Throwable)e);
            throw new LdappcException("Unable to initialize the attribute authority", e);
        }
    }

    public AttributeAuthority getAttributeAuthority() {
        return this.attributeAuthority;
    }

    private void initAttributeResolver() {
        try {
            this.getGrouperSession();
            this.gContext = this.getApplicationContext();
            this.attributeResolver = (ShibbolethAttributeResolver)this.gContext.getBean("grouper.AttributeResolver");
        }
        catch (NoSuchBeanDefinitionException e) {
            LOG.error("Unable to initialize the attribute authority", (Throwable)e);
            throw new LdappcException("Unable to initialize the attribute authority", e);
        }
    }

    public ShibbolethAttributeResolver getAttributeResolver() {
        return this.attributeResolver;
    }
}

