/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.ldappc;

import edu.internet2.middleware.grouper.SubjectFinder;
import edu.internet2.middleware.grouper.util.GrouperUtil;
import edu.internet2.middleware.ldappc.LdappcConfig;
import edu.internet2.middleware.ldappc.exception.ConfigurationException;
import edu.internet2.middleware.ldappc.exception.LdappcException;
import edu.internet2.middleware.ldappc.util.LdapSearchFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.opensaml.util.resource.PropertyReplacementResourceFilter;
import org.opensaml.util.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigManager
implements LdappcConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    public static final String CONFIG_FILE_RESOURCE = "ldappc.xml";
    public static final String PROPERTIES_FILE_RESOURCE = "ldappc.properties";
    public static final String SCHEMA_FILE_RESOURCE = "schema/ldappc.schema.xsd";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String PROPERTY_USE_RANGE_HANDLER = "edu.internet2.middleware.ldappc.useRangeSearchResultHandler";
    private Vector saxParseErrors = new Vector();
    private Hashtable ldapContextParameters = new Hashtable();
    private Set groupSubordinateStemQueries = new HashSet();
    private Map groupAttrMatchingQueries = new Hashtable();
    private Set<String> groupResolverQueries = new HashSet<String>();
    private LdappcConfig.GroupDNStructure groupDnStructure;
    private String groupDnRoot;
    private String groupDnObjectClass;
    private String groupDnRdnAttribute;
    private String groupDnGrouperAttribute;
    private Set<String> groupAttributeMappingObjectClass;
    private Map<String, List<String>> groupAttributeMapping = new HashMap<String, List<String>>();
    private Map groupAttributeMappingLdapEmptyValues = new HashMap();
    private int groupHashEstimate;
    private Map sourceSubjectNamingAttributes = new Hashtable();
    private Map<String, LdapSearchFilter> sourceSubjectLdapFilters = new Hashtable<String, LdapSearchFilter>();
    private Map subjectHashEstimates = new Hashtable();
    private boolean memberGroupsListed;
    private String memberGroupsListObjectClass;
    private String memberGroupsListAttribute;
    private String memberGroupsListTemporaryDirectory;
    private String memberGroupsNamingAttribute;
    private boolean groupMembersDnListed;
    private String groupMembersDnListObjectClass;
    private String groupMembersDnListAttribute;
    private String groupMembersDnListEmptyValue;
    private boolean groupMembersNameListed;
    private String groupMembersNameListObjectClass;
    private String groupMembersNameListAttribute;
    private String groupMembersNameListEmptyValue;
    private Map groupMembersNameListNamingAttributes = new Hashtable();
    private boolean rootElementFound;
    private boolean createGroupsThenModifyMembers = false;
    private boolean provisionMemberGroups = true;
    private boolean provisionGroupsTwoStep = true;
    private boolean bundleModifications = true;
    private Set<String> attributeResolverMappingObjectClass;
    private Map<String, List<String>> attributeResolverMapping = new HashMap<String, List<String>>();
    private Map attributeResolverMappingLdapEmptyValues = new HashMap();
    private boolean useRangeSearchResultHandler = false;
    private boolean provisionMemberGroupsIgnoreQueries = false;

    public ConfigManager() throws ConfigurationException {
        this(null);
    }

    public ConfigManager(String pathToConfig) throws ConfigurationException {
        this(pathToConfig, null);
    }

    public ConfigManager(String pathToConfig, String pathToProperties) throws ConfigurationException {
        File propertiesFile;
        if (pathToConfig == null) {
            pathToConfig = ConfigManager.getSystemResourceURL(CONFIG_FILE_RESOURCE, true).getPath();
        }
        if (pathToProperties == null) {
            pathToProperties = ConfigManager.getSystemResourceURL(PROPERTIES_FILE_RESOURCE, true).getPath();
        }
        if (!(propertiesFile = new File(pathToProperties)).exists() || !propertiesFile.canRead()) {
            LOG.error("Unable to read properties file '" + pathToProperties + "'");
            throw new LdappcException("Unable to find properties file '" + pathToProperties + "'");
        }
        File configFile = new File(pathToConfig);
        if (!configFile.exists() || !configFile.canRead()) {
            LOG.error("Unable to read config file '" + pathToConfig + "'");
            throw new ConfigurationException("Unable to locate config file '" + pathToConfig + "'");
        }
        this.init(configFile, propertiesFile);
    }

    private void init(File config, File properties) throws ConfigurationException {
        Properties props;
        LOG.debug("reading configuration from '{}' and properties from '{}'", (Object)config, (Object)properties);
        Digester digester = this.buildDigester();
        digester.push((Object)new Broker());
        String elementPath = null;
        elementPath = "ldappc";
        digester.addRule(elementPath, (Rule)new CallMethodRule("foundRootElement"));
        digester.addRule(elementPath, (Rule)new CallMethodRule("validateSaxParsing"));
        digester.addRule(elementPath, (Rule)new CallMethodRule("validateValues"));
        elementPath = "ldappc/ldap/context/parameter-list/parameter";
        digester.addCallMethod(elementPath, "addLdapContextParameter", 2);
        digester.addCallParam(elementPath, 0, "name");
        digester.addCallParam(elementPath, 1, "value");
        elementPath = "ldappc/grouper/group-queries/subordinate-stem-queries/stem-list/stem";
        digester.addCallMethod(elementPath, "addGroupSubordinateStemQuery", 0);
        elementPath = "ldappc/grouper/group-queries/attribute-matching-queries/attribute-list/attribute";
        digester.addCallMethod(elementPath, "addGroupAttrMatchQuery", 2);
        digester.addCallParam(elementPath, 0, "name");
        digester.addCallParam(elementPath, 1, "value");
        elementPath = "ldappc/grouper/group-queries/resolver-matching-queries/data-connector-list/data-connector";
        digester.addCallMethod(elementPath, "addResolverQuery", 1);
        digester.addCallParam(elementPath, 0, "id");
        elementPath = "ldappc/source-subject-identifiers/source-subject-identifier";
        digester.addCallMethod(elementPath, "addSourceSubjectNamingAttribute", 2);
        digester.addCallParam(elementPath, 0, "source");
        digester.addCallParam(elementPath, 1, "subject-attribute");
        elementPath = "ldappc/source-subject-identifiers/source-subject-identifier";
        digester.addCallMethod(elementPath, "addSubjectHashEstimate", 2);
        digester.addCallParam(elementPath, 0, "source");
        digester.addCallParam(elementPath, 1, "initial-cache-size");
        elementPath = "ldappc/source-subject-identifiers/source-subject-identifier";
        digester.addCallMethod(elementPath, "addSourceSubjectLdapFilter", 6);
        digester.addCallParam(elementPath, 0, "source");
        elementPath = "ldappc/source-subject-identifiers/source-subject-identifier/ldap-search";
        digester.addCallParam(elementPath, 1, "base");
        digester.addCallParam(elementPath, 2, "scope");
        digester.addCallParam(elementPath, 3, "filter");
        digester.addCallParam(elementPath, 4, "on-not-found");
        digester.addCallParam(elementPath, 5, "multiple-results");
        elementPath = "ldappc/grouper/groups";
        digester.addCallMethod(elementPath, "setGroupDnStructure", 1);
        digester.addCallParam(elementPath, 0, "structure");
        digester.addCallMethod(elementPath, "setGroupDnRoot", 1);
        digester.addCallParam(elementPath, 0, "root-dn");
        digester.addCallMethod(elementPath, "setGroupDnObjectClass", 1);
        digester.addCallParam(elementPath, 0, "ldap-object-class");
        digester.addCallMethod(elementPath, "setGroupDnRdnAttribute", 1);
        digester.addCallParam(elementPath, 0, "ldap-rdn-attribute");
        digester.addCallMethod(elementPath, "setGroupDnGrouperAttribute", 1);
        digester.addCallParam(elementPath, 0, "grouper-attribute");
        digester.addCallMethod(elementPath, "setGroupHashEstimate", 1);
        digester.addCallParam(elementPath, 0, "initial-cache-size");
        digester.addCallMethod(elementPath, "setCreateGroupThenModifyMembers", 1);
        digester.addCallParam(elementPath, 0, "create-then-modify-members");
        digester.addCallMethod(elementPath, "setProvisionMemberGroups", 1);
        digester.addCallParam(elementPath, 0, "provision-member-groups");
        digester.addCallMethod(elementPath, "setProvisionMemberGroupsIgnoreQueries", 1);
        digester.addCallParam(elementPath, 0, "provision-member-groups-ignore-queries");
        digester.addCallMethod(elementPath, "setProvisionGroupsTwoStep", 1);
        digester.addCallParam(elementPath, 0, "provision-groups-two-step");
        digester.addCallMethod(elementPath, "setBundleModifications", 1);
        digester.addCallParam(elementPath, 0, "bundle-modifications");
        elementPath = "ldappc/grouper/memberships/member-groups-list";
        digester.addCallMethod(elementPath, "listMemberGroups");
        digester.addCallMethod(elementPath, "setMemberGroupsListObjectClass", 1);
        digester.addCallParam(elementPath, 0, "list-object-class");
        digester.addCallMethod(elementPath, "setMemberGroupsListAttribute", 1);
        digester.addCallParam(elementPath, 0, "list-attribute");
        digester.addCallMethod(elementPath, "setMemberGroupsNamingAttribute", 1);
        digester.addCallParam(elementPath, 0, "naming-attribute");
        digester.addCallMethod(elementPath, "setMemberGroupsListTemporaryDirectory", 1);
        digester.addCallParam(elementPath, 0, "temporary-directory");
        elementPath = "ldappc/grouper/groups/group-members-dn-list";
        digester.addCallMethod(elementPath, "listGroupMembersDn");
        digester.addCallMethod(elementPath, "setGroupMembersDnListObjectClass", 1);
        digester.addCallParam(elementPath, 0, "list-object-class");
        digester.addCallMethod(elementPath, "setGroupMembersDnListAttribute", 1);
        digester.addCallParam(elementPath, 0, "list-attribute");
        digester.addCallMethod(elementPath, "setGroupMembersDnListEmptyValue", 1);
        digester.addCallParam(elementPath, 0, "list-empty-value");
        elementPath = "ldappc/grouper/groups/group-members-name-list";
        digester.addCallMethod(elementPath, "listGroupMembersName");
        digester.addCallMethod(elementPath, "setGroupMembersNameListObjectClass", 1);
        digester.addCallParam(elementPath, 0, "list-object-class");
        digester.addCallMethod(elementPath, "setGroupMembersNameListAttribute", 1);
        digester.addCallParam(elementPath, 0, "list-attribute");
        digester.addCallMethod(elementPath, "setGroupMembersNameListEmptyValue", 1);
        digester.addCallParam(elementPath, 0, "list-empty-value");
        elementPath = "ldappc/grouper/groups/group-members-name-list/source-subject-name-mapping/source-subject-name-map";
        digester.addCallMethod(elementPath, "addGroupMembersNameListNamingAttribute", 2);
        digester.addCallParam(elementPath, 0, "source");
        digester.addCallParam(elementPath, 1, "subject-attribute");
        elementPath = "ldappc/grouper/groups/group-attribute-mapping";
        digester.addCallMethod(elementPath, "setGroupAttributeMappingObjectClass", 1);
        digester.addCallParam(elementPath, 0, "ldap-object-class");
        elementPath = "ldappc/grouper/groups/group-attribute-mapping/group-attribute-map";
        digester.addCallMethod(elementPath, "addGroupAttributeMapping", 2);
        digester.addCallParam(elementPath, 0, "group-attribute");
        digester.addCallParam(elementPath, 1, "ldap-attribute");
        elementPath = "ldappc/grouper/groups/group-attribute-mapping/group-attribute-map";
        digester.addCallMethod(elementPath, "addGroupAttributeMappingLdapEmptyValue", 2);
        digester.addCallParam(elementPath, 0, "ldap-attribute");
        digester.addCallParam(elementPath, 1, "ldap-attribute-empty-value");
        elementPath = "ldappc/grouper/groups/resolver-attribute-mapping";
        digester.addCallMethod(elementPath, "setAttributeResolverMappingObjectClass", 1);
        digester.addCallParam(elementPath, 0, "ldap-object-class");
        elementPath = "ldappc/grouper/groups/resolver-attribute-mapping/resolver-attribute-map";
        digester.addCallMethod(elementPath, "addAttributeResolverMapping", 2);
        digester.addCallParam(elementPath, 0, "resolver-attribute");
        digester.addCallParam(elementPath, 1, "ldap-attribute");
        elementPath = "ldappc/grouper/groups/resolver-attribute-mapping/resolver-attribute-map";
        digester.addCallMethod(elementPath, "addAttributeResolverMappingLdapEmptyValue", 2);
        digester.addCallParam(elementPath, 0, "ldap-attribute");
        digester.addCallParam(elementPath, 1, "ldap-attribute-empty-value");
        try {
            props = new Properties();
            props.load(new FileInputStream(properties));
            if (props.isEmpty()) {
                digester.parse(config);
            } else {
                PropertyReplacementResourceFilter prf = new PropertyReplacementResourceFilter(properties);
                digester.parse(prf.applyFilter((InputStream)new FileInputStream(config)));
            }
        }
        catch (SAXException se) {
            LOG.error("An error occurred", (Throwable)se);
            throw new ConfigurationException(se);
        }
        catch (IOException ioe) {
            LOG.error("An error occurred", (Throwable)ioe);
            throw new ConfigurationException(ioe);
        }
        catch (ResourceException e) {
            LOG.error("An error occurred", (Throwable)e);
            throw new ConfigurationException(e);
        }
        if (!this.isRootElementFound()) {
            throw new ConfigurationException("The ldappc element was not found in the configuration file.");
        }
        try {
            props = new Properties();
            props.load(new FileInputStream(properties));
            this.useRangeSearchResultHandler = GrouperUtil.propertiesValueBoolean((Properties)props, (String)PROPERTY_USE_RANGE_HANDLER, (boolean)false);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Unable to find the properties file.", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to read the properties file.", e);
        }
    }

    public Iterator listSaxParseErrors() {
        return this.saxParseErrors.iterator();
    }

    private void addSaxParseError(SAXParseException e) {
        this.saxParseErrors.add(e);
    }

    private void validateSaxParsing() throws ConfigurationException {
        if (this.saxParseErrors.size() == 1) {
            throw new ConfigurationException((SAXParseException)this.saxParseErrors.elementAt(0));
        }
        if (this.saxParseErrors.size() > 1) {
            throw new ConfigurationException("Multiple SAXParseExceptions generated while parsing the configuration file.  See error log for details.");
        }
    }

    private void validateValues() throws ConfigurationException {
        if (LdappcConfig.GroupDNStructure.flat.equals((Object)this.getGroupDnStructure()) && this.getGroupDnGrouperAttribute() == null) {
            throw new ConfigurationException("The grouper-attribute must be defined when the group dn structure is " + (Object)((Object)LdappcConfig.GroupDNStructure.flat));
        }
        if (this.getSourceSubjectNamingAttributes().containsKey(SubjectFinder.internal_getGSA().getId())) {
            throw new ConfigurationException("The source-subject-identifier for source '" + SubjectFinder.internal_getGSA().getId() + "' should be removed. This functionality has been replaced by the provision-member-groups attribute of the <groups /> element.");
        }
    }

    public static URL getSystemResourceURL(String resource, boolean isRequired) throws ConfigurationException {
        URL url = GrouperUtil.computeUrl((String)resource, (boolean)false);
        if (isRequired && url == null) {
            throw new ConfigurationException("Unable to locate required system resource: " + resource);
        }
        return url;
    }

    private Digester buildDigester() {
        Digester digester = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SAXParser parser = factory.newSAXParser();
            parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            parser.setProperty(JAXP_SCHEMA_SOURCE, ConfigManager.getSystemResourceURL(SCHEMA_FILE_RESOURCE, true).toString());
            digester = new Digester(parser);
            digester.setErrorHandler((ErrorHandler)new SaxErrorHandler());
        }
        catch (Exception se) {
            LOG.error("Schema validation not supported", (Throwable)se);
        }
        if (digester == null) {
            digester = new Digester();
        }
        return digester;
    }

    @Override
    public Hashtable getLdapContextParameters() {
        return new Hashtable(this.ldapContextParameters);
    }

    private void addLdapContextParameter(String name, String value) {
        try {
            Field constant = LdapContext.class.getField(name.toUpperCase());
            name = (String)constant.get(LdapContext.class);
        }
        catch (Exception e) {
            LOG.debug("{} is not a valid javax.naming.ldap.LdapContext constant.", (Object)name);
        }
        this.ldapContextParameters.put(name, value);
    }

    @Override
    public Map getGroupAttrMatchingQueries() {
        return new Hashtable(this.groupAttrMatchingQueries);
    }

    private void addGroupAttrMatchQuery(String name, String value) {
        if (!this.groupAttrMatchingQueries.containsKey(name)) {
            this.groupAttrMatchingQueries.put(name, new HashSet());
        }
        Set values = (Set)this.groupAttrMatchingQueries.get(name);
        values.add(value);
    }

    @Override
    public Set getGroupSubordinateStemQueries() {
        return new HashSet(this.groupSubordinateStemQueries);
    }

    public void resetGroupSubordinateStemQueries() {
        this.groupSubordinateStemQueries = new HashSet();
    }

    private void addGroupSubordinateStemQuery(String stem) {
        this.groupSubordinateStemQueries.add(stem);
    }

    @Override
    public LdappcConfig.GroupDNStructure getGroupDnStructure() {
        return this.groupDnStructure;
    }

    private void setGroupDnStructure(String structure) {
        this.groupDnStructure = LdappcConfig.GroupDNStructure.valueOf(structure);
    }

    protected void setGroupDnStructure(LdappcConfig.GroupDNStructure structure) {
        this.groupDnStructure = structure;
    }

    @Override
    public String getGroupDnRoot() {
        return this.groupDnRoot;
    }

    private void setGroupDnRoot(String root) {
        this.groupDnRoot = root;
    }

    @Override
    public String getGroupDnObjectClass() {
        return this.groupDnObjectClass;
    }

    private void setGroupDnObjectClass(String objectClass) {
        this.groupDnObjectClass = objectClass;
    }

    @Override
    public String getGroupDnRdnAttribute() {
        return this.groupDnRdnAttribute;
    }

    private void setGroupDnRdnAttribute(String attribute) {
        this.groupDnRdnAttribute = attribute;
    }

    @Override
    public String getGroupDnGrouperAttribute() {
        return this.groupDnGrouperAttribute;
    }

    private void setGroupDnGrouperAttribute(String attribute) {
        this.groupDnGrouperAttribute = attribute;
    }

    @Override
    public Set<String> getGroupAttributeMappingObjectClass() {
        return this.groupAttributeMappingObjectClass;
    }

    private void setGroupAttributeMappingObjectClass(String objectClass) {
        List list = GrouperUtil.splitTrimToList((String)objectClass, (String)" ");
        if (list != null) {
            this.setGroupAttributeMappingObjectClass(new LinkedHashSet<String>(list));
        }
    }

    private void setGroupAttributeMappingObjectClass(Set<String> objectClass) {
        this.groupAttributeMappingObjectClass = objectClass;
    }

    public Map getGroupAttributeMapping() {
        return new Hashtable<String, List<String>>(this.groupAttributeMapping);
    }

    private void addGroupAttributeMapping(String groupAttribute, String ldapAttribute) {
        if (!this.groupAttributeMapping.containsKey(groupAttribute)) {
            this.groupAttributeMapping.put(groupAttribute, new ArrayList());
        }
        this.groupAttributeMapping.get(groupAttribute).add(ldapAttribute);
    }

    private void addGroupAttributeMappingLdapEmptyValue(String ldapAttribute, String value) {
        this.groupAttributeMappingLdapEmptyValues.put(this.convertToUpperCase(ldapAttribute), value);
    }

    @Override
    public String getGroupAttributeMappingLdapEmptyValue(String ldapAttribute) {
        return (String)this.groupAttributeMappingLdapEmptyValues.get(this.convertToUpperCase(ldapAttribute));
    }

    private String convertToUpperCase(String value) {
        return value == null ? value : value.toUpperCase();
    }

    @Override
    public Map getSourceSubjectNamingAttributes() {
        return new Hashtable(this.sourceSubjectNamingAttributes);
    }

    @Override
    public String getSourceSubjectNamingAttribute(String source) {
        String value = null;
        if (this.sourceSubjectNamingAttributes.containsKey(source)) {
            value = (String)this.sourceSubjectNamingAttributes.get(source);
        }
        return value;
    }

    private void addSourceSubjectNamingAttribute(String source, String attribute) {
        this.sourceSubjectNamingAttributes.put(source, attribute);
    }

    @Override
    public Map<String, LdapSearchFilter> getSourceSubjectLdapFilters() {
        return new Hashtable<String, LdapSearchFilter>(this.sourceSubjectLdapFilters);
    }

    public void addSubjectHashEstimate(String source, int size) {
        this.subjectHashEstimates.put(source, size);
    }

    @Override
    public Map<String, Integer> getSourceSubjectHashEstimates() {
        return this.subjectHashEstimates;
    }

    @Override
    public int getSourceSubjectHashEstimate(String source) {
        return (Integer)this.subjectHashEstimates.get(source);
    }

    @Override
    public LdapSearchFilter getSourceSubjectLdapFilter(String source) {
        LdapSearchFilter value = null;
        if (this.sourceSubjectLdapFilters.containsKey(source)) {
            value = this.sourceSubjectLdapFilters.get(source);
        }
        return value;
    }

    public void setGroupHashEstimate(int size) {
        this.groupHashEstimate = size;
    }

    @Override
    public int getGroupHashEstimate() {
        return this.groupHashEstimate;
    }

    private void addSourceSubjectLdapFilter(String source, String base, String scope, String filter, String onNotFound, String multipleResults) throws ConfigurationException {
        int scopeValue = -1;
        try {
            Field constant = SearchControls.class.getField(scope.toUpperCase());
            scopeValue = (Integer)constant.get(SearchControls.class);
        }
        catch (Throwable t) {
            throw new ConfigurationException(t);
        }
        LdapSearchFilter ldapFilter = new LdapSearchFilter(base, scopeValue, filter, LdapSearchFilter.OnNotFound.valueOf(onNotFound), Boolean.parseBoolean(multipleResults));
        this.sourceSubjectLdapFilters.put(source, ldapFilter);
    }

    @Override
    public boolean isMemberGroupsListed() {
        return this.memberGroupsListed;
    }

    private void setMemberGroupsListed(boolean listed) {
        this.memberGroupsListed = listed;
    }

    private void setMemberGroupsListObjectClass(String objectClass) {
        this.memberGroupsListObjectClass = objectClass;
    }

    @Override
    public String getMemberGroupsListObjectClass() {
        return this.memberGroupsListObjectClass;
    }

    @Override
    public String getMemberGroupsListAttribute() {
        return this.memberGroupsListAttribute;
    }

    private void setMemberGroupsListAttribute(String attribute) {
        this.memberGroupsListAttribute = attribute;
    }

    @Override
    public String getMemberGroupsNamingAttribute() {
        return this.memberGroupsNamingAttribute;
    }

    private void setMemberGroupsNamingAttribute(String attribute) {
        this.memberGroupsNamingAttribute = attribute;
    }

    @Override
    public String getMemberGroupsListTemporaryDirectory() {
        return this.memberGroupsListTemporaryDirectory;
    }

    private void setMemberGroupsListTemporaryDirectory(String value) {
        this.memberGroupsListTemporaryDirectory = value;
    }

    @Override
    public boolean isGroupMembersDnListed() {
        return this.groupMembersDnListed;
    }

    private void setGroupMembersDnListed(boolean listed) {
        this.groupMembersDnListed = listed;
    }

    private void setGroupMembersDnListObjectClass(String objectClass) {
        this.groupMembersDnListObjectClass = objectClass;
    }

    @Override
    public String getGroupMembersDnListObjectClass() {
        return this.groupMembersDnListObjectClass;
    }

    @Override
    public String getGroupMembersDnListAttribute() {
        return this.groupMembersDnListAttribute;
    }

    private void setGroupMembersDnListAttribute(String attribute) {
        this.groupMembersDnListAttribute = attribute;
    }

    @Override
    public String getGroupMembersDnListEmptyValue() {
        return this.groupMembersDnListEmptyValue;
    }

    private void setGroupMembersDnListEmptyValue(String value) {
        this.groupMembersDnListEmptyValue = value;
    }

    @Override
    public boolean isGroupMembersNameListed() {
        return this.groupMembersNameListed;
    }

    private void setGroupMembersNameListed(boolean listed) {
        this.groupMembersNameListed = listed;
    }

    private void setGroupMembersNameListObjectClass(String objectClass) {
        this.groupMembersNameListObjectClass = objectClass;
    }

    @Override
    public String getGroupMembersNameListObjectClass() {
        return this.groupMembersNameListObjectClass;
    }

    @Override
    public String getGroupMembersNameListAttribute() {
        return this.groupMembersNameListAttribute;
    }

    private void setGroupMembersNameListAttribute(String attribute) {
        this.groupMembersNameListAttribute = attribute;
    }

    @Override
    public String getGroupMembersNameListEmptyValue() {
        return this.groupMembersNameListEmptyValue;
    }

    private void setGroupMembersNameListEmptyValue(String value) {
        this.groupMembersNameListEmptyValue = value;
    }

    @Override
    public String getGroupMembersNameListNamingAttribute(String source) {
        String subjectAttribute = null;
        if (this.groupMembersNameListNamingAttributes.containsKey(source)) {
            subjectAttribute = (String)this.groupMembersNameListNamingAttributes.get(source);
        }
        return subjectAttribute;
    }

    @Override
    public Map getGroupMembersNameListNamingAttributes() {
        return new Hashtable(this.groupMembersNameListNamingAttributes);
    }

    private void addGroupMembersNameListNamingAttribute(String source, String subjectAttribute) {
        this.groupMembersNameListNamingAttributes.put(source, subjectAttribute);
    }

    public boolean isRootElementFound() {
        return this.rootElementFound;
    }

    private void setRootElementFound(boolean found) {
        this.rootElementFound = found;
    }

    @Override
    public boolean getCreateGroupThenModifyMembers() {
        return this.createGroupsThenModifyMembers;
    }

    private void setCreateGroupThenModifyMembers(String string) {
        this.createGroupsThenModifyMembers = Boolean.parseBoolean(string);
    }

    @Override
    public boolean getProvisionMemberGroups() {
        return this.provisionMemberGroups;
    }

    private void setProvisionMemberGroups(String string) {
        this.provisionMemberGroups = Boolean.parseBoolean(string);
    }

    protected void setProvisionMemberGroups(Boolean provisionMemberGroups) {
        this.provisionMemberGroups = provisionMemberGroups;
    }

    @Override
    public boolean getProvisionGroupsTwoStep() {
        return this.provisionGroupsTwoStep;
    }

    private void setProvisionGroupsTwoStep(String string) {
        this.provisionGroupsTwoStep = Boolean.parseBoolean(string);
    }

    protected void setProvisionGroupsTwoStep(Boolean provisionGroupsTwoStep) {
        this.provisionGroupsTwoStep = provisionGroupsTwoStep;
    }

    @Override
    public boolean getBundleModifications() {
        return this.bundleModifications;
    }

    private void setBundleModifications(String string) {
        this.bundleModifications = Boolean.parseBoolean(string);
    }

    protected void setBundleModifications(Boolean bundleModifications) {
        this.bundleModifications = bundleModifications;
    }

    @Override
    public Map<String, List<String>> getAttributeResolverMapping() {
        return new Hashtable<String, List<String>>(this.attributeResolverMapping);
    }

    private void addAttributeResolverMapping(String resolverAttribute, String ldapAttribute) {
        if (!this.attributeResolverMapping.containsKey(resolverAttribute)) {
            this.attributeResolverMapping.put(resolverAttribute, new ArrayList());
        }
        this.attributeResolverMapping.get(resolverAttribute).add(ldapAttribute);
    }

    @Override
    public String getAttributeResolverMappingLdapEmptyValue(String ldapAttribute) {
        return (String)this.attributeResolverMappingLdapEmptyValues.get(this.convertToUpperCase(ldapAttribute));
    }

    private void addAttributeResolverMappingLdapEmptyValue(String ldapAttribute, String value) {
        this.attributeResolverMappingLdapEmptyValues.put(this.convertToUpperCase(ldapAttribute), value);
    }

    @Override
    public Set<String> getAttributeResolverMappingObjectClass() {
        return this.attributeResolverMappingObjectClass;
    }

    private void setAttributeResolverMappingObjectClass(String objectClass) {
        List list = GrouperUtil.splitTrimToList((String)objectClass, (String)" ");
        if (list != null) {
            this.setAttributeResolverMappingObjectClass(new LinkedHashSet<String>(list));
        }
    }

    private void setAttributeResolverMappingObjectClass(Set<String> objectClass) {
        this.attributeResolverMappingObjectClass = objectClass;
    }

    @Override
    public boolean useRangeSearchResultHandler() {
        return this.useRangeSearchResultHandler;
    }

    @Override
    public boolean getProvisionMemberGroupsIgnoreQueries() {
        return this.provisionMemberGroupsIgnoreQueries;
    }

    private void setProvisionMemberGroupsIgnoreQueries(String string) {
        this.provisionMemberGroupsIgnoreQueries = Boolean.parseBoolean(string);
    }

    protected void setProvisionMemberGroupsIgnoreQueries(Boolean provisionMemberGroupsIgnoreQueries) {
        this.provisionMemberGroupsIgnoreQueries = provisionMemberGroupsIgnoreQueries;
    }

    @Override
    public Set<String> getResolverQueries() {
        return this.groupResolverQueries;
    }

    private void addResolverQuery(String id) {
        this.groupResolverQueries.add(id);
    }

    private class SaxErrorHandler
    implements ErrorHandler {
        private SaxErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            LOG.error(this.formatMsg(e));
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            LOG.error(this.formatMsg(e));
            ConfigManager.this.addSaxParseError(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException, ConfigurationException {
            LOG.error(this.formatMsg(e));
            ConfigManager.this.addSaxParseError(e);
            throw new ConfigurationException(e);
        }

        protected String formatMsg(SAXParseException e) {
            return "[ " + e.getLineNumber() + " : " + e.getColumnNumber() + " ] :: " + e.getMessage();
        }
    }

    private class Broker {
        private Broker() {
        }

        public void foundRootElement() {
            ConfigManager.this.setRootElementFound(true);
        }

        public void validateSaxParsing() throws ConfigurationException {
            ConfigManager.this.validateSaxParsing();
        }

        public void validateValues() throws ConfigurationException {
            ConfigManager.this.validateValues();
        }

        public void addLdapContextParameter(String name, String value) {
            ConfigManager.this.addLdapContextParameter(name, value);
        }

        public void addGroupAttrMatchQuery(String name, String value) {
            ConfigManager.this.addGroupAttrMatchQuery(name, value);
        }

        public void addGroupSubordinateStemQuery(String stem) {
            ConfigManager.this.addGroupSubordinateStemQuery(stem);
        }

        public void setGroupDnStructure(String structure) {
            ConfigManager.this.setGroupDnStructure(structure);
        }

        public void setGroupDnRoot(String root) {
            ConfigManager.this.setGroupDnRoot(root);
        }

        public void setGroupDnObjectClass(String objectClass) {
            ConfigManager.this.setGroupDnObjectClass(objectClass);
        }

        public void setGroupDnRdnAttribute(String attribute) {
            ConfigManager.this.setGroupDnRdnAttribute(attribute);
        }

        public void setGroupDnGrouperAttribute(String attribute) {
            ConfigManager.this.setGroupDnGrouperAttribute(attribute);
        }

        public void setGroupAttributeMappingObjectClass(String objectClass) {
            ConfigManager.this.setGroupAttributeMappingObjectClass(objectClass);
        }

        public void setGroupHashEstimate(String sizeString) {
            ConfigManager.this.setGroupHashEstimate(Integer.parseInt(sizeString));
        }

        public void addGroupAttributeMapping(String groupAttribute, String ldapAttribute) {
            ConfigManager.this.addGroupAttributeMapping(groupAttribute, ldapAttribute);
        }

        public void addGroupAttributeMappingLdapEmptyValue(String ldapAttribute, String value) {
            ConfigManager.this.addGroupAttributeMappingLdapEmptyValue(ldapAttribute, value);
        }

        public void addSourceSubjectNamingAttribute(String source, String attribute) {
            ConfigManager.this.addSourceSubjectNamingAttribute(source, attribute);
        }

        public void addSourceSubjectLdapFilter(String source, String base, String scope, String filter, String onNotFound, String multipleResults) throws ConfigurationException {
            ConfigManager.this.addSourceSubjectLdapFilter(source, base, scope, filter, onNotFound, multipleResults);
        }

        public void addSubjectHashEstimate(String source, String sizeString) {
            int size = 0;
            if (sizeString != null && sizeString.length() > 0) {
                size = Integer.parseInt(sizeString);
            }
            ConfigManager.this.addSubjectHashEstimate(source, size);
        }

        public void listMemberGroups() {
            ConfigManager.this.setMemberGroupsListed(true);
        }

        public void setMemberGroupsListObjectClass(String objectClass) {
            ConfigManager.this.setMemberGroupsListObjectClass(objectClass);
        }

        public void setMemberGroupsListAttribute(String attribute) {
            ConfigManager.this.setMemberGroupsListAttribute(attribute);
        }

        public void setMemberGroupsNamingAttribute(String attribute) {
            ConfigManager.this.setMemberGroupsNamingAttribute(attribute);
        }

        public void setMemberGroupsListTemporaryDirectory(String value) {
            ConfigManager.this.setMemberGroupsListTemporaryDirectory(value);
        }

        public void listGroupMembersDn() {
            ConfigManager.this.setGroupMembersDnListed(true);
        }

        public void setGroupMembersDnListObjectClass(String objectClass) {
            ConfigManager.this.setGroupMembersDnListObjectClass(objectClass);
        }

        public void setGroupMembersDnListAttribute(String attribute) {
            ConfigManager.this.setGroupMembersDnListAttribute(attribute);
        }

        public void setGroupMembersDnListEmptyValue(String value) {
            ConfigManager.this.setGroupMembersDnListEmptyValue(value);
        }

        public void listGroupMembersName() {
            ConfigManager.this.setGroupMembersNameListed(true);
        }

        public void setGroupMembersNameListObjectClass(String objectClass) {
            ConfigManager.this.setGroupMembersNameListObjectClass(objectClass);
        }

        public void setGroupMembersNameListAttribute(String attribute) {
            ConfigManager.this.setGroupMembersNameListAttribute(attribute);
        }

        public void setGroupMembersNameListEmptyValue(String value) {
            ConfigManager.this.setGroupMembersNameListEmptyValue(value);
        }

        public void addGroupMembersNameListNamingAttribute(String source, String subjectAttribute) {
            ConfigManager.this.addGroupMembersNameListNamingAttribute(source, subjectAttribute);
        }

        public void setCreateGroupThenModifyMembers(String string) {
            ConfigManager.this.setCreateGroupThenModifyMembers(string);
        }

        public void setProvisionMemberGroups(String string) {
            ConfigManager.this.setProvisionMemberGroups(string);
        }

        public void setProvisionGroupsTwoStep(String string) {
            ConfigManager.this.setProvisionGroupsTwoStep(string);
        }

        public void setBundleModifications(String string) {
            ConfigManager.this.setBundleModifications(string);
        }

        public void addAttributeResolverMapping(String resolverAttribute, String ldapAttribute) {
            ConfigManager.this.addAttributeResolverMapping(resolverAttribute, ldapAttribute);
        }

        public void addAttributeResolverMappingLdapEmptyValue(String ldapAttribute, String value) {
            ConfigManager.this.addAttributeResolverMappingLdapEmptyValue(ldapAttribute, value);
        }

        public void setAttributeResolverMappingObjectClass(String objectClass) {
            ConfigManager.this.setAttributeResolverMappingObjectClass(objectClass);
        }

        public void setProvisionMemberGroupsIgnoreQueries(String string) {
            ConfigManager.this.setProvisionMemberGroupsIgnoreQueries(string);
        }

        public void addResolverQuery(String id) {
            ConfigManager.this.addResolverQuery(id);
        }
    }
}

