/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector.config;

import edu.internet2.middleware.grouper.shibboleth.dataConnector.SPMLDataConnector;
import edu.internet2.middleware.ldappc.spml.provider.SpmlProvider;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorFactoryBean;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spmlsearch.Scope;

public class SPMLDataConnectorFactoryBean
extends BaseDataConnectorFactoryBean {
    private TemplateEngine templateEngine;
    private String base;
    private String filterTemplate;
    private SpmlProvider provider;
    private ReturnData returnData;
    private Scope scope;
    private CacheManager cacheManager;
    private int maximumCachedElements;
    private long cacheElementTtl;

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    public void setFilterTemplate(String filterTemplate) {
        this.filterTemplate = filterTemplate;
    }

    public SpmlProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SpmlProvider provider) {
        this.provider = provider;
    }

    public ReturnData getReturnData() {
        return this.returnData;
    }

    public void setReturnData(ReturnData returnData) {
        this.returnData = returnData;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public long getCacheElementTimeToLive() {
        return this.cacheElementTtl;
    }

    public void setCacheElementTimeToLive(long ttl) {
        this.cacheElementTtl = ttl;
    }

    public int getMaximumCachedElements() {
        return this.maximumCachedElements;
    }

    public void setMaximumCachedElements(int max) {
        this.maximumCachedElements = max;
    }

    protected Object createInstance() throws Exception {
        Cache resultsCache = null;
        if (this.cacheManager != null && (resultsCache = this.cacheManager.getCache(this.getPluginId())) == null) {
            long ttlInSeconds = this.cacheElementTtl / 1000L;
            resultsCache = new Cache(this.getPluginId(), this.maximumCachedElements, false, false, ttlInSeconds, ttlInSeconds);
            this.cacheManager.addCache(resultsCache);
        }
        SPMLDataConnector connector = new SPMLDataConnector(resultsCache);
        this.populateDataConnector(connector);
        connector.setBase(this.base);
        connector.setFilterTemplate(this.filterTemplate);
        connector.setProvider(this.provider);
        connector.setReturnData(this.returnData);
        connector.setScope(this.scope);
        connector.setTemplateEngine(this.templateEngine);
        connector.initialize();
        return connector;
    }

    public Class getObjectType() {
        return SPMLDataConnector.class;
    }
}

