/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector.config;

import edu.internet2.middleware.grouper.shibboleth.dataConnector.config.SPMLDataConnectorFactoryBean;
import edu.internet2.middleware.shibboleth.common.config.SpringConfigurationUtils;
import edu.internet2.middleware.shibboleth.common.config.attribute.resolver.dataConnector.BaseDataConnectorBeanDefinitionParser;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.util.BasicStringEnumConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SPMLDataConnectorBeanDefinitionParser
extends BaseDataConnectorBeanDefinitionParser {
    private final Logger LOG = LoggerFactory.getLogger(SPMLDataConnectorBeanDefinitionParser.class);
    public static final QName TYPE_NAME = new QName("http://grouper.internet2.edu/ldappc", "SPMLDataConnector");
    public static final QName FILTER_ELEMENT_NAME = new QName("http://grouper.internet2.edu/ldappc", "FilterTemplate");

    protected Class<?> getBeanClass(Element element) {
        return SPMLDataConnectorFactoryBean.class;
    }

    protected void doParse(String pluginId, Element pluginConfig, Map<QName, List<Element>> pluginConfigChildren, BeanDefinitionBuilder pluginBuilder, ParserContext parserContext) {
        super.doParse(pluginId, pluginConfig, pluginConfigChildren, pluginBuilder, parserContext);
        String base = pluginConfig.getAttributeNS(null, "base");
        this.LOG.debug("Data connector {} base: {}", (Object)pluginId, (Object)base);
        pluginBuilder.addPropertyValue("base", (Object)base);
        String returnDataString = pluginConfig.getAttributeNS(null, "returnData");
        this.LOG.debug("Data connector {} returnData: {}", (Object)pluginId, (Object)returnDataString);
        ReturnData returnData = (ReturnData)BasicStringEnumConstant.getConstant(ReturnData.class, (String)returnDataString);
        pluginBuilder.addPropertyValue("returnData", (Object)returnData);
        String scopeString = pluginConfig.getAttributeNS(null, "scope");
        this.LOG.debug("Data connector {} scope: {}", (Object)pluginId, (Object)scopeString);
        Scope scope = (Scope)BasicStringEnumConstant.getConstant(Scope.class, (String)scopeString);
        pluginBuilder.addPropertyValue("scope", (Object)scope);
        String provider = pluginConfig.getAttributeNS(null, "provider");
        this.LOG.debug("Data connector {} provider: {}", (Object)pluginId, (Object)provider);
        pluginBuilder.addPropertyReference("provider", provider);
        String filterTemplate = pluginConfigChildren.get(FILTER_ELEMENT_NAME).get(0).getTextContent();
        filterTemplate = DatatypeHelper.safeTrimOrNullString((String)filterTemplate);
        this.LOG.debug("Data connector {} LDAP filter template: {}", (Object)pluginId, (Object)filterTemplate);
        pluginBuilder.addPropertyValue("filterTemplate", (Object)filterTemplate);
        String templateEngineRef = pluginConfig.getAttributeNS(null, "templateEngine");
        pluginBuilder.addPropertyReference("templateEngine", templateEngineRef);
        this.processCacheConfig(pluginId, pluginConfig, pluginBuilder);
    }

    protected void processCacheConfig(String pluginId, Element pluginConfig, BeanDefinitionBuilder pluginBuilder) {
        boolean cacheResults = false;
        String cacheManagerId = "shibboleth.CacheManager";
        long cacheElementTtl = 14400000L;
        int maximumCachedElements = 500;
        List cacheConfigs = XMLHelper.getChildElementsByTagNameNS((Element)pluginConfig, (String)"http://grouper.internet2.edu/ldappc", (String)"ResultCache");
        if (cacheConfigs != null && !cacheConfigs.isEmpty()) {
            Element cacheConfig = (Element)cacheConfigs.get(0);
            cacheResults = true;
            if (cacheConfig.hasAttributeNS(null, "cacheManagerRef")) {
                cacheManagerId = DatatypeHelper.safeTrim((String)cacheConfig.getAttributeNS(null, "cacheManagerRef"));
            }
            if (cacheConfig.hasAttributeNS(null, "elementTimeToLive")) {
                cacheElementTtl = SpringConfigurationUtils.parseDurationToMillis((String)("elementTimeToLive on data connector " + pluginId), (String)cacheConfig.getAttributeNS(null, "elementTimeToLive"), (int)0);
            }
            if (cacheConfig.hasAttributeNS(null, "maximumCachedElements")) {
                maximumCachedElements = Integer.parseInt(DatatypeHelper.safeTrim((String)cacheConfig.getAttributeNS(null, "maximumCachedElements")));
            }
        }
        if (pluginConfig.hasAttributeNS(null, "cacheResults")) {
            this.LOG.warn("Data connection {}: use of 'cacheResults' attribute is deprecated.  Use <ResultCache> instead.", (Object)pluginId);
            cacheResults = XMLHelper.getAttributeValueAsBoolean((Attr)pluginConfig.getAttributeNodeNS(null, "cacheResults"));
        }
        if (cacheResults) {
            this.LOG.debug("Data connector {} is caching results: {}", (Object)pluginId, (Object)cacheResults);
            pluginBuilder.addPropertyReference("cacheManager", cacheManagerId);
            this.LOG.debug("Data connector {} cache element time to live: {}ms", (Object)pluginId, (Object)cacheElementTtl);
            pluginBuilder.addPropertyValue("cacheElementTimeToLive", (Object)cacheElementTtl);
            this.LOG.debug("Data connector {} maximum number of caches elements: {}", (Object)pluginId, (Object)maximumCachedElements);
            pluginBuilder.addPropertyValue("maximumCachedElements", (Object)maximumCachedElements);
        }
    }
}

