/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.dataConnector;

import edu.internet2.middleware.ldappc.spml.PSP;
import edu.internet2.middleware.ldappc.spml.provider.SpmlProvider;
import edu.internet2.middleware.ldappc.spml.request.LdapFilterQueryClause;
import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ResolutionPlugIn;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.AttributeDefinition;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.BaseDataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.DataConnector;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.dataConnector.TemplateEngine;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.openspml.v2.msg.spml.ErrorCode;
import org.openspml.v2.msg.spml.Extensible;
import org.openspml.v2.msg.spml.PSO;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.openspml.v2.msg.spml.QueryClause;
import org.openspml.v2.msg.spml.Request;
import org.openspml.v2.msg.spml.Response;
import org.openspml.v2.msg.spml.ReturnData;
import org.openspml.v2.msg.spml.StatusCode;
import org.openspml.v2.msg.spmlref.Reference;
import org.openspml.v2.msg.spmlsearch.Query;
import org.openspml.v2.msg.spmlsearch.Scope;
import org.openspml.v2.msg.spmlsearch.SearchRequest;
import org.openspml.v2.msg.spmlsearch.SearchResponse;
import org.openspml.v2.profiles.dsml.DSMLAttr;
import org.openspml.v2.profiles.dsml.DSMLValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPMLDataConnector
extends BaseDataConnector {
    private static final Logger LOG = LoggerFactory.getLogger(SPMLDataConnector.class);
    public static final String PRINCIPAL = "${principal}";
    private String base;
    private SpmlProvider provider;
    private ReturnData returnData;
    private Scope scope;
    private TemplateEngine filterCreator;
    private String filterTemplateName;
    private String filterTemplate;
    private Cache resultsCache;
    public final String ID_ATTRIBUTE = "psoID";

    public SPMLDataConnector(Cache cache) {
        this.resultsCache = cache;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public TemplateEngine getTemplateEngine() {
        return this.filterCreator;
    }

    public void setTemplateEngine(TemplateEngine filterCreator) {
        this.filterCreator = filterCreator;
        this.registerTemplate();
    }

    public String getFilterTemplate() {
        return this.filterTemplate;
    }

    public void setFilterTemplate(String filterTemplate) {
        this.filterTemplate = filterTemplate;
    }

    public SpmlProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SpmlProvider provider) {
        this.provider = provider;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public ReturnData getReturnData() {
        return this.returnData;
    }

    public void setReturnData(ReturnData returnData) {
        this.returnData = returnData;
    }

    public void initialize() {
    }

    protected void registerTemplate() {
        this.filterTemplateName = "grouper.dc.spml." + this.getId();
        this.filterCreator.registerTemplate(this.filterTemplateName, this.filterTemplate);
    }

    public Map<String, BaseAttribute> resolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String principalName = resolutionContext.getAttributeRequestContext().getPrincipalName();
        String msg = "'" + principalName + "' dc '" + this.getId() + "'";
        LOG.debug("resolve {}", (Object)msg);
        if (LOG.isTraceEnabled()) {
            for (String attrId : resolutionContext.getAttributeRequestContext().getRequestedAttributesIds()) {
                LOG.trace("resolve {} requested attribute '{}'", (Object)msg, (Object)attrId);
            }
        }
        Map<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
        boolean hasDependencyValues = false;
        for (String dependencyId : this.getDependencyIds()) {
            ResolutionPlugIn plugin = (ResolutionPlugIn)resolutionContext.getResolvedPlugins().get(dependencyId);
            if (plugin instanceof DataConnector) {
                Map values = (Map)((DataConnector)plugin).resolve(resolutionContext);
                if (values.isEmpty()) continue;
                hasDependencyValues = true;
                break;
            }
            if (plugin instanceof AttributeDefinition) {
                BaseAttribute attribute = (BaseAttribute)((AttributeDefinition)plugin).resolve(resolutionContext);
                if (attribute.getValues().isEmpty()) continue;
                hasDependencyValues = true;
                break;
            }
            LOG.error("Unable to locate resolution plugin {}", (Object)dependencyId);
        }
        if (!hasDependencyValues) {
            LOG.debug("resolve {} no dependency values", (Object)msg);
            return attributes;
        }
        String filter = this.filterCreator.createStatement(this.filterTemplateName, resolutionContext, this.getDependencyIds(), (TemplateEngine.CharacterEscapingStrategy)new LDAPValueEscapingStrategy());
        LOG.debug("resolve {} search filter '{}'", (Object)msg, (Object)filter);
        if (filter.equals(this.filterTemplate)) {
            LOG.debug("resolve {} unable to evaluate filter template", (Object)msg);
            return attributes;
        }
        LdapFilterQueryClause filterQueryClause = new LdapFilterQueryClause();
        filterQueryClause.setFilter(filter);
        PSOIdentifier basePsoID = new PSOIdentifier();
        basePsoID.setID(this.getBase());
        Query query = new Query();
        query.setBasePsoID(basePsoID);
        query.addQueryClause((QueryClause)filterQueryClause);
        query.setScope(this.scope);
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setReturnData(this.returnData);
        searchRequest.setQuery(query);
        searchRequest.setRequestID(PSPUtil.uniqueRequestId());
        SearchRequest cacheRequest = new SearchRequest();
        cacheRequest.setReturnData(this.returnData);
        cacheRequest.setQuery(query);
        attributes = this.retrieveAttributesFromCache(cacheRequest);
        if (attributes == null) {
            attributes = this.retrieveAttributesFromTarget(searchRequest);
            this.cacheResult(cacheRequest, attributes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("resolve {} attributes {}", (Object)msg, (Object)attributes.size());
            for (String key : attributes.keySet()) {
                for (Object value : attributes.get(key).getValues()) {
                    LOG.debug("resolve {} '{}' : {}", new Object[]{msg, key, PSPUtil.getString(value)});
                }
            }
        }
        return attributes;
    }

    private void buildAttributes(Map<String, BaseAttribute> attributes, PSO pso) {
        Extensible data;
        if (!attributes.containsKey("psoID")) {
            attributes.put("psoID", (BaseAttribute)new BasicAttribute("psoID"));
        }
        attributes.get("psoID").getValues().add(pso.getPsoID());
        if (this.returnData.equals(ReturnData.DATA) && (data = pso.getData()) != null) {
            Map<String, DSMLAttr> dsmlAttrs = PSP.getDSMLAttrMap(data);
            for (DSMLAttr dsmlAttr : dsmlAttrs.values()) {
                if (!attributes.containsKey(dsmlAttr.getName())) {
                    attributes.put(dsmlAttr.getName(), (BaseAttribute)new BasicAttribute(dsmlAttr.getName()));
                }
                for (DSMLValue dsmlValue : dsmlAttr.getValues()) {
                    attributes.get(dsmlAttr.getName()).getValues().add(dsmlValue.getValue());
                }
            }
        }
        if (this.returnData.equals(ReturnData.EVERYTHING)) {
            Map<String, List<Reference>> references = PSP.getReferences(pso.getCapabilityData());
            for (String typeOfReference : references.keySet()) {
                if (!attributes.containsKey(typeOfReference)) {
                    attributes.put(typeOfReference, (BaseAttribute)new BasicAttribute(typeOfReference));
                }
                for (Reference reference : references.get(typeOfReference)) {
                    attributes.get(typeOfReference).getValues().add(reference.getToPsoID().getID());
                }
            }
        }
    }

    protected void cacheResult(SearchRequest searchRequest, Map<String, BaseAttribute> attributes) {
        if (this.resultsCache == null) {
            return;
        }
        LOG.debug("SPML data connector {} - Caching attributes from search '{}'", (Object)this.getId(), (Object)PSPUtil.toString(searchRequest));
        this.resultsCache.put(new Element((Object)searchRequest, attributes));
    }

    protected Map<String, BaseAttribute> retrieveAttributesFromCache(SearchRequest searchRequest) {
        if (this.resultsCache == null) {
            return null;
        }
        LOG.debug("SPML data connector {} - Checking cache for search results {}", (Object)this.getId(), (Object)PSPUtil.toString(searchRequest));
        Element cachedResult = this.resultsCache.get((Object)searchRequest);
        if (cachedResult != null && !cachedResult.isExpired()) {
            LOG.debug("SPML data connector {} - Returning attributes from cache {}", (Object)this.getId(), (Object)PSPUtil.toString(searchRequest));
            return (Map)cachedResult.getObjectValue();
        }
        LOG.debug("SPML data connector {} - No results cached for search filter '{}'", (Object)this.getId(), (Object)PSPUtil.toString(searchRequest));
        return null;
    }

    protected Map<String, BaseAttribute> retrieveAttributesFromTarget(SearchRequest searchRequest) throws AttributeResolutionException {
        String msg = "retrieve attributes from target";
        HashMap<String, BaseAttribute> attributes = new HashMap<String, BaseAttribute>();
        LOG.debug("{}", (Object)PSPUtil.toString(searchRequest));
        Response response = this.getProvider().execute((Request)searchRequest);
        LOG.debug("{}", (Object)PSPUtil.toString(response));
        if (!(response instanceof SearchResponse)) {
            LOG.error("resolve {} Unable to resolve attributes, expected a SearchResponse but received {}", (Object)msg, response.getClass());
            throw new AttributeResolutionException("Unable to resolve attributes, expected a SearchResponse");
        }
        SearchResponse searchResponse = (SearchResponse)response;
        if (response.getStatus().equals(StatusCode.FAILURE)) {
            LOG.error("Unable to resolve " + msg + " " + response.getError() + " " + Arrays.asList(response.getErrorMessages()));
            throw new AttributeResolutionException("Unable to resolve " + msg + " " + response.getError());
        }
        if (searchResponse.getStatus().equals(StatusCode.PENDING)) {
            LOG.error("Unable to resolve " + msg + " " + ErrorCode.UNSUPPORTED_EXECUTION_MODE);
            throw new AttributeResolutionException("Unable to resolve " + msg + " " + ErrorCode.UNSUPPORTED_EXECUTION_MODE);
        }
        if (searchResponse.getStatus().equals(StatusCode.SUCCESS)) {
            for (PSO pso : searchResponse.getPSOs()) {
                this.buildAttributes(attributes, pso);
            }
        }
        return attributes;
    }

    public void validate() throws AttributeResolutionException {
    }

    protected class LDAPValueEscapingStrategy
    implements TemplateEngine.CharacterEscapingStrategy {
        protected LDAPValueEscapingStrategy() {
        }

        public String escape(String value) {
            return value.replace("*", "\\*").replace("(", "\\(").replace(")", "\\)").replace("\\", "\\");
        }
    }
}

