/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouper.shibboleth.attributeDefinition;

import edu.internet2.middleware.ldappc.util.PSPUtil;
import edu.internet2.middleware.shibboleth.common.attribute.BaseAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.provider.BasicAttribute;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.AttributeResolutionException;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.ShibbolethResolutionContext;
import edu.internet2.middleware.shibboleth.common.attribute.resolver.provider.attributeDefinition.BaseAttributeDefinition;
import java.util.Arrays;
import java.util.Collection;
import org.openspml.v2.msg.spml.PSOIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSOIdentifierAttributeDefinition
extends BaseAttributeDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PSOIdentifierAttributeDefinition.class);

    protected BaseAttribute<PSOIdentifier> doResolve(ShibbolethResolutionContext resolutionContext) throws AttributeResolutionException {
        String principalName = resolutionContext.getAttributeRequestContext().getPrincipalName();
        String msg = "resolve '" + principalName + "' ad '" + this.getId() + "'";
        LOG.debug("{}", (Object)msg);
        BasicAttribute attribute = new BasicAttribute(this.getId());
        Collection values = this.getValuesFromAllDependencies(resolutionContext, this.getSourceAttributeID());
        if (values == null || values.isEmpty()) {
            return attribute;
        }
        if (values.size() != 1) {
            throw new AttributeResolutionException("Expected a single dependency.");
        }
        PSOIdentifier psoIdentifier = new PSOIdentifier();
        psoIdentifier.setID(values.iterator().next().toString());
        attribute.setValues(Arrays.asList(psoIdentifier));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} values {}", (Object)msg, (Object)attribute.getValues().size());
            for (PSOIdentifier value : attribute.getValues()) {
                LOG.debug("{} value '{}'", (Object)msg, (Object)PSPUtil.getString(value));
            }
        }
        return attribute;
    }

    public void validate() throws AttributeResolutionException {
    }
}

