/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class ServerEntryPropertyEditor
extends PropertyEditorSupport {
    public ServerEntryPropertyEditor() {
    }

    public ServerEntryPropertyEditor(Object source) {
        super(source);
    }

    public String getAsText() {
        Attributes attrs = (Attributes)this.getValue();
        try {
            return LdifUtils.convertToLdif((Attributes)attrs);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attributes readEntry(String text) {
        StringReader strIn = new StringReader(text);
        BufferedReader in = new BufferedReader(strIn);
        String line = null;
        BasicAttributes attributes = new BasicAttributes(true);
        try {
            while ((line = in.readLine()) != null) {
                String addedLine;
                if (line.length() == 0 || StringTools.isEmpty((String)(addedLine = line.trim()))) continue;
                Attribute attribute = LdifReader.parseAttributeValue((String)addedLine);
                Attribute oldAttribute = attributes.get(attribute.getID());
                if (oldAttribute != null) {
                    try {
                        oldAttribute.add(attribute.get());
                        attributes.put(oldAttribute);
                        continue;
                    }
                    catch (NamingException ne) {
                        continue;
                    }
                }
                attributes.put(attribute);
            }
            return attributes;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return attributes;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            text = "";
        }
        this.setValue(this.readEntry(text));
    }
}

