/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStore
implements Store {
    protected static final int TOO_LARGE_TO_EFFICIENTLY_ITERATE = 5;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int CONCURRENCY_LEVEL = 100;
    private static final int JUMP_AHEAD = 5;
    private static final Logger LOG = LoggerFactory.getLogger((String)MemoryStore.class.getName());
    protected Ehcache cache;
    protected final boolean useKeySample;
    protected Map map;
    protected final Store diskStore;
    protected final int maximumSize;
    protected volatile Status status = Status.STATUS_UNINITIALISED;
    protected volatile Policy policy;
    private AtomicReferenceArray<Object> keyArray;
    private AtomicInteger keySamplePointer;

    protected MemoryStore(Ehcache cache, Store diskStore) {
        this.cache = cache;
        this.maximumSize = cache.getCacheConfiguration().getMaxElementsInMemory();
        this.diskStore = diskStore;
        this.policy = this.determineEvictionPolicy();
        int initialCapacity = MemoryStore.getInitialCapacityForLoadFactor(this.maximumSize, 0.75f);
        this.map = new ConcurrentHashMap(initialCapacity, 0.75f, 100);
        if (this.maximumSize > 5) {
            this.useKeySample = true;
            this.keyArray = new AtomicReferenceArray(this.maximumSize);
            this.keySamplePointer = new AtomicInteger(0);
        } else {
            this.useKeySample = false;
            this.keyArray = null;
            this.keySamplePointer = null;
        }
        this.status = Status.STATUS_ALIVE;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialized " + this.getClass().getName() + " for " + cache.getName());
        }
    }

    static int getInitialCapacityForLoadFactor(int maximumSizeGoal, float loadFactor) {
        double actualMaximum = Math.ceil((float)maximumSizeGoal / loadFactor);
        return Math.max(0, actualMaximum >= 2.147483647E9 ? Integer.MAX_VALUE : (int)actualMaximum);
    }

    public static MemoryStore create(Ehcache cache, Store diskStore) {
        MemoryStore memoryStore = new MemoryStore(cache, diskStore);
        return memoryStore;
    }

    public final synchronized void put(Element element) throws CacheException {
        if (element != null) {
            this.map.put(element.getObjectKey(), element);
            this.doPut(element);
        }
    }

    public final Element get(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.get(key);
    }

    public final Element getQuiet(Object key) {
        return this.get(key);
    }

    public final Element remove(Object key) {
        if (key == null) {
            return null;
        }
        Element element = (Element)this.map.remove(key);
        if (element != null) {
            return element;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + "Cache: Cannot remove entry as key " + key + " was not found");
        }
        return null;
    }

    public final boolean bufferFull() {
        return false;
    }

    public void expireElements() {
    }

    protected final Policy determineEvictionPolicy() {
        MemoryStoreEvictionPolicy policySelection = this.cache.getCacheConfiguration().getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            return new FifoPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            return new LfuPolicy();
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    public final void removeAll() throws CacheException {
        this.clear();
    }

    protected final void clear() {
        this.map.clear();
        if (this.useKeySample) {
            for (int i = 0; i < this.keyArray.length(); ++i) {
                this.keyArray.set(i, null);
            }
        }
    }

    public final synchronized void dispose() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            return;
        }
        this.status = Status.STATUS_SHUTDOWN;
        this.flush();
        this.cache = null;
        this.map = null;
        this.keyArray = null;
        this.keySamplePointer = null;
    }

    public final void flush() {
        if (this.cache.getCacheConfiguration().isDiskPersistent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.cache.getName() + " is persistent. Spooling " + this.map.size() + " elements to the disk store.");
            }
            this.spoolAllToDisk();
        }
        if (this.cache.getCacheConfiguration().isClearOnFlush()) {
            this.clear();
        }
    }

    protected final void spoolAllToDisk() {
        Object[] keys;
        boolean clearOnFlush = this.cache.getCacheConfiguration().isClearOnFlush();
        for (Object key : keys = this.getKeyArray()) {
            Element element = (Element)this.map.get(key);
            if (element == null) continue;
            if (!element.isSerializable()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Object with key " + element.getObjectKey() + " is not Serializable and is not being overflowed to disk.");
                continue;
            }
            this.spoolToDisk(element);
            if (!clearOnFlush) continue;
            this.remove(key);
        }
    }

    protected void spoolToDisk(Element element) {
        this.diskStore.put(element);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + "Cache: spool to disk done for: " + element.getObjectKey());
        }
    }

    public final Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    public final int getSize() {
        return this.map.size();
    }

    public final int getTerracottaClusteredSize() {
        return 0;
    }

    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public final long getSizeInBytes() throws CacheException {
        long sizeInBytes = 0L;
        for (Object o : this.map.values()) {
            Element element = (Element)o;
            if (element == null) continue;
            sizeInBytes += element.getSerializedSize();
        }
        return sizeInBytes;
    }

    protected final void evict(Element element) throws CacheException {
        boolean spooled = false;
        if (this.cache.getCacheConfiguration().isOverflowToDisk()) {
            if (!element.isSerializable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object with key " + element.getObjectKey() + " is not Serializable and cannot be overflowed to disk");
                }
            } else {
                this.spoolToDisk(element);
                spooled = true;
            }
        }
        if (!spooled) {
            this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
        }
    }

    protected final void notifyExpiry(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    protected final boolean isFull() {
        return this.map.size() > this.maximumSize;
    }

    Map getBackingMap() {
        return this.map;
    }

    protected void doPut(Element elementJustAdded) {
        if (this.isFull()) {
            this.removeElementChosenByEvictionPolicy(elementJustAdded);
        }
        if (this.useKeySample) {
            this.saveKey(elementJustAdded);
        }
    }

    protected void saveKey(Element elementJustAdded) {
        int index = this.incrementIndex();
        Object key = this.keyArray.get(index);
        Element oldElement = null;
        if (key != null) {
            oldElement = (Element)this.map.get(key);
        }
        if (oldElement != null && !oldElement.isExpired()) {
            if (this.policy.compare(oldElement, elementJustAdded)) {
                this.keyArray.set(index, elementJustAdded.getObjectKey());
            }
        } else {
            this.keyArray.set(index, elementJustAdded.getObjectKey());
        }
    }

    protected int incrementIndex() {
        int newVal;
        int oldVal;
        do {
            if ((newVal = (oldVal = this.keySamplePointer.get()) + 1) <= this.keyArray.length() - 1) continue;
            newVal = 0;
        } while (!this.keySamplePointer.compareAndSet(oldVal, newVal));
        return newVal;
    }

    protected void removeElementChosenByEvictionPolicy(Element elementJustAdded) {
        LOG.debug("Cache is full. Removing element ...");
        Element element = this.findEvictionCandidate(elementJustAdded);
        if (element == null) {
            LOG.debug("Eviction selection miss. Selected element is null");
            return;
        }
        if (element.isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return;
        }
        this.evict(element);
        this.remove(element.getObjectKey());
    }

    protected final Element findEvictionCandidate(Element elementJustAdded) {
        Element element = null;
        if (this.useKeySample) {
            Element[] elements = this.sampleElementsViaKeyArray();
            element = this.policy.selectedBasedOnPolicy(elements, elementJustAdded);
            if (element != null) {
                return element;
            }
            int startingIndex = this.keySamplePointer.get();
            int counter = startingIndex + 5;
            int failsafeCounter = this.maximumSize;
            do {
                Object key;
                if (counter > this.keyArray.length() - 1) {
                    counter = 0;
                }
                if ((key = this.keyArray.get(counter)) != null && (element = (Element)this.map.get(key)) != null) {
                    return element;
                }
                ++counter;
            } while (failsafeCounter-- >= 0);
            return elementJustAdded;
        }
        Element[] elements = this.sampleElements(this.map.size());
        return this.policy.selectedBasedOnPolicy(elements, elementJustAdded);
    }

    protected Element[] sampleElementsViaKeyArray() {
        int[] indices = LfuPolicy.generateRandomSampleIndices(this.maximumSize);
        Element[] elements = new Element[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            Object key = this.keyArray.get(indices[i]);
            if (key == null) continue;
            elements[i] = (Element)this.map.get(key);
        }
        return elements;
    }

    protected Element[] sampleElements(int size) {
        int[] offsets = LfuPolicy.generateRandomSample(size);
        Element[] elements = new Element[offsets.length];
        Iterator iterator = this.map.values().iterator();
        for (int i = 0; i < offsets.length; ++i) {
            for (int j = 0; j < offsets[i]; ++j) {
                try {
                    iterator.next();
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            try {
                elements[i] = (Element)iterator.next();
                continue;
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        return elements;
    }

    public Policy getEvictionPolicy() {
        return this.policy;
    }

    public void setEvictionPolicy(Policy policy) {
        this.policy = policy;
    }

    public Object getInternalContext() {
        return null;
    }

    public final Status getStatus() {
        return this.status;
    }

    public boolean isCacheCoherent() {
        return false;
    }
}

