/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.OperationManager;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerEntryUtils;
import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.event.NotificationCriteria;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetRootDSEOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.jndi.EventListenerAdapter;
import org.apache.directory.server.core.jndi.JavaLdapSupport;
import org.apache.directory.server.core.jndi.JndiUtils;
import org.apache.directory.server.core.jndi.LdapJndiProperties;
import org.apache.directory.server.core.jndi.NamingEnumerationAdapter;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.cursor.Cursor;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.cursor.SingletonCursor;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerContext
implements EventContext {
    public static final String DELETE_OLD_RDN_PROP = "java.naming.ldap.deleteRDN";
    protected static final Control[] EMPTY_CONTROLS = new Control[0];
    private final DirectoryService service;
    private final Hashtable<String, Object> env;
    private final LdapDN dn;
    private final Map<NamingListener, DirectoryListener> listeners = new HashMap<NamingListener, DirectoryListener>();
    protected Control[] requestControls = EMPTY_CONTROLS;
    protected Control[] responseControls = EMPTY_CONTROLS;
    protected Control[] connectControls = EMPTY_CONTROLS;
    private final CoreSession session;

    protected ServerContext(DirectoryService service, Hashtable<String, Object> env) throws Exception {
        this.service = service;
        this.env = env;
        LdapJndiProperties props = LdapJndiProperties.getLdapJndiProperties(this.env);
        this.dn = props.getProviderDn();
        BindOperationContext opContext = this.doBindOperation(props.getBindDn(), props.getCredentials(), props.getSaslMechanism(), props.getSaslAuthId());
        this.session = opContext.getSession();
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(this.session, this.dn))) {
            throw new NameNotFoundException(this.dn + " does not exist");
        }
    }

    public ServerContext(DirectoryService service, LdapPrincipal principal, Name dn) throws Exception {
        this.service = service;
        this.dn = (LdapDN)dn.clone();
        this.env = new Hashtable();
        this.env.put("java.naming.provider.url", dn.toString());
        this.env.put(DirectoryService.JNDI_KEY, service);
        this.session = new DefaultCoreSession(principal, service);
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(this.session, (LdapDN)dn))) {
            throw new NameNotFoundException(dn + " does not exist");
        }
    }

    public ServerContext(DirectoryService service, CoreSession session, Name dn) throws Exception {
        this.service = service;
        this.dn = (LdapDN)dn.clone();
        this.env = new Hashtable();
        this.env.put("java.naming.provider.url", dn.toString());
        this.env.put(DirectoryService.JNDI_KEY, service);
        this.session = session;
        OperationManager operationManager = service.getOperationManager();
        if (!operationManager.hasEntry(new EntryOperationContext(session, (LdapDN)dn))) {
            throw new NameNotFoundException(dn + " does not exist");
        }
    }

    protected void injectReferralControl(OperationContext opCtx) {
        if ("ignore".equalsIgnoreCase((String)this.env.get("java.naming.referral"))) {
            opCtx.ignoreReferral();
        } else if ("throw".equalsIgnoreCase((String)this.env.get("java.naming.referral"))) {
            opCtx.throwReferral();
        } else {
            opCtx.throwReferral();
        }
    }

    protected void doAddOperation(LdapDN target, ServerEntry entry) throws Exception {
        AddOperationContext opCtx = new AddOperationContext(this.session, entry);
        opCtx.addRequestControls(this.requestControls);
        this.injectReferralControl((OperationContext)opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.add(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doDeleteOperation(LdapDN target) throws Exception {
        DeleteOperationContext opCtx = new DeleteOperationContext(this.session, target);
        opCtx.addRequestControls(this.requestControls);
        this.injectReferralControl((OperationContext)opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.delete(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected EntryFilteringCursor doSearchOperation(LdapDN dn, AliasDerefMode aliasDerefMode, ExprNode filter, SearchControls searchControls) throws Exception {
        OperationManager operationManager = this.service.getOperationManager();
        EntryFilteringCursor results = null;
        if (searchControls.getSearchScope() == 0 && searchControls.getReturningAttributes() != null && searchControls.getReturningAttributes().length == 0 && filter instanceof EqualityNode) {
            CompareOperationContext opContext = new CompareOperationContext(this.session, dn, ((EqualityNode)filter).getAttribute(), ((EqualityNode)filter).getValue());
            this.injectReferralControl((OperationContext)opContext);
            boolean result = operationManager.compare(opContext);
            opContext = new SearchOperationContext(this.session, dn, aliasDerefMode, filter, searchControls);
            opContext.addRequestControls(this.requestControls);
            if (result) {
                DefaultServerEntry emptyEntry = new DefaultServerEntry(this.service.getRegistries(), LdapDN.EMPTY_LDAPDN);
                return new BaseEntryFilteringCursor((Cursor)new SingletonCursor((Object)emptyEntry), (SearchingOperationContext)((SearchOperationContext)opContext));
            }
            return new BaseEntryFilteringCursor((Cursor)new EmptyCursor(), (SearchingOperationContext)((SearchOperationContext)opContext));
        }
        SearchOperationContext opContext = new SearchOperationContext(this.session, dn, aliasDerefMode, filter, searchControls);
        opContext.addRequestControls(this.requestControls);
        this.injectReferralControl((OperationContext)opContext);
        results = operationManager.search(opContext);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opContext.getResponseControls();
        return results;
    }

    protected EntryFilteringCursor doListOperation(LdapDN target) throws Exception {
        ListOperationContext opCtx = new ListOperationContext(this.session, target);
        opCtx.addRequestControls(this.requestControls);
        OperationManager operationManager = this.service.getOperationManager();
        EntryFilteringCursor results = operationManager.list(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
        return results;
    }

    protected ServerEntry doGetRootDSEOperation(LdapDN target) throws Exception {
        GetRootDSEOperationContext opCtx = new GetRootDSEOperationContext(this.session, target);
        opCtx.addRequestControls(this.requestControls);
        OperationManager operationManager = this.service.getOperationManager();
        return operationManager.getRootDSE(opCtx);
    }

    protected ServerEntry doLookupOperation(LdapDN target) throws Exception {
        LookupOperationContext opCtx = new LookupOperationContext(this.session, target);
        opCtx.addRequestControls(this.requestControls);
        OperationManager operationManager = this.service.getOperationManager();
        ClonedServerEntry serverEntry = operationManager.lookup(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
        return serverEntry;
    }

    protected ServerEntry doLookupOperation(LdapDN target, String[] attrIds) throws Exception {
        LookupOperationContext opCtx = new LookupOperationContext(this.session, target, attrIds);
        opCtx.addRequestControls(this.requestControls);
        OperationManager operationManager = this.service.getOperationManager();
        ClonedServerEntry serverEntry = operationManager.lookup(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
        if (opCtx.getAttrsId() != null && opCtx.getAttrsId().size() != 0 && serverEntry.get("objectClass") != null && serverEntry.get("objectClass").size() == 0) {
            serverEntry.removeAttributes(new String[]{"objectClass"});
        }
        return serverEntry;
    }

    protected BindOperationContext doBindOperation(LdapDN bindDn, byte[] credentials, String saslMechanism, String saslAuthId) throws Exception {
        BindOperationContext opCtx = new BindOperationContext(null);
        opCtx.setDn(bindDn);
        opCtx.setCredentials(credentials);
        opCtx.setSaslMechanism(saslMechanism);
        opCtx.setSaslAuthId(saslAuthId);
        opCtx.addRequestControls(this.requestControls);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.bind(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
        return opCtx;
    }

    protected void doMoveAndRenameOperation(LdapDN oldDn, LdapDN parent, String newRdn, boolean delOldDn) throws Exception {
        MoveAndRenameOperationContext opCtx = new MoveAndRenameOperationContext(this.session, oldDn, parent, new Rdn(newRdn), delOldDn);
        opCtx.addRequestControls(this.requestControls);
        this.injectReferralControl((OperationContext)opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.moveAndRename(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doModifyOperation(LdapDN dn, List<Modification> modifications) throws Exception {
        ModifyOperationContext opCtx = new ModifyOperationContext(this.session, dn, modifications);
        opCtx.addRequestControls(this.requestControls);
        this.injectReferralControl((OperationContext)opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.modify(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doMove(LdapDN oldDn, LdapDN target) throws Exception {
        MoveOperationContext opCtx = new MoveOperationContext(this.session, oldDn, target);
        opCtx.addRequestControls(this.requestControls);
        this.injectReferralControl((OperationContext)opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.move(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    protected void doRename(LdapDN oldDn, String newRdn, boolean delOldRdn) throws Exception {
        RenameOperationContext opCtx = new RenameOperationContext(this.session, oldDn, new Rdn(newRdn), delOldRdn);
        opCtx.addRequestControls(this.requestControls);
        this.injectReferralControl((OperationContext)opCtx);
        OperationManager operationManager = this.service.getOperationManager();
        operationManager.rename(opCtx);
        this.requestControls = EMPTY_CONTROLS;
        this.responseControls = opCtx.getResponseControls();
    }

    public CoreSession getSession() {
        return this.session;
    }

    public DirectoryService getDirectoryService() {
        return this.service;
    }

    public abstract ServerContext getRootContext() throws NamingException;

    public DirectoryService getService() {
        return this.service;
    }

    protected Name getDn() {
        return this.dn;
    }

    @Override
    public void close() throws NamingException {
        for (DirectoryListener listener : this.listeners.values()) {
            try {
                this.service.getEventService().removeListener(listener);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        }
        this.listeners.clear();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.dn.getUpName();
    }

    public Hashtable<String, Object> getEnvironment() {
        return this.env;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext((Name)new LdapDN(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        LdapDN target = this.buildTarget(name);
        ServerEntry serverEntry = this.service.newEntry(target);
        serverEntry.add("objectClass", new String[]{"top", "javaContainer"});
        Rdn rdn = target.getRdn();
        if (rdn != null) {
            if (!"cn".equals(rdn.getNormType())) {
                throw new LdapSchemaViolationException(name + " does not contains the mandatory 'cn' attribute for JavaContainer ObjectClass!", ResultCodeEnum.OBJECT_CLASS_VIOLATION);
            }
        } else {
            throw new LdapSchemaViolationException(name + " does not contains the mandatory 'cn' attribute for JavaContainer ObjectClass!", ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        serverEntry.put(rdn.getUpType(), new String[]{rdn.getUpValue()});
        try {
            this.doAddOperation(target, serverEntry);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.service, this.session.getEffectivePrincipal(), target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext((Name)new LdapDN(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        LdapDN target = this.buildTarget(name);
        if (target.size() == 0) {
            throw new LdapNoPermissionException("can't delete the rootDSE");
        }
        try {
            this.doDeleteOperation(target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind((Name)new LdapDN(name), obj);
    }

    private void injectRdnAttributeValues(LdapDN target, ServerEntry serverEntry) throws NamingException {
        Rdn rdn = target.getRdn(target.size() - 1);
        if (rdn.size() == 1) {
            serverEntry.put(rdn.getUpType(), new String[]{(String)rdn.getValue()});
        } else {
            for (AttributeTypeAndValue atav : rdn) {
                serverEntry.put(atav.getUpType(), new String[]{atav.getNormValue().getString()});
            }
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.env, null);
        LdapDN target = this.buildTarget(name);
        ServerEntry outServerEntry = ServerEntryUtils.toServerEntry((Attributes)AttributeUtils.toCaseInsensitive((Attributes)res.getAttributes()), (LdapDN)target, (Registries)this.service.getRegistries());
        if (outServerEntry != null) {
            try {
                this.doAddOperation(target, outServerEntry);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
            return;
        }
        if (obj instanceof ServerEntry) {
            try {
                this.doAddOperation(target, (ServerEntry)obj);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else {
            if (obj instanceof Referenceable) {
                throw new NamingException("Do not know how to store Referenceables yet!");
            }
            if (obj instanceof Reference) {
                throw new NamingException("Do not know how to store References yet!");
            }
            if (obj instanceof Serializable) {
                ServerEntry serverEntry = this.service.newEntry(target);
                if (outServerEntry != null && outServerEntry.size() > 0) {
                    for (EntryAttribute serverAttribute : outServerEntry) {
                        serverEntry.put(new EntryAttribute[]{serverAttribute});
                    }
                }
                this.injectRdnAttributeValues(target, serverEntry);
                JavaLdapSupport.serialize(serverEntry, obj, this.service.getRegistries());
                try {
                    this.doAddOperation(target, serverEntry);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                }
            } else if (obj instanceof DirContext) {
                ServerEntry serverEntry = ServerEntryUtils.toServerEntry((Attributes)((DirContext)obj).getAttributes(""), (LdapDN)target, (Registries)this.service.getRegistries());
                if (outServerEntry != null && outServerEntry.size() > 0) {
                    for (EntryAttribute serverAttribute : outServerEntry) {
                        serverEntry.put(new EntryAttribute[]{serverAttribute});
                    }
                }
                this.injectRdnAttributeValues(target, serverEntry);
                try {
                    this.doAddOperation(target, serverEntry);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                }
            } else {
                throw new NamingException("Can't find a way to bind: " + obj);
            }
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename((Name)new LdapDN(oldName), (Name)new LdapDN(newName));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        LdapDN oldDn = this.buildTarget(oldName);
        LdapDN newDn = this.buildTarget(newName);
        if (oldDn.size() == 0) {
            throw new LdapNoPermissionException("can't rename the rootDSE");
        }
        LdapDN oldBase = (LdapDN)oldName.clone();
        oldBase.remove(oldName.size() - 1);
        LdapDN newBase = (LdapDN)newName.clone();
        newBase.remove(newName.size() - 1);
        String newRdn = newName.get(newName.size() - 1);
        String oldRdn = oldName.get(oldName.size() - 1);
        boolean delOldRdn = true;
        if (null != this.env.get(DELETE_OLD_RDN_PROP)) {
            String delOldRdnStr = (String)this.env.get(DELETE_OLD_RDN_PROP);
            boolean bl = delOldRdn = !delOldRdnStr.equalsIgnoreCase("false") && !delOldRdnStr.equalsIgnoreCase("no") && !delOldRdnStr.equals("0");
        }
        if (oldName.size() == newName.size() && oldBase.equals((Object)newBase)) {
            try {
                this.doRename(oldDn, newRdn, delOldRdn);
            }
            catch (Exception e) {
                JndiUtils.wrap(e);
            }
        } else {
            LdapDN target = (LdapDN)newDn.clone();
            target.remove(newDn.size() - 1);
            if (newRdn.equalsIgnoreCase(oldRdn)) {
                try {
                    this.doMove(oldDn, target);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                }
            } else {
                try {
                    this.doMoveAndRenameOperation(oldDn, target, newRdn, delOldRdn);
                }
                catch (Exception e) {
                    JndiUtils.wrap(e);
                }
            }
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind((Name)new LdapDN(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        LdapDN target = this.buildTarget(name);
        OperationManager operationManager = this.service.getOperationManager();
        try {
            if (operationManager.hasEntry(new EntryOperationContext(this.session, target))) {
                this.doDeleteOperation(target);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        this.bind(name, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind((Name)new LdapDN(name));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        try {
            this.doDeleteOperation(this.buildTarget(name));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (StringTools.isEmpty((String)name)) {
            return this.lookup((Name)LdapDN.EMPTY_LDAPDN);
        }
        return this.lookup((Name)new LdapDN(name));
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Object obj;
        LdapDN target = this.buildTarget(name);
        ServerEntry serverEntry = null;
        try {
            serverEntry = name.size() == 0 ? this.doGetRootDSEOperation(target) : this.doLookupOperation(target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        try {
            obj = DirectoryManager.getObjectInstance(null, name, this, this.env, ServerEntryUtils.toBasicAttributes((ServerEntry)serverEntry));
        }
        catch (Exception e) {
            String msg = "Failed to create an object for " + target;
            msg = msg + " using object factories within the context's environment.";
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        if (obj != null) {
            return obj;
        }
        if (serverEntry.get("javaClassName") != null) {
            return JavaLdapSupport.deserialize(serverEntry);
        }
        ServerLdapContext ctx = null;
        try {
            ctx = new ServerLdapContext(this.service, this.session.getEffectivePrincipal(), target);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
        return ctx;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new NameParser(){

            public Name parse(String name) throws NamingException {
                return new LdapDN(name);
            }
        };
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParser(){

            public Name parse(String name) throws NamingException {
                return new LdapDN(name);
            }
        };
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list((Name)new LdapDN(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        try {
            return new NamingEnumerationAdapter(this.doListOperation(this.buildTarget(name)));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings((Name)new LdapDN(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        LdapDN base = this.buildTarget(name);
        PresenceNode filter = new PresenceNode("objectClass");
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        AliasDerefMode aliasDerefMode = AliasDerefMode.getEnum(this.getEnvironment());
        try {
            return new NamingEnumerationAdapter(this.doSearchOperation(base, aliasDerefMode, (ExprNode)filter, ctls));
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
            return null;
        }
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName((Name)new LdapDN(name), (Name)new LdapDN(prefix)).toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (prefix == null || prefix.size() == 0) {
            return name;
        }
        LdapDN fqn = this.buildTarget(name);
        String head = prefix.get(0);
        while (fqn.size() > 0) {
            if (fqn.get(0).equalsIgnoreCase(head)) {
                return fqn;
            }
            fqn.remove(0);
        }
        String msg = "The prefix '" + prefix + "' is not an ancestor of this ";
        msg = msg + "entry '" + this.dn + "'";
        throw new NamingException(msg);
    }

    @Override
    public void addNamingListener(Name name, int scope, NamingListener namingListener) throws NamingException {
        PresenceNode filter = new PresenceNode("objectClass");
        try {
            EventListenerAdapter listener = new EventListenerAdapter((ServerLdapContext)this, namingListener);
            NotificationCriteria criteria = new NotificationCriteria();
            criteria.setFilter((ExprNode)filter);
            criteria.setScope(SearchScope.getSearchScope((int)scope));
            criteria.setAliasDerefMode(AliasDerefMode.getEnum(this.env));
            criteria.setBase(this.buildTarget(name));
            this.service.getEventService().addListener((DirectoryListener)listener);
            this.listeners.put(namingListener, listener);
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public void addNamingListener(String name, int scope, NamingListener namingListener) throws NamingException {
        this.addNamingListener((Name)new LdapDN(name), scope, namingListener);
    }

    @Override
    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        try {
            DirectoryListener listener = this.listeners.remove(namingListener);
            if (listener != null) {
                this.service.getEventService().removeListener(listener);
            }
        }
        catch (Exception e) {
            JndiUtils.wrap(e);
        }
    }

    @Override
    public boolean targetMustExist() throws NamingException {
        return false;
    }

    protected Map<NamingListener, DirectoryListener> getListeners() {
        return this.listeners;
    }

    LdapDN buildTarget(Name relativeName) throws InvalidNameException {
        LdapDN target = (LdapDN)this.dn.clone();
        target.addAllNormalized(target.size(), relativeName);
        return target;
    }
}

