/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexAssertionEnumeration
implements NamingEnumeration<IndexEntry> {
    private final ForwardIndexEntry prefetched = new ForwardIndexEntry();
    private final ForwardIndexEntry candidate = new ForwardIndexEntry();
    private final NamingEnumeration<ForwardIndexEntry> underlying;
    private final Map<Object, Object> candidates;
    private final IndexAssertion assertion;
    private final boolean checkDups;
    private boolean hasMore = true;

    public IndexAssertionEnumeration(NamingEnumeration<ForwardIndexEntry> underlying, IndexAssertion assertion) throws NamingException {
        this.underlying = underlying;
        this.candidates = null;
        this.assertion = assertion;
        this.checkDups = false;
        this.prefetch();
    }

    public IndexAssertionEnumeration(NamingEnumeration<ForwardIndexEntry> underlying, IndexAssertion assertion, boolean enableDupCheck) throws NamingException {
        this.underlying = underlying;
        this.candidates = new HashMap<Object, Object>();
        this.assertion = assertion;
        this.checkDups = enableDupCheck;
        this.prefetch();
    }

    @Override
    public IndexEntry nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore;
    }

    @Override
    public IndexEntry next() throws NamingException {
        this.candidate.copy(this.prefetched);
        this.prefetch();
        return this.candidate;
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public void close() throws NamingException {
        this.hasMore = false;
        this.underlying.close();
    }

    private void prefetch() throws NamingException {
        IndexEntry rec = null;
        while (this.underlying.hasMore()) {
            rec = this.underlying.next();
            try {
                if (!this.assertion.assertCandidate(rec)) continue;
                if (this.checkDups) {
                    boolean dup = this.candidates.containsKey(rec.getId());
                    if (dup) continue;
                    this.prefetched.copy(rec);
                    this.candidates.put(rec.getId(), rec.getId());
                    return;
                }
                this.prefetched.copy(rec);
                return;
            }
            catch (Exception e) {
                NamingException ne = new NamingException();
                ne.setRootCause(e);
                throw ne;
            }
        }
        this.close();
    }
}

